import { Construct } from 'constructs';
import { TaskDefinition } from './base/task-definition';
import { ContainerDefinition, ContainerDefinitionOptions, ContainerDefinitionProps } from './container-definition';
import { ContainerImage } from './container-image';
import { CfnTaskDefinition } from './ecs.generated';
import { LogDriverConfig } from './log-drivers/log-driver';
/**
 * (experimental) Firelens log router type, fluentbit or fluentd.
 *
 * https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html
 *
 * @experimental
 */
export declare enum FirelensLogRouterType {
    /**
     * (experimental) fluentbit.
     *
     * @experimental
     */
    FLUENTBIT = "fluentbit",
    /**
     * (experimental) fluentd.
     *
     * @experimental
     */
    FLUENTD = "fluentd"
}
/**
 * (experimental) Firelens configuration file type, s3 or file path.
 *
 * https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html#firelens-taskdef-customconfig
 *
 * @experimental
 */
export declare enum FirelensConfigFileType {
    /**
     * (experimental) s3.
     *
     * @experimental
     */
    S3 = "s3",
    /**
     * (experimental) fluentd.
     *
     * @experimental
     */
    FILE = "file"
}
/**
 * (experimental) The options for firelens log router https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html#firelens-taskdef-customconfig.
 *
 * @experimental
 */
export interface FirelensOptions {
    /**
     * (experimental) By default, Amazon ECS adds additional fields in your log entries that help identify the source of the logs.
     *
     * You can disable this action by setting enable-ecs-log-metadata to false.
     *
     * @default - true
     * @experimental
     */
    readonly enableECSLogMetadata?: boolean;
    /**
     * (experimental) Custom configuration file, s3 or file.
     *
     * @default - determined by checking configFileValue with S3 ARN.
     * @experimental
     */
    readonly configFileType?: FirelensConfigFileType;
    /**
     * (experimental) Custom configuration file, S3 ARN or a file path.
     *
     * @experimental
     */
    readonly configFileValue: string;
}
/**
 * (experimental) Firelens Configuration https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html#firelens-taskdef.
 *
 * @experimental
 */
export interface FirelensConfig {
    /**
     * (experimental) The log router to use.
     *
     * @default - fluentbit
     * @experimental
     */
    readonly type: FirelensLogRouterType;
    /**
     * (experimental) Firelens options.
     *
     * @default - no additional options
     * @experimental
     */
    readonly options?: FirelensOptions;
}
/**
 * (experimental) The properties in a firelens log router.
 *
 * @experimental
 */
export interface FirelensLogRouterProps extends ContainerDefinitionProps {
    /**
     * (experimental) Firelens configuration.
     *
     * @experimental
     */
    readonly firelensConfig: FirelensConfig;
}
/**
 * (experimental) The options for creating a firelens log router.
 *
 * @experimental
 */
export interface FirelensLogRouterDefinitionOptions extends ContainerDefinitionOptions {
    /**
     * (experimental) Firelens configuration.
     *
     * @experimental
     */
    readonly firelensConfig: FirelensConfig;
}
/**
 * Obtain Fluent Bit image in Amazon ECR and setup corresponding IAM permissions.
 * ECR image pull permissions will be granted in task execution role.
 * Cloudwatch logs, Kinesis data stream or firehose permissions will be grant by check options in logDriverConfig.
 * https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html#firelens-using-fluentbit
 */
export declare function obtainDefaultFluentBitECRImage(task: TaskDefinition, logDriverConfig?: LogDriverConfig, imageTag?: string): ContainerImage;
/**
 * (experimental) Firelens log router.
 *
 * @experimental
 */
export declare class FirelensLogRouter extends ContainerDefinition {
    /**
     * (experimental) Firelens configuration.
     *
     * @experimental
     */
    readonly firelensConfig: FirelensConfig;
    /**
     * (experimental) Constructs a new instance of the FirelensLogRouter class.
     *
     * @experimental
     */
    constructor(scope: Construct, id: string, props: FirelensLogRouterProps);
    /**
     * (experimental) Render this container definition to a CloudFormation object.
     *
     * @experimental
     */
    renderContainerDefinition(_taskDefinition?: TaskDefinition): CfnTaskDefinition.ContainerDefinitionProperty;
}
