import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::ECS::CapacityProvider`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html
 * @external
 */
export interface CfnCapacityProviderProps {
    /**
     * `AWS::ECS::CapacityProvider.AutoScalingGroupProvider`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html#cfn-ecs-capacityprovider-autoscalinggroupprovider
     * @external
     */
    readonly autoScalingGroupProvider: CfnCapacityProvider.AutoScalingGroupProviderProperty | cdk.IResolvable;
    /**
     * `AWS::ECS::CapacityProvider.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html#cfn-ecs-capacityprovider-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::ECS::CapacityProvider.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html#cfn-ecs-capacityprovider-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::ECS::CapacityProvider`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html
 * @external
 * @cloudformationResource AWS::ECS::CapacityProvider
 */
export declare class CfnCapacityProvider extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ECS::CapacityProvider";
    /**
     * `AWS::ECS::CapacityProvider.AutoScalingGroupProvider`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html#cfn-ecs-capacityprovider-autoscalinggroupprovider
     * @external
     */
    autoScalingGroupProvider: CfnCapacityProvider.AutoScalingGroupProviderProperty | cdk.IResolvable;
    /**
     * `AWS::ECS::CapacityProvider.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html#cfn-ecs-capacityprovider-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::ECS::CapacityProvider.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html#cfn-ecs-capacityprovider-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::ECS::CapacityProvider`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCapacityProviderProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ECS::CapacityProvider`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html
 * @external
 * @cloudformationResource AWS::ECS::CapacityProvider
 */
export declare namespace CfnCapacityProvider {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-autoscalinggroupprovider.html
     * @external
     */
    interface AutoScalingGroupProviderProperty {
        /**
         * `CfnCapacityProvider.AutoScalingGroupProviderProperty.AutoScalingGroupArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-autoscalinggroupprovider.html#cfn-ecs-capacityprovider-autoscalinggroupprovider-autoscalinggrouparn
         * @external
         */
        readonly autoScalingGroupArn: string;
        /**
         * `CfnCapacityProvider.AutoScalingGroupProviderProperty.ManagedScaling`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-autoscalinggroupprovider.html#cfn-ecs-capacityprovider-autoscalinggroupprovider-managedscaling
         * @external
         */
        readonly managedScaling?: CfnCapacityProvider.ManagedScalingProperty | cdk.IResolvable;
        /**
         * `CfnCapacityProvider.AutoScalingGroupProviderProperty.ManagedTerminationProtection`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-autoscalinggroupprovider.html#cfn-ecs-capacityprovider-autoscalinggroupprovider-managedterminationprotection
         * @external
         */
        readonly managedTerminationProtection?: string;
    }
}
/**
 * A CloudFormation `AWS::ECS::CapacityProvider`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html
 * @external
 * @cloudformationResource AWS::ECS::CapacityProvider
 */
export declare namespace CfnCapacityProvider {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedscaling.html
     * @external
     */
    interface ManagedScalingProperty {
        /**
         * `CfnCapacityProvider.ManagedScalingProperty.MaximumScalingStepSize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedscaling.html#cfn-ecs-capacityprovider-managedscaling-maximumscalingstepsize
         * @external
         */
        readonly maximumScalingStepSize?: number;
        /**
         * `CfnCapacityProvider.ManagedScalingProperty.MinimumScalingStepSize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedscaling.html#cfn-ecs-capacityprovider-managedscaling-minimumscalingstepsize
         * @external
         */
        readonly minimumScalingStepSize?: number;
        /**
         * `CfnCapacityProvider.ManagedScalingProperty.Status`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedscaling.html#cfn-ecs-capacityprovider-managedscaling-status
         * @external
         */
        readonly status?: string;
        /**
         * `CfnCapacityProvider.ManagedScalingProperty.TargetCapacity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedscaling.html#cfn-ecs-capacityprovider-managedscaling-targetcapacity
         * @external
         */
        readonly targetCapacity?: number;
    }
}
/**
 * Properties for defining a `AWS::ECS::Cluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html
 * @external
 */
export interface CfnClusterProps {
    /**
     * `AWS::ECS::Cluster.CapacityProviders`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-capacityproviders
     * @external
     */
    readonly capacityProviders?: string[];
    /**
     * `AWS::ECS::Cluster.ClusterName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-clustername
     * @external
     */
    readonly clusterName?: string;
    /**
     * `AWS::ECS::Cluster.ClusterSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-clustersettings
     * @external
     */
    readonly clusterSettings?: Array<CfnCluster.ClusterSettingsProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ECS::Cluster.DefaultCapacityProviderStrategy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-defaultcapacityproviderstrategy
     * @external
     */
    readonly defaultCapacityProviderStrategy?: Array<CfnCluster.CapacityProviderStrategyItemProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ECS::Cluster.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::ECS::Cluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html
 * @external
 * @cloudformationResource AWS::ECS::Cluster
 */
export declare class CfnCluster extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ECS::Cluster";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::ECS::Cluster.CapacityProviders`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-capacityproviders
     * @external
     */
    capacityProviders: string[] | undefined;
    /**
     * `AWS::ECS::Cluster.ClusterName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-clustername
     * @external
     */
    clusterName: string | undefined;
    /**
     * `AWS::ECS::Cluster.ClusterSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-clustersettings
     * @external
     */
    clusterSettings: Array<CfnCluster.ClusterSettingsProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ECS::Cluster.DefaultCapacityProviderStrategy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-defaultcapacityproviderstrategy
     * @external
     */
    defaultCapacityProviderStrategy: Array<CfnCluster.CapacityProviderStrategyItemProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ECS::Cluster.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::ECS::Cluster`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnClusterProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ECS::Cluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html
 * @external
 * @cloudformationResource AWS::ECS::Cluster
 */
export declare namespace CfnCluster {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-capacityproviderstrategyitem.html
     * @external
     */
    interface CapacityProviderStrategyItemProperty {
        /**
         * `CfnCluster.CapacityProviderStrategyItemProperty.Base`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-capacityproviderstrategyitem.html#cfn-ecs-cluster-capacityproviderstrategyitem-base
         * @external
         */
        readonly base?: number;
        /**
         * `CfnCluster.CapacityProviderStrategyItemProperty.CapacityProvider`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-capacityproviderstrategyitem.html#cfn-ecs-cluster-capacityproviderstrategyitem-capacityprovider
         * @external
         */
        readonly capacityProvider?: string;
        /**
         * `CfnCluster.CapacityProviderStrategyItemProperty.Weight`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-capacityproviderstrategyitem.html#cfn-ecs-cluster-capacityproviderstrategyitem-weight
         * @external
         */
        readonly weight?: number;
    }
}
/**
 * A CloudFormation `AWS::ECS::Cluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html
 * @external
 * @cloudformationResource AWS::ECS::Cluster
 */
export declare namespace CfnCluster {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-clustersettings.html
     * @external
     */
    interface ClusterSettingsProperty {
        /**
         * `CfnCluster.ClusterSettingsProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-clustersettings.html#cfn-ecs-cluster-clustersettings-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnCluster.ClusterSettingsProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-clustersettings.html#cfn-ecs-cluster-clustersettings-value
         * @external
         */
        readonly value?: string;
    }
}
/**
 * Properties for defining a `AWS::ECS::PrimaryTaskSet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-primarytaskset.html
 * @external
 */
export interface CfnPrimaryTaskSetProps {
    /**
     * `AWS::ECS::PrimaryTaskSet.Cluster`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-primarytaskset.html#cfn-ecs-primarytaskset-cluster
     * @external
     */
    readonly cluster: string;
    /**
     * `AWS::ECS::PrimaryTaskSet.Service`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-primarytaskset.html#cfn-ecs-primarytaskset-service
     * @external
     */
    readonly service: string;
    /**
     * `AWS::ECS::PrimaryTaskSet.TaskSetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-primarytaskset.html#cfn-ecs-primarytaskset-tasksetid
     * @external
     */
    readonly taskSetId: string;
}
/**
 * A CloudFormation `AWS::ECS::PrimaryTaskSet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-primarytaskset.html
 * @external
 * @cloudformationResource AWS::ECS::PrimaryTaskSet
 */
export declare class CfnPrimaryTaskSet extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ECS::PrimaryTaskSet";
    /**
     * `AWS::ECS::PrimaryTaskSet.Cluster`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-primarytaskset.html#cfn-ecs-primarytaskset-cluster
     * @external
     */
    cluster: string;
    /**
     * `AWS::ECS::PrimaryTaskSet.Service`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-primarytaskset.html#cfn-ecs-primarytaskset-service
     * @external
     */
    service: string;
    /**
     * `AWS::ECS::PrimaryTaskSet.TaskSetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-primarytaskset.html#cfn-ecs-primarytaskset-tasksetid
     * @external
     */
    taskSetId: string;
    /**
     * Create a new `AWS::ECS::PrimaryTaskSet`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPrimaryTaskSetProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::ECS::Service`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html
 * @external
 */
export interface CfnServiceProps {
    /**
     * `AWS::ECS::Service.CapacityProviderStrategy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-capacityproviderstrategy
     * @external
     */
    readonly capacityProviderStrategy?: Array<CfnService.CapacityProviderStrategyItemProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ECS::Service.Cluster`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-cluster
     * @external
     */
    readonly cluster?: string;
    /**
     * `AWS::ECS::Service.DeploymentConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-deploymentconfiguration
     * @external
     */
    readonly deploymentConfiguration?: CfnService.DeploymentConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::ECS::Service.DeploymentController`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-deploymentcontroller
     * @external
     */
    readonly deploymentController?: CfnService.DeploymentControllerProperty | cdk.IResolvable;
    /**
     * `AWS::ECS::Service.DesiredCount`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-desiredcount
     * @external
     */
    readonly desiredCount?: number;
    /**
     * `AWS::ECS::Service.EnableECSManagedTags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-enableecsmanagedtags
     * @external
     */
    readonly enableEcsManagedTags?: boolean | cdk.IResolvable;
    /**
     * `AWS::ECS::Service.HealthCheckGracePeriodSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-healthcheckgraceperiodseconds
     * @external
     */
    readonly healthCheckGracePeriodSeconds?: number;
    /**
     * `AWS::ECS::Service.LaunchType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-launchtype
     * @external
     */
    readonly launchType?: string;
    /**
     * `AWS::ECS::Service.LoadBalancers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-loadbalancers
     * @external
     */
    readonly loadBalancers?: Array<CfnService.LoadBalancerProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ECS::Service.NetworkConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-networkconfiguration
     * @external
     */
    readonly networkConfiguration?: CfnService.NetworkConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::ECS::Service.PlacementConstraints`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-placementconstraints
     * @external
     */
    readonly placementConstraints?: Array<CfnService.PlacementConstraintProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ECS::Service.PlacementStrategies`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-placementstrategies
     * @external
     */
    readonly placementStrategies?: Array<CfnService.PlacementStrategyProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ECS::Service.PlatformVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-platformversion
     * @external
     */
    readonly platformVersion?: string;
    /**
     * `AWS::ECS::Service.PropagateTags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-propagatetags
     * @external
     */
    readonly propagateTags?: string;
    /**
     * `AWS::ECS::Service.Role`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-role
     * @external
     */
    readonly role?: string;
    /**
     * `AWS::ECS::Service.SchedulingStrategy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-schedulingstrategy
     * @external
     */
    readonly schedulingStrategy?: string;
    /**
     * `AWS::ECS::Service.ServiceArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-servicearn
     * @external
     */
    readonly serviceArn?: string;
    /**
     * `AWS::ECS::Service.ServiceName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-servicename
     * @external
     */
    readonly serviceName?: string;
    /**
     * `AWS::ECS::Service.ServiceRegistries`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-serviceregistries
     * @external
     */
    readonly serviceRegistries?: Array<CfnService.ServiceRegistryProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ECS::Service.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::ECS::Service.TaskDefinition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-taskdefinition
     * @external
     */
    readonly taskDefinition?: string;
}
/**
 * A CloudFormation `AWS::ECS::Service`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html
 * @external
 * @cloudformationResource AWS::ECS::Service
 */
export declare class CfnService extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ECS::Service";
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::ECS::Service.CapacityProviderStrategy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-capacityproviderstrategy
     * @external
     */
    capacityProviderStrategy: Array<CfnService.CapacityProviderStrategyItemProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ECS::Service.Cluster`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-cluster
     * @external
     */
    cluster: string | undefined;
    /**
     * `AWS::ECS::Service.DeploymentConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-deploymentconfiguration
     * @external
     */
    deploymentConfiguration: CfnService.DeploymentConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ECS::Service.DeploymentController`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-deploymentcontroller
     * @external
     */
    deploymentController: CfnService.DeploymentControllerProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ECS::Service.DesiredCount`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-desiredcount
     * @external
     */
    desiredCount: number | undefined;
    /**
     * `AWS::ECS::Service.EnableECSManagedTags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-enableecsmanagedtags
     * @external
     */
    enableEcsManagedTags: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ECS::Service.HealthCheckGracePeriodSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-healthcheckgraceperiodseconds
     * @external
     */
    healthCheckGracePeriodSeconds: number | undefined;
    /**
     * `AWS::ECS::Service.LaunchType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-launchtype
     * @external
     */
    launchType: string | undefined;
    /**
     * `AWS::ECS::Service.LoadBalancers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-loadbalancers
     * @external
     */
    loadBalancers: Array<CfnService.LoadBalancerProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ECS::Service.NetworkConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-networkconfiguration
     * @external
     */
    networkConfiguration: CfnService.NetworkConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ECS::Service.PlacementConstraints`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-placementconstraints
     * @external
     */
    placementConstraints: Array<CfnService.PlacementConstraintProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ECS::Service.PlacementStrategies`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-placementstrategies
     * @external
     */
    placementStrategies: Array<CfnService.PlacementStrategyProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ECS::Service.PlatformVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-platformversion
     * @external
     */
    platformVersion: string | undefined;
    /**
     * `AWS::ECS::Service.PropagateTags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-propagatetags
     * @external
     */
    propagateTags: string | undefined;
    /**
     * `AWS::ECS::Service.Role`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-role
     * @external
     */
    role: string | undefined;
    /**
     * `AWS::ECS::Service.SchedulingStrategy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-schedulingstrategy
     * @external
     */
    schedulingStrategy: string | undefined;
    /**
     * `AWS::ECS::Service.ServiceArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-servicearn
     * @external
     */
    serviceArn: string | undefined;
    /**
     * `AWS::ECS::Service.ServiceName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-servicename
     * @external
     */
    serviceName: string | undefined;
    /**
     * `AWS::ECS::Service.ServiceRegistries`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-serviceregistries
     * @external
     */
    serviceRegistries: Array<CfnService.ServiceRegistryProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ECS::Service.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::ECS::Service.TaskDefinition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-taskdefinition
     * @external
     */
    taskDefinition: string | undefined;
    /**
     * Create a new `AWS::ECS::Service`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnServiceProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ECS::Service`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html
 * @external
 * @cloudformationResource AWS::ECS::Service
 */
export declare namespace CfnService {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-awsvpcconfiguration.html
     * @external
     */
    interface AwsVpcConfigurationProperty {
        /**
         * `CfnService.AwsVpcConfigurationProperty.AssignPublicIp`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-awsvpcconfiguration.html#cfn-ecs-service-awsvpcconfiguration-assignpublicip
         * @external
         */
        readonly assignPublicIp?: string;
        /**
         * `CfnService.AwsVpcConfigurationProperty.SecurityGroups`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-awsvpcconfiguration.html#cfn-ecs-service-awsvpcconfiguration-securitygroups
         * @external
         */
        readonly securityGroups?: string[];
        /**
         * `CfnService.AwsVpcConfigurationProperty.Subnets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-awsvpcconfiguration.html#cfn-ecs-service-awsvpcconfiguration-subnets
         * @external
         */
        readonly subnets: string[];
    }
}
/**
 * A CloudFormation `AWS::ECS::Service`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html
 * @external
 * @cloudformationResource AWS::ECS::Service
 */
export declare namespace CfnService {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-capacityproviderstrategyitem.html
     * @external
     */
    interface CapacityProviderStrategyItemProperty {
        /**
         * `CfnService.CapacityProviderStrategyItemProperty.Base`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-capacityproviderstrategyitem.html#cfn-ecs-service-capacityproviderstrategyitem-base
         * @external
         */
        readonly base?: number;
        /**
         * `CfnService.CapacityProviderStrategyItemProperty.CapacityProvider`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-capacityproviderstrategyitem.html#cfn-ecs-service-capacityproviderstrategyitem-capacityprovider
         * @external
         */
        readonly capacityProvider?: string;
        /**
         * `CfnService.CapacityProviderStrategyItemProperty.Weight`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-capacityproviderstrategyitem.html#cfn-ecs-service-capacityproviderstrategyitem-weight
         * @external
         */
        readonly weight?: number;
    }
}
/**
 * A CloudFormation `AWS::ECS::Service`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html
 * @external
 * @cloudformationResource AWS::ECS::Service
 */
export declare namespace CfnService {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentconfiguration.html
     * @external
     */
    interface DeploymentConfigurationProperty {
        /**
         * `CfnService.DeploymentConfigurationProperty.MaximumPercent`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentconfiguration.html#cfn-ecs-service-deploymentconfiguration-maximumpercent
         * @external
         */
        readonly maximumPercent?: number;
        /**
         * `CfnService.DeploymentConfigurationProperty.MinimumHealthyPercent`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentconfiguration.html#cfn-ecs-service-deploymentconfiguration-minimumhealthypercent
         * @external
         */
        readonly minimumHealthyPercent?: number;
    }
}
/**
 * A CloudFormation `AWS::ECS::Service`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html
 * @external
 * @cloudformationResource AWS::ECS::Service
 */
export declare namespace CfnService {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentcontroller.html
     * @external
     */
    interface DeploymentControllerProperty {
        /**
         * `CfnService.DeploymentControllerProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentcontroller.html#cfn-ecs-service-deploymentcontroller-type
         * @external
         */
        readonly type?: string;
    }
}
/**
 * A CloudFormation `AWS::ECS::Service`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html
 * @external
 * @cloudformationResource AWS::ECS::Service
 */
export declare namespace CfnService {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-loadbalancer.html
     * @external
     */
    interface LoadBalancerProperty {
        /**
         * `CfnService.LoadBalancerProperty.ContainerName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-loadbalancer.html#cfn-ecs-service-loadbalancer-containername
         * @external
         */
        readonly containerName?: string;
        /**
         * `CfnService.LoadBalancerProperty.ContainerPort`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-loadbalancer.html#cfn-ecs-service-loadbalancer-containerport
         * @external
         */
        readonly containerPort: number;
        /**
         * `CfnService.LoadBalancerProperty.LoadBalancerName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-loadbalancer.html#cfn-ecs-service-loadbalancer-loadbalancername
         * @external
         */
        readonly loadBalancerName?: string;
        /**
         * `CfnService.LoadBalancerProperty.TargetGroupArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-loadbalancer.html#cfn-ecs-service-loadbalancer-targetgrouparn
         * @external
         */
        readonly targetGroupArn?: string;
    }
}
/**
 * A CloudFormation `AWS::ECS::Service`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html
 * @external
 * @cloudformationResource AWS::ECS::Service
 */
export declare namespace CfnService {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-networkconfiguration.html
     * @external
     */
    interface NetworkConfigurationProperty {
        /**
         * `CfnService.NetworkConfigurationProperty.AwsvpcConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-networkconfiguration.html#cfn-ecs-service-networkconfiguration-awsvpcconfiguration
         * @external
         */
        readonly awsvpcConfiguration?: CfnService.AwsVpcConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ECS::Service`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html
 * @external
 * @cloudformationResource AWS::ECS::Service
 */
export declare namespace CfnService {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-placementconstraint.html
     * @external
     */
    interface PlacementConstraintProperty {
        /**
         * `CfnService.PlacementConstraintProperty.Expression`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-placementconstraint.html#cfn-ecs-service-placementconstraint-expression
         * @external
         */
        readonly expression?: string;
        /**
         * `CfnService.PlacementConstraintProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-placementconstraint.html#cfn-ecs-service-placementconstraint-type
         * @external
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::ECS::Service`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html
 * @external
 * @cloudformationResource AWS::ECS::Service
 */
export declare namespace CfnService {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-placementstrategy.html
     * @external
     */
    interface PlacementStrategyProperty {
        /**
         * `CfnService.PlacementStrategyProperty.Field`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-placementstrategy.html#cfn-ecs-service-placementstrategy-field
         * @external
         */
        readonly field?: string;
        /**
         * `CfnService.PlacementStrategyProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-placementstrategy.html#cfn-ecs-service-placementstrategy-type
         * @external
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::ECS::Service`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html
 * @external
 * @cloudformationResource AWS::ECS::Service
 */
export declare namespace CfnService {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceregistry.html
     * @external
     */
    interface ServiceRegistryProperty {
        /**
         * `CfnService.ServiceRegistryProperty.ContainerName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceregistry.html#cfn-ecs-service-serviceregistry-containername
         * @external
         */
        readonly containerName?: string;
        /**
         * `CfnService.ServiceRegistryProperty.ContainerPort`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceregistry.html#cfn-ecs-service-serviceregistry-containerport
         * @external
         */
        readonly containerPort?: number;
        /**
         * `CfnService.ServiceRegistryProperty.Port`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceregistry.html#cfn-ecs-service-serviceregistry-port
         * @external
         */
        readonly port?: number;
        /**
         * `CfnService.ServiceRegistryProperty.RegistryArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceregistry.html#cfn-ecs-service-serviceregistry-registryarn
         * @external
         */
        readonly registryArn?: string;
    }
}
/**
 * Properties for defining a `AWS::ECS::TaskDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html
 * @external
 */
export interface CfnTaskDefinitionProps {
    /**
     * `AWS::ECS::TaskDefinition.ContainerDefinitions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-containerdefinitions
     * @external
     */
    readonly containerDefinitions?: Array<CfnTaskDefinition.ContainerDefinitionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ECS::TaskDefinition.Cpu`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-cpu
     * @external
     */
    readonly cpu?: string;
    /**
     * `AWS::ECS::TaskDefinition.ExecutionRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-executionrolearn
     * @external
     */
    readonly executionRoleArn?: string;
    /**
     * `AWS::ECS::TaskDefinition.Family`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-family
     * @external
     */
    readonly family?: string;
    /**
     * `AWS::ECS::TaskDefinition.InferenceAccelerators`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-inferenceaccelerators
     * @external
     */
    readonly inferenceAccelerators?: Array<CfnTaskDefinition.InferenceAcceleratorProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ECS::TaskDefinition.IpcMode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-ipcmode
     * @external
     */
    readonly ipcMode?: string;
    /**
     * `AWS::ECS::TaskDefinition.Memory`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-memory
     * @external
     */
    readonly memory?: string;
    /**
     * `AWS::ECS::TaskDefinition.NetworkMode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-networkmode
     * @external
     */
    readonly networkMode?: string;
    /**
     * `AWS::ECS::TaskDefinition.PidMode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-pidmode
     * @external
     */
    readonly pidMode?: string;
    /**
     * `AWS::ECS::TaskDefinition.PlacementConstraints`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-placementconstraints
     * @external
     */
    readonly placementConstraints?: Array<CfnTaskDefinition.TaskDefinitionPlacementConstraintProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ECS::TaskDefinition.ProxyConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-proxyconfiguration
     * @external
     */
    readonly proxyConfiguration?: CfnTaskDefinition.ProxyConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::ECS::TaskDefinition.RequiresCompatibilities`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-requirescompatibilities
     * @external
     */
    readonly requiresCompatibilities?: string[];
    /**
     * `AWS::ECS::TaskDefinition.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::ECS::TaskDefinition.TaskRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-taskrolearn
     * @external
     */
    readonly taskRoleArn?: string;
    /**
     * `AWS::ECS::TaskDefinition.Volumes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-volumes
     * @external
     */
    readonly volumes?: Array<CfnTaskDefinition.VolumeProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::ECS::TaskDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html
 * @external
 * @cloudformationResource AWS::ECS::TaskDefinition
 */
export declare class CfnTaskDefinition extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ECS::TaskDefinition";
    /**
     * @external
     * @cloudformationAttribute TaskDefinitionArn
     */
    readonly attrTaskDefinitionArn: string;
    /**
     * `AWS::ECS::TaskDefinition.ContainerDefinitions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-containerdefinitions
     * @external
     */
    containerDefinitions: Array<CfnTaskDefinition.ContainerDefinitionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ECS::TaskDefinition.Cpu`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-cpu
     * @external
     */
    cpu: string | undefined;
    /**
     * `AWS::ECS::TaskDefinition.ExecutionRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-executionrolearn
     * @external
     */
    executionRoleArn: string | undefined;
    /**
     * `AWS::ECS::TaskDefinition.Family`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-family
     * @external
     */
    family: string | undefined;
    /**
     * `AWS::ECS::TaskDefinition.InferenceAccelerators`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-inferenceaccelerators
     * @external
     */
    inferenceAccelerators: Array<CfnTaskDefinition.InferenceAcceleratorProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ECS::TaskDefinition.IpcMode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-ipcmode
     * @external
     */
    ipcMode: string | undefined;
    /**
     * `AWS::ECS::TaskDefinition.Memory`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-memory
     * @external
     */
    memory: string | undefined;
    /**
     * `AWS::ECS::TaskDefinition.NetworkMode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-networkmode
     * @external
     */
    networkMode: string | undefined;
    /**
     * `AWS::ECS::TaskDefinition.PidMode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-pidmode
     * @external
     */
    pidMode: string | undefined;
    /**
     * `AWS::ECS::TaskDefinition.PlacementConstraints`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-placementconstraints
     * @external
     */
    placementConstraints: Array<CfnTaskDefinition.TaskDefinitionPlacementConstraintProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ECS::TaskDefinition.ProxyConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-proxyconfiguration
     * @external
     */
    proxyConfiguration: CfnTaskDefinition.ProxyConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ECS::TaskDefinition.RequiresCompatibilities`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-requirescompatibilities
     * @external
     */
    requiresCompatibilities: string[] | undefined;
    /**
     * `AWS::ECS::TaskDefinition.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::ECS::TaskDefinition.TaskRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-taskrolearn
     * @external
     */
    taskRoleArn: string | undefined;
    /**
     * `AWS::ECS::TaskDefinition.Volumes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-volumes
     * @external
     */
    volumes: Array<CfnTaskDefinition.VolumeProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::ECS::TaskDefinition`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnTaskDefinitionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ECS::TaskDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html
 * @external
 * @cloudformationResource AWS::ECS::TaskDefinition
 */
export declare namespace CfnTaskDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-authorizationconfig.html
     * @external
     */
    interface AuthorizationConfigProperty {
        /**
         * `CfnTaskDefinition.AuthorizationConfigProperty.AccessPointId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-authorizationconfig.html#cfn-ecs-taskdefinition-authorizationconfig-accesspointid
         * @external
         */
        readonly accessPointId?: string;
        /**
         * `CfnTaskDefinition.AuthorizationConfigProperty.IAM`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-authorizationconfig.html#cfn-ecs-taskdefinition-authorizationconfig-iam
         * @external
         */
        readonly iam?: string;
    }
}
/**
 * A CloudFormation `AWS::ECS::TaskDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html
 * @external
 * @cloudformationResource AWS::ECS::TaskDefinition
 */
export declare namespace CfnTaskDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html
     * @external
     */
    interface ContainerDefinitionProperty {
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.Command`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-command
         * @external
         */
        readonly command?: string[];
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.Cpu`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-cpu
         * @external
         */
        readonly cpu?: number;
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.DependsOn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-dependson
         * @external
         */
        readonly dependsOn?: Array<CfnTaskDefinition.ContainerDependencyProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.DisableNetworking`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-disablenetworking
         * @external
         */
        readonly disableNetworking?: boolean | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.DnsSearchDomains`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-dnssearchdomains
         * @external
         */
        readonly dnsSearchDomains?: string[];
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.DnsServers`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-dnsservers
         * @external
         */
        readonly dnsServers?: string[];
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.DockerLabels`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-dockerlabels
         * @external
         */
        readonly dockerLabels?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.DockerSecurityOptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-dockersecurityoptions
         * @external
         */
        readonly dockerSecurityOptions?: string[];
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.EntryPoint`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-entrypoint
         * @external
         */
        readonly entryPoint?: string[];
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.Environment`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-environment
         * @external
         */
        readonly environment?: Array<CfnTaskDefinition.KeyValuePairProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.EnvironmentFiles`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-environmentfiles
         * @external
         */
        readonly environmentFiles?: Array<CfnTaskDefinition.EnvironmentFileProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.Essential`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-essential
         * @external
         */
        readonly essential?: boolean | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.ExtraHosts`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-extrahosts
         * @external
         */
        readonly extraHosts?: Array<CfnTaskDefinition.HostEntryProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.FirelensConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-firelensconfiguration
         * @external
         */
        readonly firelensConfiguration?: CfnTaskDefinition.FirelensConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.HealthCheck`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-healthcheck
         * @external
         */
        readonly healthCheck?: CfnTaskDefinition.HealthCheckProperty | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.Hostname`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-hostname
         * @external
         */
        readonly hostname?: string;
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.Image`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-image
         * @external
         */
        readonly image?: string;
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.Interactive`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-interactive
         * @external
         */
        readonly interactive?: boolean | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.Links`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-links
         * @external
         */
        readonly links?: string[];
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.LinuxParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-linuxparameters
         * @external
         */
        readonly linuxParameters?: CfnTaskDefinition.LinuxParametersProperty | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.LogConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-logconfiguration
         * @external
         */
        readonly logConfiguration?: CfnTaskDefinition.LogConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.Memory`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-memory
         * @external
         */
        readonly memory?: number;
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.MemoryReservation`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-memoryreservation
         * @external
         */
        readonly memoryReservation?: number;
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.MountPoints`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-mountpoints
         * @external
         */
        readonly mountPoints?: Array<CfnTaskDefinition.MountPointProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.PortMappings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-portmappings
         * @external
         */
        readonly portMappings?: Array<CfnTaskDefinition.PortMappingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.Privileged`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-privileged
         * @external
         */
        readonly privileged?: boolean | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.PseudoTerminal`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-pseudoterminal
         * @external
         */
        readonly pseudoTerminal?: boolean | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.ReadonlyRootFilesystem`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-readonlyrootfilesystem
         * @external
         */
        readonly readonlyRootFilesystem?: boolean | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.RepositoryCredentials`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-repositorycredentials
         * @external
         */
        readonly repositoryCredentials?: CfnTaskDefinition.RepositoryCredentialsProperty | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.ResourceRequirements`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-resourcerequirements
         * @external
         */
        readonly resourceRequirements?: Array<CfnTaskDefinition.ResourceRequirementProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.Secrets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-secrets
         * @external
         */
        readonly secrets?: Array<CfnTaskDefinition.SecretProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.StartTimeout`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-starttimeout
         * @external
         */
        readonly startTimeout?: number;
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.StopTimeout`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-stoptimeout
         * @external
         */
        readonly stopTimeout?: number;
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.SystemControls`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-systemcontrols
         * @external
         */
        readonly systemControls?: Array<CfnTaskDefinition.SystemControlProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.Ulimits`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-ulimits
         * @external
         */
        readonly ulimits?: Array<CfnTaskDefinition.UlimitProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.User`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-user
         * @external
         */
        readonly user?: string;
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.VolumesFrom`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-volumesfrom
         * @external
         */
        readonly volumesFrom?: Array<CfnTaskDefinition.VolumeFromProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.ContainerDefinitionProperty.WorkingDirectory`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions.html#cfn-ecs-taskdefinition-containerdefinition-workingdirectory
         * @external
         */
        readonly workingDirectory?: string;
    }
}
/**
 * A CloudFormation `AWS::ECS::TaskDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html
 * @external
 * @cloudformationResource AWS::ECS::TaskDefinition
 */
export declare namespace CfnTaskDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdependency.html
     * @external
     */
    interface ContainerDependencyProperty {
        /**
         * `CfnTaskDefinition.ContainerDependencyProperty.Condition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdependency.html#cfn-ecs-taskdefinition-containerdependency-condition
         * @external
         */
        readonly condition?: string;
        /**
         * `CfnTaskDefinition.ContainerDependencyProperty.ContainerName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdependency.html#cfn-ecs-taskdefinition-containerdependency-containername
         * @external
         */
        readonly containerName?: string;
    }
}
/**
 * A CloudFormation `AWS::ECS::TaskDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html
 * @external
 * @cloudformationResource AWS::ECS::TaskDefinition
 */
export declare namespace CfnTaskDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-device.html
     * @external
     */
    interface DeviceProperty {
        /**
         * `CfnTaskDefinition.DeviceProperty.ContainerPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-device.html#cfn-ecs-taskdefinition-device-containerpath
         * @external
         */
        readonly containerPath?: string;
        /**
         * `CfnTaskDefinition.DeviceProperty.HostPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-device.html#cfn-ecs-taskdefinition-device-hostpath
         * @external
         */
        readonly hostPath?: string;
        /**
         * `CfnTaskDefinition.DeviceProperty.Permissions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-device.html#cfn-ecs-taskdefinition-device-permissions
         * @external
         */
        readonly permissions?: string[];
    }
}
/**
 * A CloudFormation `AWS::ECS::TaskDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html
 * @external
 * @cloudformationResource AWS::ECS::TaskDefinition
 */
export declare namespace CfnTaskDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-dockervolumeconfiguration.html
     * @external
     */
    interface DockerVolumeConfigurationProperty {
        /**
         * `CfnTaskDefinition.DockerVolumeConfigurationProperty.Autoprovision`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-dockervolumeconfiguration.html#cfn-ecs-taskdefinition-dockervolumeconfiguration-autoprovision
         * @external
         */
        readonly autoprovision?: boolean | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.DockerVolumeConfigurationProperty.Driver`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-dockervolumeconfiguration.html#cfn-ecs-taskdefinition-dockervolumeconfiguration-driver
         * @external
         */
        readonly driver?: string;
        /**
         * `CfnTaskDefinition.DockerVolumeConfigurationProperty.DriverOpts`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-dockervolumeconfiguration.html#cfn-ecs-taskdefinition-dockervolumeconfiguration-driveropts
         * @external
         */
        readonly driverOpts?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.DockerVolumeConfigurationProperty.Labels`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-dockervolumeconfiguration.html#cfn-ecs-taskdefinition-dockervolumeconfiguration-labels
         * @external
         */
        readonly labels?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.DockerVolumeConfigurationProperty.Scope`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-dockervolumeconfiguration.html#cfn-ecs-taskdefinition-dockervolumeconfiguration-scope
         * @external
         */
        readonly scope?: string;
    }
}
/**
 * A CloudFormation `AWS::ECS::TaskDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html
 * @external
 * @cloudformationResource AWS::ECS::TaskDefinition
 */
export declare namespace CfnTaskDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-efsvolumeconfiguration.html
     * @external
     */
    interface EfsVolumeConfigurationProperty {
        /**
         * `CfnTaskDefinition.EfsVolumeConfigurationProperty.AuthorizationConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-efsvolumeconfiguration.html#cfn-ecs-taskdefinition-efsvolumeconfiguration-authorizationconfig
         * @external
         */
        readonly authorizationConfig?: CfnTaskDefinition.AuthorizationConfigProperty | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.EfsVolumeConfigurationProperty.RootDirectory`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-efsvolumeconfiguration.html#cfn-ecs-taskdefinition-efsvolumeconfiguration-rootdirectory
         * @external
         */
        readonly rootDirectory?: string;
        /**
         * `CfnTaskDefinition.EfsVolumeConfigurationProperty.TransitEncryption`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-efsvolumeconfiguration.html#cfn-ecs-taskdefinition-efsvolumeconfiguration-transitencryption
         * @external
         */
        readonly transitEncryption?: string;
        /**
         * `CfnTaskDefinition.EfsVolumeConfigurationProperty.TransitEncryptionPort`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-efsvolumeconfiguration.html#cfn-ecs-taskdefinition-efsvolumeconfiguration-transitencryptionport
         * @external
         */
        readonly transitEncryptionPort?: number;
        /**
         * `CfnTaskDefinition.EfsVolumeConfigurationProperty.FileSystemId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-efsvolumeconfiguration.html#cfn-ecs-taskdefinition-efsvolumeconfiguration-filesystemid
         * @external
         */
        readonly fileSystemId: string;
    }
}
/**
 * A CloudFormation `AWS::ECS::TaskDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html
 * @external
 * @cloudformationResource AWS::ECS::TaskDefinition
 */
export declare namespace CfnTaskDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-environmentfile.html
     * @external
     */
    interface EnvironmentFileProperty {
        /**
         * `CfnTaskDefinition.EnvironmentFileProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-environmentfile.html#cfn-ecs-taskdefinition-environmentfile-type
         * @external
         */
        readonly type?: string;
        /**
         * `CfnTaskDefinition.EnvironmentFileProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-environmentfile.html#cfn-ecs-taskdefinition-environmentfile-value
         * @external
         */
        readonly value?: string;
    }
}
/**
 * A CloudFormation `AWS::ECS::TaskDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html
 * @external
 * @cloudformationResource AWS::ECS::TaskDefinition
 */
export declare namespace CfnTaskDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-firelensconfiguration.html
     * @external
     */
    interface FirelensConfigurationProperty {
        /**
         * `CfnTaskDefinition.FirelensConfigurationProperty.Options`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-firelensconfiguration.html#cfn-ecs-taskdefinition-firelensconfiguration-options
         * @external
         */
        readonly options?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.FirelensConfigurationProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-firelensconfiguration.html#cfn-ecs-taskdefinition-firelensconfiguration-type
         * @external
         */
        readonly type?: string;
    }
}
/**
 * A CloudFormation `AWS::ECS::TaskDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html
 * @external
 * @cloudformationResource AWS::ECS::TaskDefinition
 */
export declare namespace CfnTaskDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-healthcheck.html
     * @external
     */
    interface HealthCheckProperty {
        /**
         * `CfnTaskDefinition.HealthCheckProperty.Command`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-healthcheck.html#cfn-ecs-taskdefinition-healthcheck-command
         * @external
         */
        readonly command?: string[];
        /**
         * `CfnTaskDefinition.HealthCheckProperty.Interval`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-healthcheck.html#cfn-ecs-taskdefinition-healthcheck-interval
         * @external
         */
        readonly interval?: number;
        /**
         * `CfnTaskDefinition.HealthCheckProperty.Retries`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-healthcheck.html#cfn-ecs-taskdefinition-healthcheck-retries
         * @external
         */
        readonly retries?: number;
        /**
         * `CfnTaskDefinition.HealthCheckProperty.StartPeriod`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-healthcheck.html#cfn-ecs-taskdefinition-healthcheck-startperiod
         * @external
         */
        readonly startPeriod?: number;
        /**
         * `CfnTaskDefinition.HealthCheckProperty.Timeout`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-healthcheck.html#cfn-ecs-taskdefinition-healthcheck-timeout
         * @external
         */
        readonly timeout?: number;
    }
}
/**
 * A CloudFormation `AWS::ECS::TaskDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html
 * @external
 * @cloudformationResource AWS::ECS::TaskDefinition
 */
export declare namespace CfnTaskDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions-hostentry.html
     * @external
     */
    interface HostEntryProperty {
        /**
         * `CfnTaskDefinition.HostEntryProperty.Hostname`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions-hostentry.html#cfn-ecs-taskdefinition-containerdefinition-hostentry-hostname
         * @external
         */
        readonly hostname?: string;
        /**
         * `CfnTaskDefinition.HostEntryProperty.IpAddress`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions-hostentry.html#cfn-ecs-taskdefinition-containerdefinition-hostentry-ipaddress
         * @external
         */
        readonly ipAddress?: string;
    }
}
/**
 * A CloudFormation `AWS::ECS::TaskDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html
 * @external
 * @cloudformationResource AWS::ECS::TaskDefinition
 */
export declare namespace CfnTaskDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-volumes-host.html
     * @external
     */
    interface HostVolumePropertiesProperty {
        /**
         * `CfnTaskDefinition.HostVolumePropertiesProperty.SourcePath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-volumes-host.html#cfn-ecs-taskdefinition-volumes-host-sourcepath
         * @external
         */
        readonly sourcePath?: string;
    }
}
/**
 * A CloudFormation `AWS::ECS::TaskDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html
 * @external
 * @cloudformationResource AWS::ECS::TaskDefinition
 */
export declare namespace CfnTaskDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-inferenceaccelerator.html
     * @external
     */
    interface InferenceAcceleratorProperty {
        /**
         * `CfnTaskDefinition.InferenceAcceleratorProperty.DeviceName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-inferenceaccelerator.html#cfn-ecs-taskdefinition-inferenceaccelerator-devicename
         * @external
         */
        readonly deviceName?: string;
        /**
         * `CfnTaskDefinition.InferenceAcceleratorProperty.DeviceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-inferenceaccelerator.html#cfn-ecs-taskdefinition-inferenceaccelerator-devicetype
         * @external
         */
        readonly deviceType?: string;
    }
}
/**
 * A CloudFormation `AWS::ECS::TaskDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html
 * @external
 * @cloudformationResource AWS::ECS::TaskDefinition
 */
export declare namespace CfnTaskDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-kernelcapabilities.html
     * @external
     */
    interface KernelCapabilitiesProperty {
        /**
         * `CfnTaskDefinition.KernelCapabilitiesProperty.Add`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-kernelcapabilities.html#cfn-ecs-taskdefinition-kernelcapabilities-add
         * @external
         */
        readonly add?: string[];
        /**
         * `CfnTaskDefinition.KernelCapabilitiesProperty.Drop`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-kernelcapabilities.html#cfn-ecs-taskdefinition-kernelcapabilities-drop
         * @external
         */
        readonly drop?: string[];
    }
}
/**
 * A CloudFormation `AWS::ECS::TaskDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html
 * @external
 * @cloudformationResource AWS::ECS::TaskDefinition
 */
export declare namespace CfnTaskDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions-environment.html
     * @external
     */
    interface KeyValuePairProperty {
        /**
         * `CfnTaskDefinition.KeyValuePairProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions-environment.html#cfn-ecs-taskdefinition-containerdefinition-environment-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnTaskDefinition.KeyValuePairProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions-environment.html#cfn-ecs-taskdefinition-containerdefinition-environment-value
         * @external
         */
        readonly value?: string;
    }
}
/**
 * A CloudFormation `AWS::ECS::TaskDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html
 * @external
 * @cloudformationResource AWS::ECS::TaskDefinition
 */
export declare namespace CfnTaskDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-linuxparameters.html
     * @external
     */
    interface LinuxParametersProperty {
        /**
         * `CfnTaskDefinition.LinuxParametersProperty.Capabilities`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-linuxparameters.html#cfn-ecs-taskdefinition-linuxparameters-capabilities
         * @external
         */
        readonly capabilities?: CfnTaskDefinition.KernelCapabilitiesProperty | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.LinuxParametersProperty.Devices`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-linuxparameters.html#cfn-ecs-taskdefinition-linuxparameters-devices
         * @external
         */
        readonly devices?: Array<CfnTaskDefinition.DeviceProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.LinuxParametersProperty.InitProcessEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-linuxparameters.html#cfn-ecs-taskdefinition-linuxparameters-initprocessenabled
         * @external
         */
        readonly initProcessEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.LinuxParametersProperty.MaxSwap`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-linuxparameters.html#cfn-ecs-taskdefinition-linuxparameters-maxswap
         * @external
         */
        readonly maxSwap?: number;
        /**
         * `CfnTaskDefinition.LinuxParametersProperty.SharedMemorySize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-linuxparameters.html#cfn-ecs-taskdefinition-linuxparameters-sharedmemorysize
         * @external
         */
        readonly sharedMemorySize?: number;
        /**
         * `CfnTaskDefinition.LinuxParametersProperty.Swappiness`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-linuxparameters.html#cfn-ecs-taskdefinition-linuxparameters-swappiness
         * @external
         */
        readonly swappiness?: number;
        /**
         * `CfnTaskDefinition.LinuxParametersProperty.Tmpfs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-linuxparameters.html#cfn-ecs-taskdefinition-linuxparameters-tmpfs
         * @external
         */
        readonly tmpfs?: Array<CfnTaskDefinition.TmpfsProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ECS::TaskDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html
 * @external
 * @cloudformationResource AWS::ECS::TaskDefinition
 */
export declare namespace CfnTaskDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions-logconfiguration.html
     * @external
     */
    interface LogConfigurationProperty {
        /**
         * `CfnTaskDefinition.LogConfigurationProperty.LogDriver`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions-logconfiguration.html#cfn-ecs-taskdefinition-containerdefinition-logconfiguration-logdriver
         * @external
         */
        readonly logDriver: string;
        /**
         * `CfnTaskDefinition.LogConfigurationProperty.Options`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions-logconfiguration.html#cfn-ecs-taskdefinition-containerdefinition-logconfiguration-options
         * @external
         */
        readonly options?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.LogConfigurationProperty.SecretOptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions-logconfiguration.html#cfn-ecs-taskdefinition-logconfiguration-secretoptions
         * @external
         */
        readonly secretOptions?: Array<CfnTaskDefinition.SecretProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ECS::TaskDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html
 * @external
 * @cloudformationResource AWS::ECS::TaskDefinition
 */
export declare namespace CfnTaskDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions-mountpoints.html
     * @external
     */
    interface MountPointProperty {
        /**
         * `CfnTaskDefinition.MountPointProperty.ContainerPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions-mountpoints.html#cfn-ecs-taskdefinition-containerdefinition-mountpoints-containerpath
         * @external
         */
        readonly containerPath?: string;
        /**
         * `CfnTaskDefinition.MountPointProperty.ReadOnly`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions-mountpoints.html#cfn-ecs-taskdefinition-containerdefinition-mountpoints-readonly
         * @external
         */
        readonly readOnly?: boolean | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.MountPointProperty.SourceVolume`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions-mountpoints.html#cfn-ecs-taskdefinition-containerdefinition-mountpoints-sourcevolume
         * @external
         */
        readonly sourceVolume?: string;
    }
}
/**
 * A CloudFormation `AWS::ECS::TaskDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html
 * @external
 * @cloudformationResource AWS::ECS::TaskDefinition
 */
export declare namespace CfnTaskDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions-portmappings.html
     * @external
     */
    interface PortMappingProperty {
        /**
         * `CfnTaskDefinition.PortMappingProperty.ContainerPort`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions-portmappings.html#cfn-ecs-taskdefinition-containerdefinition-portmappings-containerport
         * @external
         */
        readonly containerPort?: number;
        /**
         * `CfnTaskDefinition.PortMappingProperty.HostPort`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions-portmappings.html#cfn-ecs-taskdefinition-containerdefinition-portmappings-readonly
         * @external
         */
        readonly hostPort?: number;
        /**
         * `CfnTaskDefinition.PortMappingProperty.Protocol`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions-portmappings.html#cfn-ecs-taskdefinition-containerdefinition-portmappings-sourcevolume
         * @external
         */
        readonly protocol?: string;
    }
}
/**
 * A CloudFormation `AWS::ECS::TaskDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html
 * @external
 * @cloudformationResource AWS::ECS::TaskDefinition
 */
export declare namespace CfnTaskDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-proxyconfiguration.html
     * @external
     */
    interface ProxyConfigurationProperty {
        /**
         * `CfnTaskDefinition.ProxyConfigurationProperty.ContainerName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-proxyconfiguration.html#cfn-ecs-taskdefinition-proxyconfiguration-containername
         * @external
         */
        readonly containerName: string;
        /**
         * `CfnTaskDefinition.ProxyConfigurationProperty.ProxyConfigurationProperties`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-proxyconfiguration.html#cfn-ecs-taskdefinition-proxyconfiguration-proxyconfigurationproperties
         * @external
         */
        readonly proxyConfigurationProperties?: Array<CfnTaskDefinition.KeyValuePairProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.ProxyConfigurationProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-proxyconfiguration.html#cfn-ecs-taskdefinition-proxyconfiguration-type
         * @external
         */
        readonly type?: string;
    }
}
/**
 * A CloudFormation `AWS::ECS::TaskDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html
 * @external
 * @cloudformationResource AWS::ECS::TaskDefinition
 */
export declare namespace CfnTaskDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-repositorycredentials.html
     * @external
     */
    interface RepositoryCredentialsProperty {
        /**
         * `CfnTaskDefinition.RepositoryCredentialsProperty.CredentialsParameter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-repositorycredentials.html#cfn-ecs-taskdefinition-repositorycredentials-credentialsparameter
         * @external
         */
        readonly credentialsParameter?: string;
    }
}
/**
 * A CloudFormation `AWS::ECS::TaskDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html
 * @external
 * @cloudformationResource AWS::ECS::TaskDefinition
 */
export declare namespace CfnTaskDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-resourcerequirement.html
     * @external
     */
    interface ResourceRequirementProperty {
        /**
         * `CfnTaskDefinition.ResourceRequirementProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-resourcerequirement.html#cfn-ecs-taskdefinition-resourcerequirement-type
         * @external
         */
        readonly type: string;
        /**
         * `CfnTaskDefinition.ResourceRequirementProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-resourcerequirement.html#cfn-ecs-taskdefinition-resourcerequirement-value
         * @external
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::ECS::TaskDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html
 * @external
 * @cloudformationResource AWS::ECS::TaskDefinition
 */
export declare namespace CfnTaskDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-secret.html
     * @external
     */
    interface SecretProperty {
        /**
         * `CfnTaskDefinition.SecretProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-secret.html#cfn-ecs-taskdefinition-secret-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnTaskDefinition.SecretProperty.ValueFrom`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-secret.html#cfn-ecs-taskdefinition-secret-valuefrom
         * @external
         */
        readonly valueFrom: string;
    }
}
/**
 * A CloudFormation `AWS::ECS::TaskDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html
 * @external
 * @cloudformationResource AWS::ECS::TaskDefinition
 */
export declare namespace CfnTaskDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-systemcontrol.html
     * @external
     */
    interface SystemControlProperty {
        /**
         * `CfnTaskDefinition.SystemControlProperty.Namespace`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-systemcontrol.html#cfn-ecs-taskdefinition-systemcontrol-namespace
         * @external
         */
        readonly namespace?: string;
        /**
         * `CfnTaskDefinition.SystemControlProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-systemcontrol.html#cfn-ecs-taskdefinition-systemcontrol-value
         * @external
         */
        readonly value?: string;
    }
}
/**
 * A CloudFormation `AWS::ECS::TaskDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html
 * @external
 * @cloudformationResource AWS::ECS::TaskDefinition
 */
export declare namespace CfnTaskDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-taskdefinitionplacementconstraint.html
     * @external
     */
    interface TaskDefinitionPlacementConstraintProperty {
        /**
         * `CfnTaskDefinition.TaskDefinitionPlacementConstraintProperty.Expression`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-taskdefinitionplacementconstraint.html#cfn-ecs-taskdefinition-taskdefinitionplacementconstraint-expression
         * @external
         */
        readonly expression?: string;
        /**
         * `CfnTaskDefinition.TaskDefinitionPlacementConstraintProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-taskdefinitionplacementconstraint.html#cfn-ecs-taskdefinition-taskdefinitionplacementconstraint-type
         * @external
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::ECS::TaskDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html
 * @external
 * @cloudformationResource AWS::ECS::TaskDefinition
 */
export declare namespace CfnTaskDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-tmpfs.html
     * @external
     */
    interface TmpfsProperty {
        /**
         * `CfnTaskDefinition.TmpfsProperty.ContainerPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-tmpfs.html#cfn-ecs-taskdefinition-tmpfs-containerpath
         * @external
         */
        readonly containerPath?: string;
        /**
         * `CfnTaskDefinition.TmpfsProperty.MountOptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-tmpfs.html#cfn-ecs-taskdefinition-tmpfs-mountoptions
         * @external
         */
        readonly mountOptions?: string[];
        /**
         * `CfnTaskDefinition.TmpfsProperty.Size`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-tmpfs.html#cfn-ecs-taskdefinition-tmpfs-size
         * @external
         */
        readonly size: number;
    }
}
/**
 * A CloudFormation `AWS::ECS::TaskDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html
 * @external
 * @cloudformationResource AWS::ECS::TaskDefinition
 */
export declare namespace CfnTaskDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions-ulimit.html
     * @external
     */
    interface UlimitProperty {
        /**
         * `CfnTaskDefinition.UlimitProperty.HardLimit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions-ulimit.html#cfn-ecs-taskdefinition-containerdefinition-ulimit-hardlimit
         * @external
         */
        readonly hardLimit: number;
        /**
         * `CfnTaskDefinition.UlimitProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions-ulimit.html#cfn-ecs-taskdefinition-containerdefinition-ulimit-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnTaskDefinition.UlimitProperty.SoftLimit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions-ulimit.html#cfn-ecs-taskdefinition-containerdefinition-ulimit-softlimit
         * @external
         */
        readonly softLimit: number;
    }
}
/**
 * A CloudFormation `AWS::ECS::TaskDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html
 * @external
 * @cloudformationResource AWS::ECS::TaskDefinition
 */
export declare namespace CfnTaskDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-volumes.html
     * @external
     */
    interface VolumeProperty {
        /**
         * `CfnTaskDefinition.VolumeProperty.DockerVolumeConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-volumes.html#cfn-ecs-taskdefinition-volume-dockervolumeconfiguration
         * @external
         */
        readonly dockerVolumeConfiguration?: CfnTaskDefinition.DockerVolumeConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.VolumeProperty.Host`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-volumes.html#cfn-ecs-taskdefinition-volumes-host
         * @external
         */
        readonly host?: CfnTaskDefinition.HostVolumePropertiesProperty | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.VolumeProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-volumes.html#cfn-ecs-taskdefinition-volumes-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnTaskDefinition.VolumeProperty.EfsVolumeConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-volumes.html#cfn-ecs-taskdefinition-volume-efsvolumeconfiguration
         * @external
         */
        readonly efsVolumeConfiguration?: CfnTaskDefinition.EfsVolumeConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ECS::TaskDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html
 * @external
 * @cloudformationResource AWS::ECS::TaskDefinition
 */
export declare namespace CfnTaskDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions-volumesfrom.html
     * @external
     */
    interface VolumeFromProperty {
        /**
         * `CfnTaskDefinition.VolumeFromProperty.ReadOnly`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions-volumesfrom.html#cfn-ecs-taskdefinition-containerdefinition-volumesfrom-readonly
         * @external
         */
        readonly readOnly?: boolean | cdk.IResolvable;
        /**
         * `CfnTaskDefinition.VolumeFromProperty.SourceContainer`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinitions-volumesfrom.html#cfn-ecs-taskdefinition-containerdefinition-volumesfrom-sourcecontainer
         * @external
         */
        readonly sourceContainer?: string;
    }
}
/**
 * Properties for defining a `AWS::ECS::TaskSet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html
 * @external
 */
export interface CfnTaskSetProps {
    /**
     * `AWS::ECS::TaskSet.Cluster`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-cluster
     * @external
     */
    readonly cluster: string;
    /**
     * `AWS::ECS::TaskSet.Service`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-service
     * @external
     */
    readonly service: string;
    /**
     * `AWS::ECS::TaskSet.TaskDefinition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-taskdefinition
     * @external
     */
    readonly taskDefinition: string;
    /**
     * `AWS::ECS::TaskSet.ExternalId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-externalid
     * @external
     */
    readonly externalId?: string;
    /**
     * `AWS::ECS::TaskSet.LaunchType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-launchtype
     * @external
     */
    readonly launchType?: string;
    /**
     * `AWS::ECS::TaskSet.LoadBalancers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-loadbalancers
     * @external
     */
    readonly loadBalancers?: Array<CfnTaskSet.LoadBalancerProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ECS::TaskSet.NetworkConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-networkconfiguration
     * @external
     */
    readonly networkConfiguration?: CfnTaskSet.NetworkConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::ECS::TaskSet.PlatformVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-platformversion
     * @external
     */
    readonly platformVersion?: string;
    /**
     * `AWS::ECS::TaskSet.Scale`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-scale
     * @external
     */
    readonly scale?: CfnTaskSet.ScaleProperty | cdk.IResolvable;
    /**
     * `AWS::ECS::TaskSet.ServiceRegistries`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-serviceregistries
     * @external
     */
    readonly serviceRegistries?: Array<CfnTaskSet.ServiceRegistryProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::ECS::TaskSet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html
 * @external
 * @cloudformationResource AWS::ECS::TaskSet
 */
export declare class CfnTaskSet extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ECS::TaskSet";
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::ECS::TaskSet.Cluster`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-cluster
     * @external
     */
    cluster: string;
    /**
     * `AWS::ECS::TaskSet.Service`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-service
     * @external
     */
    service: string;
    /**
     * `AWS::ECS::TaskSet.TaskDefinition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-taskdefinition
     * @external
     */
    taskDefinition: string;
    /**
     * `AWS::ECS::TaskSet.ExternalId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-externalid
     * @external
     */
    externalId: string | undefined;
    /**
     * `AWS::ECS::TaskSet.LaunchType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-launchtype
     * @external
     */
    launchType: string | undefined;
    /**
     * `AWS::ECS::TaskSet.LoadBalancers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-loadbalancers
     * @external
     */
    loadBalancers: Array<CfnTaskSet.LoadBalancerProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ECS::TaskSet.NetworkConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-networkconfiguration
     * @external
     */
    networkConfiguration: CfnTaskSet.NetworkConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ECS::TaskSet.PlatformVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-platformversion
     * @external
     */
    platformVersion: string | undefined;
    /**
     * `AWS::ECS::TaskSet.Scale`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-scale
     * @external
     */
    scale: CfnTaskSet.ScaleProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ECS::TaskSet.ServiceRegistries`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-serviceregistries
     * @external
     */
    serviceRegistries: Array<CfnTaskSet.ServiceRegistryProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::ECS::TaskSet`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTaskSetProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ECS::TaskSet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html
 * @external
 * @cloudformationResource AWS::ECS::TaskSet
 */
export declare namespace CfnTaskSet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-awsvpcconfiguration.html
     * @external
     */
    interface AwsVpcConfigurationProperty {
        /**
         * `CfnTaskSet.AwsVpcConfigurationProperty.AssignPublicIp`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-awsvpcconfiguration.html#cfn-ecs-taskset-awsvpcconfiguration-assignpublicip
         * @external
         */
        readonly assignPublicIp?: string;
        /**
         * `CfnTaskSet.AwsVpcConfigurationProperty.SecurityGroups`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-awsvpcconfiguration.html#cfn-ecs-taskset-awsvpcconfiguration-securitygroups
         * @external
         */
        readonly securityGroups?: string[];
        /**
         * `CfnTaskSet.AwsVpcConfigurationProperty.Subnets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-awsvpcconfiguration.html#cfn-ecs-taskset-awsvpcconfiguration-subnets
         * @external
         */
        readonly subnets: string[];
    }
}
/**
 * A CloudFormation `AWS::ECS::TaskSet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html
 * @external
 * @cloudformationResource AWS::ECS::TaskSet
 */
export declare namespace CfnTaskSet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-loadbalancer.html
     * @external
     */
    interface LoadBalancerProperty {
        /**
         * `CfnTaskSet.LoadBalancerProperty.ContainerName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-loadbalancer.html#cfn-ecs-taskset-loadbalancer-containername
         * @external
         */
        readonly containerName?: string;
        /**
         * `CfnTaskSet.LoadBalancerProperty.ContainerPort`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-loadbalancer.html#cfn-ecs-taskset-loadbalancer-containerport
         * @external
         */
        readonly containerPort?: number;
        /**
         * `CfnTaskSet.LoadBalancerProperty.LoadBalancerName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-loadbalancer.html#cfn-ecs-taskset-loadbalancer-loadbalancername
         * @external
         */
        readonly loadBalancerName?: string;
        /**
         * `CfnTaskSet.LoadBalancerProperty.TargetGroupArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-loadbalancer.html#cfn-ecs-taskset-loadbalancer-targetgrouparn
         * @external
         */
        readonly targetGroupArn?: string;
    }
}
/**
 * A CloudFormation `AWS::ECS::TaskSet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html
 * @external
 * @cloudformationResource AWS::ECS::TaskSet
 */
export declare namespace CfnTaskSet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-networkconfiguration.html
     * @external
     */
    interface NetworkConfigurationProperty {
        /**
         * `CfnTaskSet.NetworkConfigurationProperty.AwsVpcConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-networkconfiguration.html#cfn-ecs-taskset-networkconfiguration-awsvpcconfiguration
         * @external
         */
        readonly awsVpcConfiguration?: CfnTaskSet.AwsVpcConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ECS::TaskSet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html
 * @external
 * @cloudformationResource AWS::ECS::TaskSet
 */
export declare namespace CfnTaskSet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-scale.html
     * @external
     */
    interface ScaleProperty {
        /**
         * `CfnTaskSet.ScaleProperty.Unit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-scale.html#cfn-ecs-taskset-scale-unit
         * @external
         */
        readonly unit?: string;
        /**
         * `CfnTaskSet.ScaleProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-scale.html#cfn-ecs-taskset-scale-value
         * @external
         */
        readonly value?: number;
    }
}
/**
 * A CloudFormation `AWS::ECS::TaskSet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html
 * @external
 * @cloudformationResource AWS::ECS::TaskSet
 */
export declare namespace CfnTaskSet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-serviceregistry.html
     * @external
     */
    interface ServiceRegistryProperty {
        /**
         * `CfnTaskSet.ServiceRegistryProperty.ContainerName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-serviceregistry.html#cfn-ecs-taskset-serviceregistry-containername
         * @external
         */
        readonly containerName?: string;
        /**
         * `CfnTaskSet.ServiceRegistryProperty.ContainerPort`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-serviceregistry.html#cfn-ecs-taskset-serviceregistry-containerport
         * @external
         */
        readonly containerPort?: number;
        /**
         * `CfnTaskSet.ServiceRegistryProperty.Port`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-serviceregistry.html#cfn-ecs-taskset-serviceregistry-port
         * @external
         */
        readonly port?: number;
        /**
         * `CfnTaskSet.ServiceRegistryProperty.RegistryArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-serviceregistry.html#cfn-ecs-taskset-serviceregistry-registryarn
         * @external
         */
        readonly registryArn?: string;
    }
}
