"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContainerImage = void 0;
/**
 * (experimental) Constructs for types of container images.
 *
 * @experimental
 */
class ContainerImage {
    /**
     * (experimental) Reference an image on DockerHub or another online registry.
     *
     * @experimental
     */
    static fromRegistry(name, props = {}) {
        return new repository_1.RepositoryImage(name, props);
    }
    /**
     * (experimental) Reference an image in an ECR repository.
     *
     * @experimental
     */
    static fromEcrRepository(repository, tag = 'latest') {
        return new ecr_1.EcrImage(repository, tag);
    }
    /**
     * (experimental) Reference an image that's constructed directly from sources on disk.
     *
     * If you already have a `DockerImageAsset` instance, you can use the
     * `ContainerImage.fromDockerImageAsset` method instead.
     *
     * @param directory The directory containing the Dockerfile.
     * @experimental
     */
    static fromAsset(directory, props = {}) {
        return new asset_image_1.AssetImage(directory, props);
    }
    /**
     * (experimental) Use an existing `DockerImageAsset` for this container image.
     *
     * @param asset The `DockerImageAsset` to use for this container definition.
     * @experimental
     */
    static fromDockerImageAsset(asset) {
        return {
            bind(_scope, containerDefinition) {
                asset.repository.grantPull(containerDefinition.taskDefinition.obtainExecutionRole());
                return {
                    imageName: asset.imageUri,
                };
            },
        };
    }
}
exports.ContainerImage = ContainerImage;
const asset_image_1 = require("./images/asset-image");
const ecr_1 = require("./images/ecr");
const repository_1 = require("./images/repository");
//# sourceMappingURL=data:application/json;base64,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