import * as iam from "../../aws-iam";
import * as secretsmanager from "../../aws-secretsmanager";
import * as ssm from "../../aws-ssm";
import * as cdk from "../../core";
import { Construct } from 'constructs';
import { TaskDefinition } from './base/task-definition';
import { ContainerImage } from './container-image';
import { CfnTaskDefinition } from './ecs.generated';
import { LinuxParameters } from './linux-parameters';
import { LogDriver, LogDriverConfig } from './log-drivers/log-driver';
/**
 * (experimental) A secret environment variable.
 *
 * @experimental
 */
export declare abstract class Secret {
    /**
     * (experimental) Creates an environment variable value from a parameter stored in AWS Systems Manager Parameter Store.
     *
     * @experimental
     */
    static fromSsmParameter(parameter: ssm.IParameter): Secret;
    /**
     * (experimental) Creates a environment variable value from a secret stored in AWS Secrets Manager.
     *
     * @param secret the secret stored in AWS Secrets Manager.
     * @param field the name of the field with the value that you want to set as the environment variable value.
     * @experimental
     */
    static fromSecretsManager(secret: secretsmanager.ISecret, field?: string): Secret;
    /**
     * (experimental) The ARN of the secret.
     *
     * @experimental
     */
    abstract readonly arn: string;
    /**
     * (experimental) Whether this secret uses a specific JSON field.
     *
     * @experimental
     */
    abstract readonly hasField?: boolean;
    /**
     * (experimental) Grants reading the secret to a principal.
     *
     * @experimental
     */
    abstract grantRead(grantee: iam.IGrantable): iam.Grant;
}
/**
 * @experimental
 */
export interface ContainerDefinitionOptions {
    /**
     * (experimental) The image used to start a container.
     *
     * This string is passed directly to the Docker daemon.
     * Images in the Docker Hub registry are available by default.
     * Other repositories are specified with either repository-url/image:tag or repository-url/image@digest.
     * TODO: Update these to specify using classes of IContainerImage
     *
     * @experimental
     */
    readonly image: ContainerImage;
    /**
     * (experimental) The command that is passed to the container.
     *
     * If you provide a shell command as a single string, you have to quote command-line arguments.
     *
     * @default - CMD value built into container image.
     * @experimental
     */
    readonly command?: string[];
    /**
     * (experimental) The minimum number of CPU units to reserve for the container.
     *
     * @default - No minimum CPU units reserved.
     * @experimental
     */
    readonly cpu?: number;
    /**
     * (experimental) Specifies whether networking is disabled within the container.
     *
     * When this parameter is true, networking is disabled within the container.
     *
     * @default false
     * @experimental
     */
    readonly disableNetworking?: boolean;
    /**
     * (experimental) A list of DNS search domains that are presented to the container.
     *
     * @default - No search domains.
     * @experimental
     */
    readonly dnsSearchDomains?: string[];
    /**
     * (experimental) A list of DNS servers that are presented to the container.
     *
     * @default - Default DNS servers.
     * @experimental
     */
    readonly dnsServers?: string[];
    /**
     * (experimental) A key/value map of labels to add to the container.
     *
     * @default - No labels.
     * @experimental
     */
    readonly dockerLabels?: {
        [key: string]: string;
    };
    /**
     * (experimental) A list of strings to provide custom labels for SELinux and AppArmor multi-level security systems.
     *
     * @default - No security labels.
     * @experimental
     */
    readonly dockerSecurityOptions?: string[];
    /**
     * (experimental) The ENTRYPOINT value to pass to the container.
     *
     * @default - Entry point configured in container.
     * @see https://docs.docker.com/engine/reference/builder/#entrypoint
     * @experimental
     */
    readonly entryPoint?: string[];
    /**
     * (experimental) The environment variables to pass to the container.
     *
     * @default - No environment variables.
     * @experimental
     */
    readonly environment?: {
        [key: string]: string;
    };
    /**
     * (experimental) The secret environment variables to pass to the container.
     *
     * @default - No secret environment variables.
     * @experimental
     */
    readonly secrets?: {
        [key: string]: Secret;
    };
    /**
     * (experimental) Time duration (in seconds) to wait before giving up on resolving dependencies for a container.
     *
     * @default - none
     * @experimental
     */
    readonly startTimeout?: cdk.Duration;
    /**
     * (experimental) Time duration (in seconds) to wait before the container is forcefully killed if it doesn't exit normally on its own.
     *
     * @default - none
     * @experimental
     */
    readonly stopTimeout?: cdk.Duration;
    /**
     * (experimental) Specifies whether the container is marked essential.
     *
     * If the essential parameter of a container is marked as true, and that container fails
     * or stops for any reason, all other containers that are part of the task are stopped.
     * If the essential parameter of a container is marked as false, then its failure does not
     * affect the rest of the containers in a task. All tasks must have at least one essential container.
     *
     * If this parameter is omitted, a container is assumed to be essential.
     *
     * @default true
     * @experimental
     */
    readonly essential?: boolean;
    /**
     * (experimental) A list of hostnames and IP address mappings to append to the /etc/hosts file on the container.
     *
     * @default - No extra hosts.
     * @experimental
     */
    readonly extraHosts?: {
        [name: string]: string;
    };
    /**
     * (experimental) The health check command and associated configuration parameters for the container.
     *
     * @default - Health check configuration from container.
     * @experimental
     */
    readonly healthCheck?: HealthCheck;
    /**
     * (experimental) The hostname to use for your container.
     *
     * @default - Automatic hostname.
     * @experimental
     */
    readonly hostname?: string;
    /**
     * (experimental) The amount (in MiB) of memory to present to the container.
     *
     * If your container attempts to exceed the allocated memory, the container
     * is terminated.
     *
     * At least one of memoryLimitMiB and memoryReservationMiB is required for non-Fargate services.
     *
     * @default - No memory limit.
     * @experimental
     */
    readonly memoryLimitMiB?: number;
    /**
     * (experimental) The soft limit (in MiB) of memory to reserve for the container.
     *
     * When system memory is under heavy contention, Docker attempts to keep the
     * container memory to this soft limit. However, your container can consume more
     * memory when it needs to, up to either the hard limit specified with the memory
     * parameter (if applicable), or all of the available memory on the container
     * instance, whichever comes first.
     *
     * At least one of memoryLimitMiB and memoryReservationMiB is required for non-Fargate services.
     *
     * @default - No memory reserved.
     * @experimental
     */
    readonly memoryReservationMiB?: number;
    /**
     * (experimental) Specifies whether the container is marked as privileged.
     *
     * When this parameter is true, the container is given elevated privileges on the host container instance (similar to the root user).
     *
     * @default false
     * @experimental
     */
    readonly privileged?: boolean;
    /**
     * (experimental) When this parameter is true, the container is given read-only access to its root file system.
     *
     * @default false
     * @experimental
     */
    readonly readonlyRootFilesystem?: boolean;
    /**
     * (experimental) The user name to use inside the container.
     *
     * @default root
     * @experimental
     */
    readonly user?: string;
    /**
     * (experimental) The working directory in which to run commands inside the container.
     *
     * @default /
     * @experimental
     */
    readonly workingDirectory?: string;
    /**
     * (experimental) The log configuration specification for the container.
     *
     * @default - Containers use the same logging driver that the Docker daemon uses.
     * @experimental
     */
    readonly logging?: LogDriver;
    /**
     * (experimental) Linux-specific modifications that are applied to the container, such as Linux kernel capabilities.
     *
     * For more information see [KernelCapabilities](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_KernelCapabilities.html).
     *
     * @default - No Linux parameters.
     * @experimental
     */
    readonly linuxParameters?: LinuxParameters;
    /**
     * (experimental) The number of GPUs assigned to the container.
     *
     * @default - No GPUs assigned.
     * @experimental
     */
    readonly gpuCount?: number;
}
/**
 * (experimental) The properties in a container definition.
 *
 * @experimental
 */
export interface ContainerDefinitionProps extends ContainerDefinitionOptions {
    /**
     * (experimental) The name of the task definition that includes this container definition.
     *
     * [disable-awslint:ref-via-interface]
     *
     * @experimental
     */
    readonly taskDefinition: TaskDefinition;
}
/**
 * (experimental) A container definition is used in a task definition to describe the containers that are launched as part of a task.
 *
 * @experimental
 */
export declare class ContainerDefinition extends cdk.Construct {
    private readonly props;
    /**
     * (experimental) The Linux-specific modifications that are applied to the container, such as Linux kernel capabilities.
     *
     * @experimental
     */
    readonly linuxParameters?: LinuxParameters;
    /**
     * (experimental) The mount points for data volumes in your container.
     *
     * @experimental
     */
    readonly mountPoints: MountPoint[];
    /**
     * (experimental) The list of port mappings for the container.
     *
     * Port mappings allow containers to access ports
     * on the host container instance to send or receive traffic.
     *
     * @experimental
     */
    readonly portMappings: PortMapping[];
    /**
     * (experimental) The data volumes to mount from another container in the same task definition.
     *
     * @experimental
     */
    readonly volumesFrom: VolumeFrom[];
    /**
     * (experimental) An array of ulimits to set in the container.
     *
     * @experimental
     */
    readonly ulimits: Ulimit[];
    /**
     * (experimental) An array dependencies defined for container startup and shutdown.
     *
     * @experimental
     */
    readonly containerDependencies: ContainerDependency[];
    /**
     * (experimental) Specifies whether the container will be marked essential.
     *
     * If the essential parameter of a container is marked as true, and that container
     * fails or stops for any reason, all other containers that are part of the task are
     * stopped. If the essential parameter of a container is marked as false, then its
     * failure does not affect the rest of the containers in a task.
     *
     * If this parameter isomitted, a container is assumed to be essential.
     *
     * @experimental
     */
    readonly essential: boolean;
    /**
     * (experimental) The name of this container.
     *
     * @experimental
     */
    readonly containerName: string;
    /**
     * (experimental) Whether there was at least one memory limit specified in this definition.
     *
     * @experimental
     */
    readonly memoryLimitSpecified: boolean;
    /**
     * (experimental) The name of the task definition that includes this container definition.
     *
     * @experimental
     */
    readonly taskDefinition: TaskDefinition;
    /**
     * (experimental) The log configuration specification for the container.
     *
     * @experimental
     */
    readonly logDriverConfig?: LogDriverConfig;
    /**
     * The configured container links
     */
    private readonly links;
    private readonly imageConfig;
    private readonly secrets?;
    /**
     * (experimental) Constructs a new instance of the ContainerDefinition class.
     *
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ContainerDefinitionProps);
    /**
     * (experimental) This method adds a link which allows containers to communicate with each other without the need for port mappings.
     *
     * This parameter is only supported if the task definition is using the bridge network mode.
     * Warning: The --link flag is a legacy feature of Docker. It may eventually be removed.
     *
     * @experimental
     */
    addLink(container: ContainerDefinition, alias?: string): void;
    /**
     * (experimental) This method adds one or more mount points for data volumes to the container.
     *
     * @experimental
     */
    addMountPoints(...mountPoints: MountPoint[]): void;
    /**
     * (experimental) This method mounts temporary disk space to the container.
     *
     * This adds the correct container mountPoint and task definition volume.
     *
     * @experimental
     */
    addScratch(scratch: ScratchSpace): void;
    /**
     * (experimental) This method adds one or more port mappings to the container.
     *
     * @experimental
     */
    addPortMappings(...portMappings: PortMapping[]): void;
    /**
     * (experimental) This method adds one or more ulimits to the container.
     *
     * @experimental
     */
    addUlimits(...ulimits: Ulimit[]): void;
    /**
     * (experimental) This method adds one or more container dependencies to the container.
     *
     * @experimental
     */
    addContainerDependencies(...containerDependencies: ContainerDependency[]): void;
    /**
     * (experimental) This method adds one or more volumes to the container.
     *
     * @experimental
     */
    addVolumesFrom(...volumesFrom: VolumeFrom[]): void;
    /**
     * (experimental) This method adds the specified statement to the IAM task execution policy in the task definition.
     *
     * @experimental
     */
    addToExecutionPolicy(statement: iam.PolicyStatement): void;
    /**
     * (experimental) Returns the host port for the requested container port if it exists.
     *
     * @experimental
     */
    findPortMapping(containerPort: number, protocol: Protocol): PortMapping | undefined;
    /**
     * (experimental) The inbound rules associated with the security group the task or service will use.
     *
     * This property is only used for tasks that use the awsvpc network mode.
     *
     * @experimental
     */
    get ingressPort(): number;
    /**
     * (experimental) The port the container will listen on.
     *
     * @experimental
     */
    get containerPort(): number;
    /**
     * (experimental) Render this container definition to a CloudFormation object.
     *
     * @param _taskDefinition [disable-awslint:ref-via-interface] (unused but kept to avoid breaking change).
     * @experimental
     */
    renderContainerDefinition(_taskDefinition?: TaskDefinition): CfnTaskDefinition.ContainerDefinitionProperty;
}
/**
 * (experimental) The health check command and associated configuration parameters for the container.
 *
 * @experimental
 */
export interface HealthCheck {
    /**
     * (experimental) A string array representing the command that the container runs to determine if it is healthy.
     *
     * The string array must start with CMD to execute the command arguments directly, or
     * CMD-SHELL to run the command with the container's default shell.
     *
     * For example: [ "CMD-SHELL", "curl -f http://localhost/ || exit 1" ]
     *
     * @experimental
     */
    readonly command: string[];
    /**
     * (experimental) The time period in seconds between each health check execution.
     *
     * You may specify between 5 and 300 seconds.
     *
     * @default Duration.seconds(30)
     * @experimental
     */
    readonly interval?: cdk.Duration;
    /**
     * (experimental) The number of times to retry a failed health check before the container is considered unhealthy.
     *
     * You may specify between 1 and 10 retries.
     *
     * @default 3
     * @experimental
     */
    readonly retries?: number;
    /**
     * (experimental) The optional grace period within which to provide containers time to bootstrap before failed health checks count towards the maximum number of retries.
     *
     * You may specify between 0 and 300 seconds.
     *
     * @default No start period
     * @experimental
     */
    readonly startPeriod?: cdk.Duration;
    /**
     * (experimental) The time period in seconds to wait for a health check to succeed before it is considered a failure.
     *
     * You may specify between 2 and 60 seconds.
     *
     * @default Duration.seconds(5)
     * @experimental
     */
    readonly timeout?: cdk.Duration;
}
/**
 * (experimental) The ulimit settings to pass to the container.
 *
 * NOTE: Does not work for Windows containers.
 *
 * @experimental
 */
export interface Ulimit {
    /**
     * (experimental) The type of the ulimit.
     *
     * For more information, see [UlimitName](https://docs.aws.amazon.com/cdk/api/latest/typescript/api/aws-ecs/ulimitname.html#aws_ecs_UlimitName).
     *
     * @experimental
     */
    readonly name: UlimitName;
    /**
     * (experimental) The soft limit for the ulimit type.
     *
     * @experimental
     */
    readonly softLimit: number;
    /**
     * (experimental) The hard limit for the ulimit type.
     *
     * @experimental
     */
    readonly hardLimit: number;
}
/**
 * (experimental) Type of resource to set a limit on.
 *
 * @experimental
 */
export declare enum UlimitName {
    /**
     * @experimental
     */
    CORE = "core",
    /**
     * @experimental
     */
    CPU = "cpu",
    /**
     * @experimental
     */
    DATA = "data",
    /**
     * @experimental
     */
    FSIZE = "fsize",
    /**
     * @experimental
     */
    LOCKS = "locks",
    /**
     * @experimental
     */
    MEMLOCK = "memlock",
    /**
     * @experimental
     */
    MSGQUEUE = "msgqueue",
    /**
     * @experimental
     */
    NICE = "nice",
    /**
     * @experimental
     */
    NOFILE = "nofile",
    /**
     * @experimental
     */
    NPROC = "nproc",
    /**
     * @experimental
     */
    RSS = "rss",
    /**
     * @experimental
     */
    RTPRIO = "rtprio",
    /**
     * @experimental
     */
    RTTIME = "rttime",
    /**
     * @experimental
     */
    SIGPENDING = "sigpending",
    /**
     * @experimental
     */
    STACK = "stack"
}
/**
 * (experimental) The details of a dependency on another container in the task definition.
 *
 * @see https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDependency.html
 * @experimental
 */
export interface ContainerDependency {
    /**
     * (experimental) The container to depend on.
     *
     * @experimental
     */
    readonly container: ContainerDefinition;
    /**
     * (experimental) The state the container needs to be in to satisfy the dependency and proceed with startup.
     *
     * Valid values are ContainerDependencyCondition.START, ContainerDependencyCondition.COMPLETE,
     * ContainerDependencyCondition.SUCCESS and ContainerDependencyCondition.HEALTHY.
     *
     * @default ContainerDependencyCondition.HEALTHY
     * @experimental
     */
    readonly condition?: ContainerDependencyCondition;
}
/**
 * @experimental
 */
export declare enum ContainerDependencyCondition {
    /**
     * (experimental) This condition emulates the behavior of links and volumes today.
     *
     * It validates that a dependent container is started before permitting other containers to start.
     *
     * @experimental
     */
    START = "START",
    /**
     * (experimental) This condition validates that a dependent container runs to completion (exits) before permitting other containers to start.
     *
     * This can be useful for nonessential containers that run a script and then exit.
     *
     * @experimental
     */
    COMPLETE = "COMPLETE",
    /**
     * (experimental) This condition is the same as COMPLETE, but it also requires that the container exits with a zero status.
     *
     * @experimental
     */
    SUCCESS = "SUCCESS",
    /**
     * (experimental) This condition validates that the dependent container passes its Docker health check before permitting other containers to start.
     *
     * This requires that the dependent container has health checks configured. This condition is confirmed only at task startup.
     *
     * @experimental
     */
    HEALTHY = "HEALTHY"
}
/**
 * (experimental) Port mappings allow containers to access ports on the host container instance to send or receive traffic.
 *
 * @experimental
 */
export interface PortMapping {
    /**
     * (experimental) The port number on the container that is bound to the user-specified or automatically assigned host port.
     *
     * If you are using containers in a task with the awsvpc or host network mode, exposed ports should be specified using containerPort.
     * If you are using containers in a task with the bridge network mode and you specify a container port and not a host port,
     * your container automatically receives a host port in the ephemeral port range.
     *
     * For more information, see hostPort.
     * Port mappings that are automatically assigned in this way do not count toward the 100 reserved ports limit of a container instance.
     *
     * @experimental
     */
    readonly containerPort: number;
    /**
     * (experimental) The port number on the container instance to reserve for your container.
     *
     * If you are using containers in a task with the awsvpc or host network mode,
     * the hostPort can either be left blank or set to the same value as the containerPort.
     *
     * If you are using containers in a task with the bridge network mode,
     * you can specify a non-reserved host port for your container port mapping, or
     * you can omit the hostPort (or set it to 0) while specifying a containerPort and
     * your container automatically receives a port in the ephemeral port range for
     * your container instance operating system and Docker version.
     *
     * @experimental
     */
    readonly hostPort?: number;
    /**
     * (experimental) The protocol used for the port mapping.
     *
     * Valid values are Protocol.TCP and Protocol.UDP.
     *
     * @default TCP
     * @experimental
     */
    readonly protocol?: Protocol;
}
/**
 * (experimental) Network protocol.
 *
 * @experimental
 */
export declare enum Protocol {
    /**
     * (experimental) TCP.
     *
     * @experimental
     */
    TCP = "tcp",
    /**
     * (experimental) UDP.
     *
     * @experimental
     */
    UDP = "udp"
}
/**
 * (experimental) The temporary disk space mounted to the container.
 *
 * @experimental
 */
export interface ScratchSpace {
    /**
     * (experimental) The path on the container to mount the scratch volume at.
     *
     * @experimental
     */
    readonly containerPath: string;
    /**
     * (experimental) Specifies whether to give the container read-only access to the scratch volume.
     *
     * If this value is true, the container has read-only access to the scratch volume.
     * If this value is false, then the container can write to the scratch volume.
     *
     * @experimental
     */
    readonly readOnly: boolean;
    /**
     * @experimental
     */
    readonly sourcePath: string;
    /**
     * (experimental) The name of the scratch volume to mount.
     *
     * Must be a volume name referenced in the name parameter of task definition volume.
     *
     * @experimental
     */
    readonly name: string;
}
/**
 * (experimental) The details of data volume mount points for a container.
 *
 * @experimental
 */
export interface MountPoint {
    /**
     * (experimental) The path on the container to mount the host volume at.
     *
     * @experimental
     */
    readonly containerPath: string;
    /**
     * (experimental) Specifies whether to give the container read-only access to the volume.
     *
     * If this value is true, the container has read-only access to the volume.
     * If this value is false, then the container can write to the volume.
     *
     * @experimental
     */
    readonly readOnly: boolean;
    /**
     * (experimental) The name of the volume to mount.
     *
     * Must be a volume name referenced in the name parameter of task definition volume.
     *
     * @experimental
     */
    readonly sourceVolume: string;
}
/**
 * (experimental) The details on a data volume from another container in the same task definition.
 *
 * @experimental
 */
export interface VolumeFrom {
    /**
     * (experimental) The name of another container within the same task definition from which to mount volumes.
     *
     * @experimental
     */
    readonly sourceContainer: string;
    /**
     * (experimental) Specifies whether the container has read-only access to the volume.
     *
     * If this value is true, the container has read-only access to the volume.
     * If this value is false, then the container can write to the volume.
     *
     * @experimental
     */
    readonly readOnly: boolean;
}
