import { ScalingInterval } from "../../../aws-applicationautoscaling";
import { IVpc } from "../../../aws-ec2";
import { BaseService, Cluster, ContainerImage, ICluster, LogDriver, PropagatedTagSource, Secret } from "../../../aws-ecs";
import { IQueue } from "../../../aws-sqs";
import { Duration } from "../../../core";
import { Construct } from 'constructs';
import { Construct as CoreConstruct } from "../../../core";
/**
 * (experimental) The properties for the base QueueProcessingEc2Service or QueueProcessingFargateService service.
 *
 * @experimental
 */
export interface QueueProcessingServiceBaseProps {
    /**
     * (experimental) The name of the service.
     *
     * @default - CloudFormation-generated name.
     * @experimental
     */
    readonly serviceName?: string;
    /**
     * (experimental) The name of the cluster that hosts the service.
     *
     * If a cluster is specified, the vpc construct should be omitted. Alternatively, you can omit both cluster and vpc.
     *
     * @default - create a new cluster; if both cluster and vpc are omitted, a new VPC will be created for you.
     * @experimental
     */
    readonly cluster?: ICluster;
    /**
     * (experimental) The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed.
     *
     * If a vpc is specified, the cluster construct should be omitted. Alternatively, you can omit both vpc and cluster.
     *
     * @default - uses the VPC defined in the cluster or creates a new VPC.
     * @experimental
     */
    readonly vpc?: IVpc;
    /**
     * (experimental) The image used to start a container.
     *
     * @experimental
     */
    readonly image: ContainerImage;
    /**
     * (experimental) The command that is passed to the container.
     *
     * If you provide a shell command as a single string, you have to quote command-line arguments.
     *
     * @default - CMD value built into container image.
     * @experimental
     */
    readonly command?: string[];
    /**
     * (experimental) The desired number of instantiations of the task definition to keep running on the service.
     *
     * @default 1
     * @experimental
     */
    readonly desiredTaskCount?: number;
    /**
     * (experimental) Flag to indicate whether to enable logging.
     *
     * @default true
     * @experimental
     */
    readonly enableLogging?: boolean;
    /**
     * (experimental) The environment variables to pass to the container.
     *
     * The variable `QUEUE_NAME` with value `queue.queueName` will
     * always be passed.
     *
     * @default 'QUEUE_NAME: queue.queueName'
     * @experimental
     */
    readonly environment?: {
        [key: string]: string;
    };
    /**
     * (experimental) The secret to expose to the container as an environment variable.
     *
     * @default - No secret environment variables.
     * @experimental
     */
    readonly secrets?: {
        [key: string]: Secret;
    };
    /**
     * (experimental) A queue for which to process items from.
     *
     * If specified and this is a FIFO queue, the queue name must end in the string '.fifo'. See
     * [CreateQueue](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_CreateQueue.html)
     *
     * @default 'SQSQueue with CloudFormation-generated name'
     * @experimental
     */
    readonly queue?: IQueue;
    /**
     * (experimental) The maximum number of times that a message can be received by consumers.
     *
     * When this value is exceeded for a message the message will be automatically sent to the Dead Letter Queue.
     *
     * @default 3
     * @experimental
     */
    readonly maxReceiveCount?: number;
    /**
     * (experimental) The number of seconds that Dead Letter Queue retains a message.
     *
     * @default Duration.days(14)
     * @experimental
     */
    readonly retentionPeriod?: Duration;
    /**
     * (experimental) Maximum capacity to scale to.
     *
     * @default (desiredTaskCount * 2)
     * @experimental
     */
    readonly maxScalingCapacity?: number;
    /**
     * (experimental) The intervals for scaling based on the SQS queue's ApproximateNumberOfMessagesVisible metric.
     *
     * Maps a range of metric values to a particular scaling behavior. See
     * [Simple and Step Scaling Policies for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html)
     *
     * @default [{ upper: 0, change: -1 },{ lower: 100, change: +1 },{ lower: 500, change: +5 }]
     * @experimental
     */
    readonly scalingSteps?: ScalingInterval[];
    /**
     * (experimental) The log driver to use.
     *
     * @default - AwsLogDriver if enableLogging is true
     * @experimental
     */
    readonly logDriver?: LogDriver;
    /**
     * (experimental) Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
     *
     * Tags can only be propagated to the tasks within the service during service creation.
     *
     * @default - none
     * @experimental
     */
    readonly propagateTags?: PropagatedTagSource;
    /**
     * (experimental) Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
     *
     * For more information, see
     * [Tagging Your Amazon ECS Resources](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html)
     *
     * @default false
     * @experimental
     */
    readonly enableECSManagedTags?: boolean;
    /**
     * (experimental) The name of a family that the task definition is registered to.
     *
     * A family groups multiple versions of a task definition.
     *
     * @default - Automatically generated name.
     * @experimental
     */
    readonly family?: string;
    /**
     * (experimental) The maximum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that can run in a service during a deployment.
     *
     * @default - default from underlying service.
     * @experimental
     */
    readonly maxHealthyPercent?: number;
    /**
     * (experimental) The minimum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that must continue to run and remain healthy during a deployment.
     *
     * @default - default from underlying service.
     * @experimental
     */
    readonly minHealthyPercent?: number;
}
/**
 * (experimental) The base class for QueueProcessingEc2Service and QueueProcessingFargateService services.
 *
 * @experimental
 */
export declare abstract class QueueProcessingServiceBase extends CoreConstruct {
    /**
     * (experimental) The SQS queue that the service will process from.
     *
     * @experimental
     */
    readonly sqsQueue: IQueue;
    /**
     * (experimental) The dead letter queue for the primary SQS queue.
     *
     * @experimental
     */
    readonly deadLetterQueue?: IQueue;
    /**
     * (experimental) The cluster where your service will be deployed.
     *
     * @experimental
     */
    readonly cluster: ICluster;
    /**
     * (experimental) Environment variables that will include the queue name.
     *
     * @experimental
     */
    readonly environment: {
        [key: string]: string;
    };
    /**
     * (experimental) The secret environment variables.
     *
     * @experimental
     */
    readonly secrets?: {
        [key: string]: Secret;
    };
    /**
     * (experimental) The minimum number of tasks to run.
     *
     * @experimental
     */
    readonly desiredCount: number;
    /**
     * (experimental) The maximum number of instances for autoscaling to scale up to.
     *
     * @experimental
     */
    readonly maxCapacity: number;
    /**
     * (experimental) The scaling interval for autoscaling based off an SQS Queue size.
     *
     * @experimental
     */
    readonly scalingSteps: ScalingInterval[];
    /**
     * (experimental) The AwsLogDriver to use for logging if logging is enabled.
     *
     * @experimental
     */
    readonly logDriver?: LogDriver;
    /**
     * (experimental) Constructs a new instance of the QueueProcessingServiceBase class.
     *
     * @experimental
     */
    constructor(scope: Construct, id: string, props: QueueProcessingServiceBaseProps);
    /**
     * (experimental) Configure autoscaling based off of CPU utilization as well as the number of messages visible in the SQS queue.
     *
     * @param service the ECS/Fargate service for which to apply the autoscaling rules to.
     * @experimental
     */
    protected configureAutoscalingForService(service: BaseService): void;
    /**
     * (experimental) Grant SQS permissions to an ECS service.
     *
     * @param service the ECS/Fargate service to which to grant SQS permissions.
     * @experimental
     */
    protected grantPermissionsToService(service: BaseService): void;
    /**
     * (experimental) Returns the default cluster.
     *
     * @experimental
     */
    protected getDefaultCluster(scope: Construct, vpc?: IVpc): Cluster;
    /**
     * Create an AWS Log Driver with the provided streamPrefix
     *
     * @param prefix the Cloudwatch logging prefix
     */
    private createAWSLogDriver;
}
