import { IConstruct, IDependable, IResource, Resource } from "../../core";
import { Construct } from 'constructs';
import { CfnNatGateway } from './ec2.generated';
import { NatProvider } from './nat';
import { INetworkAcl } from './network-acl';
import { SubnetFilter } from './subnet';
import { GatewayVpcEndpoint, GatewayVpcEndpointOptions, InterfaceVpcEndpoint, InterfaceVpcEndpointOptions } from './vpc-endpoint';
import { FlowLog, FlowLogOptions } from './vpc-flow-logs';
import { VpcLookupOptions } from './vpc-lookup';
import { EnableVpnGatewayOptions, VpnConnection, VpnConnectionOptions } from './vpn';
/**
 * @experimental
 */
export interface ISubnet extends IResource {
    /**
     * (experimental) The Availability Zone the subnet is located in.
     *
     * @experimental
     */
    readonly availabilityZone: string;
    /**
     * (experimental) The subnetId for this particular subnet.
     *
     * @experimental
     * @attribute true
     */
    readonly subnetId: string;
    /**
     * (experimental) Dependable that can be depended upon to force internet connectivity established on the VPC.
     *
     * @experimental
     */
    readonly internetConnectivityEstablished: IDependable;
    /**
     * (experimental) The IPv4 CIDR block for this subnet.
     *
     * @experimental
     */
    readonly ipv4CidrBlock: string;
    /**
     * (experimental) The route table for this subnet.
     *
     * @experimental
     */
    readonly routeTable: IRouteTable;
    /**
     * (experimental) Associate a Network ACL with this subnet.
     *
     * @param acl The Network ACL to associate.
     * @experimental
     */
    associateNetworkAcl(id: string, acl: INetworkAcl): void;
}
/**
 * (experimental) An abstract route table.
 *
 * @experimental
 */
export interface IRouteTable {
    /**
     * (experimental) Route table ID.
     *
     * @experimental
     */
    readonly routeTableId: string;
}
/**
 * @experimental
 */
export interface IVpc extends IResource {
    /**
     * (experimental) Identifier for this VPC.
     *
     * @experimental
     * @attribute true
     */
    readonly vpcId: string;
    /**
     * (experimental) CIDR range for this VPC.
     *
     * @experimental
     * @attribute true
     */
    readonly vpcCidrBlock: string;
    /**
     * (experimental) List of public subnets in this VPC.
     *
     * @experimental
     */
    readonly publicSubnets: ISubnet[];
    /**
     * (experimental) List of private subnets in this VPC.
     *
     * @experimental
     */
    readonly privateSubnets: ISubnet[];
    /**
     * (experimental) List of isolated subnets in this VPC.
     *
     * @experimental
     */
    readonly isolatedSubnets: ISubnet[];
    /**
     * (experimental) AZs for this VPC.
     *
     * @experimental
     */
    readonly availabilityZones: string[];
    /**
     * (experimental) Identifier for the VPN gateway.
     *
     * @experimental
     */
    readonly vpnGatewayId?: string;
    /**
     * (experimental) Dependable that can be depended upon to force internet connectivity established on the VPC.
     *
     * @experimental
     */
    readonly internetConnectivityEstablished: IDependable;
    /**
     * (experimental) Return information on the subnets appropriate for the given selection strategy.
     *
     * Requires that at least one subnet is matched, throws a descriptive
     * error message otherwise.
     *
     * @experimental
     */
    selectSubnets(selection?: SubnetSelection): SelectedSubnets;
    /**
     * (experimental) Adds a VPN Gateway to this VPC.
     *
     * @experimental
     */
    enableVpnGateway(options: EnableVpnGatewayOptions): void;
    /**
     * (experimental) Adds a new VPN connection to this VPC.
     *
     * @experimental
     */
    addVpnConnection(id: string, options: VpnConnectionOptions): VpnConnection;
    /**
     * (experimental) Adds a new gateway endpoint to this VPC.
     *
     * @experimental
     */
    addGatewayEndpoint(id: string, options: GatewayVpcEndpointOptions): GatewayVpcEndpoint;
    /**
     * (experimental) Adds a new interface endpoint to this VPC.
     *
     * @experimental
     */
    addInterfaceEndpoint(id: string, options: InterfaceVpcEndpointOptions): InterfaceVpcEndpoint;
    /**
     * (experimental) Adds a new Flow Log to this VPC.
     *
     * @experimental
     */
    addFlowLog(id: string, options?: FlowLogOptions): FlowLog;
}
/**
 * (experimental) The type of Subnet.
 *
 * @experimental
 */
export declare enum SubnetType {
    /**
     * (experimental) Isolated Subnets do not route traffic to the Internet (in this VPC).
     *
     * This can be good for subnets with RDS or Elasticache instances,
     * or which route Internet traffic through a peer VPC.
     *
     * @experimental
     */
    ISOLATED = "Isolated",
    /**
     * (experimental) Subnet that routes to the internet, but not vice versa.
     *
     * Instances in a private subnet can connect to the Internet, but will not
     * allow connections to be initiated from the Internet. Internet traffic will
     * be routed via a NAT Gateway.
     *
     * Normally a Private subnet will use a NAT gateway in the same AZ, but
     * if `natGateways` is used to reduce the number of NAT gateways, a NAT
     * gateway from another AZ will be used instead.
     *
     * @experimental
     */
    PRIVATE = "Private",
    /**
     * (experimental) Subnet connected to the Internet.
     *
     * Instances in a Public subnet can connect to the Internet and can be
     * connected to from the Internet as long as they are launched with public
     * IPs (controlled on the AutoScalingGroup or other constructs that launch
     * instances).
     *
     * Public subnets route outbound traffic via an Internet Gateway.
     *
     * @experimental
     */
    PUBLIC = "Public"
}
/**
 * (experimental) Customize subnets that are selected for placement of ENIs.
 *
 * Constructs that allow customization of VPC placement use parameters of this
 * type to provide placement settings.
 *
 * By default, the instances are placed in the private subnets.
 *
 * @experimental
 */
export interface SubnetSelection {
    /**
     * (experimental) Select all subnets of the given type.
     *
     * At most one of `subnetType` and `subnetGroupName` can be supplied.
     *
     * @default SubnetType.PRIVATE (or ISOLATED or PUBLIC if there are no PRIVATE subnets)
     * @experimental
     */
    readonly subnetType?: SubnetType;
    /**
     * (experimental) Select subnets only in the given AZs.
     *
     * @default no filtering on AZs is done
     * @experimental
     */
    readonly availabilityZones?: string[];
    /**
     * (experimental) Select the subnet group with the given name.
     *
     * Select the subnet group with the given name. This only needs
     * to be used if you have multiple subnet groups of the same type
     * and you need to distinguish between them. Otherwise, prefer
     * `subnetType`.
     *
     * This field does not select individual subnets, it selects all subnets that
     * share the given subnet group name. This is the name supplied in
     * `subnetConfiguration`.
     *
     * At most one of `subnetType` and `subnetGroupName` can be supplied.
     *
     * @default - Selection by type instead of by name
     * @experimental
     */
    readonly subnetGroupName?: string;
    /**
     * (deprecated) Alias for `subnetGroupName`.
     *
     * Select the subnet group with the given name. This only needs
     * to be used if you have multiple subnet groups of the same type
     * and you need to distinguish between them.
     *
     * @deprecated Use `subnetGroupName` instead
     */
    readonly subnetName?: string;
    /**
     * (experimental) If true, return at most one subnet per AZ.
     *
     * @default false
     * @experimental
     */
    readonly onePerAz?: boolean;
    /**
     * (experimental) List of provided subnet filters.
     *
     * @default - none
     * @experimental
     */
    readonly subnetFilters?: SubnetFilter[];
    /**
     * (experimental) Explicitly select individual subnets.
     *
     * Use this if you don't want to automatically use all subnets in
     * a group, but have a need to control selection down to
     * individual subnets.
     *
     * Cannot be specified together with `subnetType` or `subnetGroupName`.
     *
     * @default - Use all subnets in a selected group (all private subnets by default)
     * @experimental
     */
    readonly subnets?: ISubnet[];
}
/**
 * (experimental) Result of selecting a subset of subnets from a VPC.
 *
 * @experimental
 */
export interface SelectedSubnets {
    /**
     * (experimental) The subnet IDs.
     *
     * @experimental
     */
    readonly subnetIds: string[];
    /**
     * (experimental) The respective AZs of each subnet.
     *
     * @experimental
     */
    readonly availabilityZones: string[];
    /**
     * (experimental) Dependency representing internet connectivity for these subnets.
     *
     * @experimental
     */
    readonly internetConnectivityEstablished: IDependable;
    /**
     * (experimental) Selected subnet objects.
     *
     * @experimental
     */
    readonly subnets: ISubnet[];
    /**
     * (experimental) Whether any of the given subnets are from the VPC's public subnets.
     *
     * @experimental
     */
    readonly hasPublic: boolean;
}
/**
 * A new or imported VPC
 */
declare abstract class VpcBase extends Resource implements IVpc {
    /**
     * Identifier for this VPC
     */
    abstract readonly vpcId: string;
    /**
     * CIDR range for this VPC
     */
    abstract readonly vpcCidrBlock: string;
    /**
     * List of public subnets in this VPC
     */
    abstract readonly publicSubnets: ISubnet[];
    /**
     * List of private subnets in this VPC
     */
    abstract readonly privateSubnets: ISubnet[];
    /**
     * List of isolated subnets in this VPC
     */
    abstract readonly isolatedSubnets: ISubnet[];
    /**
     * AZs for this VPC
     */
    abstract readonly availabilityZones: string[];
    /**
     * Dependencies for internet connectivity
     */
    abstract readonly internetConnectivityEstablished: IDependable;
    /**
     * (deprecated) Dependencies for NAT connectivity.
     *
     * @deprecated - This value is no longer used.
     */
    protected readonly natDependencies: IConstruct[];
    /**
     * (experimental) If this is set to true, don't error out on trying to select subnets.
     *
     * @experimental
     */
    protected incompleteSubnetDefinition: boolean;
    /**
     * (experimental) Returns IDs of selected subnets.
     *
     * @experimental
     */
    selectSubnets(selection?: SubnetSelection): SelectedSubnets;
    /**
     * (experimental) Adds a VPN Gateway to this VPC.
     *
     * @experimental
     */
    enableVpnGateway(options: EnableVpnGatewayOptions): void;
    /**
     * (experimental) Adds a new VPN connection to this VPC.
     *
     * @experimental
     */
    addVpnConnection(id: string, options: VpnConnectionOptions): VpnConnection;
    /**
     * (experimental) Adds a new interface endpoint to this VPC.
     *
     * @experimental
     */
    addInterfaceEndpoint(id: string, options: InterfaceVpcEndpointOptions): InterfaceVpcEndpoint;
    /**
     * (experimental) Adds a new gateway endpoint to this VPC.
     *
     * @experimental
     */
    addGatewayEndpoint(id: string, options: GatewayVpcEndpointOptions): GatewayVpcEndpoint;
    /**
     * (experimental) Adds a new flow log to this VPC.
     *
     * @experimental
     */
    addFlowLog(id: string, options?: FlowLogOptions): FlowLog;
    /**
     * (experimental) Returns the id of the VPN Gateway (if enabled).
     *
     * @experimental
     */
    get vpnGatewayId(): string | undefined;
    /**
     * (experimental) Return the subnets appropriate for the placement strategy.
     *
     * @experimental
     */
    protected selectSubnetObjects(selection?: SubnetSelection): ISubnet[];
    private applySubnetFilters;
    private selectSubnetObjectsByName;
    private selectSubnetObjectsByType;
    /**
     * Validate the fields in a SubnetSelection object, and reify defaults if necessary
     *
     * In case of default selection, select the first type of PRIVATE, ISOLATED,
     * PUBLIC (in that order) that has any subnets.
     */
    private reifySelectionDefaults;
}
/**
 * (experimental) Properties that reference an external Vpc.
 *
 * @experimental
 */
export interface VpcAttributes {
    /**
     * (experimental) VPC's identifier.
     *
     * @experimental
     */
    readonly vpcId: string;
    /**
     * (experimental) VPC's CIDR range.
     *
     * @default - Retrieving the CIDR from the VPC will fail
     * @experimental
     */
    readonly vpcCidrBlock?: string;
    /**
     * (experimental) List of availability zones for the subnets in this VPC.
     *
     * @experimental
     */
    readonly availabilityZones: string[];
    /**
     * (experimental) List of public subnet IDs.
     *
     * Must be undefined or match the availability zones in length and order.
     *
     * @experimental
     */
    readonly publicSubnetIds?: string[];
    /**
     * (experimental) List of names for the public subnets.
     *
     * Must be undefined or have a name for every public subnet group.
     *
     * @experimental
     */
    readonly publicSubnetNames?: string[];
    /**
     * (experimental) List of IDs of routing tables for the public subnets.
     *
     * Must be undefined or have a name for every public subnet group.
     *
     * @experimental
     */
    readonly publicSubnetRouteTableIds?: string[];
    /**
     * (experimental) List of private subnet IDs.
     *
     * Must be undefined or match the availability zones in length and order.
     *
     * @experimental
     */
    readonly privateSubnetIds?: string[];
    /**
     * (experimental) List of names for the private subnets.
     *
     * Must be undefined or have a name for every private subnet group.
     *
     * @experimental
     */
    readonly privateSubnetNames?: string[];
    /**
     * (experimental) List of IDs of routing tables for the private subnets.
     *
     * Must be undefined or have a name for every private subnet group.
     *
     * @experimental
     */
    readonly privateSubnetRouteTableIds?: string[];
    /**
     * (experimental) List of isolated subnet IDs.
     *
     * Must be undefined or match the availability zones in length and order.
     *
     * @experimental
     */
    readonly isolatedSubnetIds?: string[];
    /**
     * (experimental) List of names for the isolated subnets.
     *
     * Must be undefined or have a name for every isolated subnet group.
     *
     * @experimental
     */
    readonly isolatedSubnetNames?: string[];
    /**
     * (experimental) List of IDs of routing tables for the isolated subnets.
     *
     * Must be undefined or have a name for every isolated subnet group.
     *
     * @experimental
     */
    readonly isolatedSubnetRouteTableIds?: string[];
    /**
     * (experimental) VPN gateway's identifier.
     *
     * @experimental
     */
    readonly vpnGatewayId?: string;
}
/**
 * @experimental
 */
export interface SubnetAttributes {
    /**
     * (experimental) The Availability Zone the subnet is located in.
     *
     * @default - No AZ information, cannot use AZ selection features
     * @experimental
     */
    readonly availabilityZone?: string;
    /**
     * (experimental) The IPv4 CIDR block associated with the subnet.
     *
     * @default - No CIDR information, cannot use CIDR filter features
     * @experimental
     */
    readonly ipv4CidrBlock?: string;
    /**
     * (experimental) The ID of the route table for this particular subnet.
     *
     * @default - No route table information, cannot create VPC endpoints
     * @experimental
     */
    readonly routeTableId?: string;
    /**
     * (experimental) The subnetId for this particular subnet.
     *
     * @experimental
     */
    readonly subnetId: string;
}
/**
 * (experimental) Configuration for Vpc.
 *
 * @experimental
 */
export interface VpcProps {
    /**
     * (experimental) The CIDR range to use for the VPC, e.g. '10.0.0.0/16'.
     *
     * Should be a minimum of /28 and maximum size of /16. The range will be
     * split across all subnets per Availability Zone.
     *
     * @default Vpc.DEFAULT_CIDR_RANGE
     * @experimental
     */
    readonly cidr?: string;
    /**
     * (experimental) Indicates whether the instances launched in the VPC get public DNS hostnames.
     *
     * If this attribute is true, instances in the VPC get public DNS hostnames,
     * but only if the enableDnsSupport attribute is also set to true.
     *
     * @default true
     * @experimental
     */
    readonly enableDnsHostnames?: boolean;
    /**
     * (experimental) Indicates whether the DNS resolution is supported for the VPC.
     *
     * If this attribute is false, the Amazon-provided DNS server in the VPC that
     * resolves public DNS hostnames to IP addresses is not enabled. If this
     * attribute is true, queries to the Amazon provided DNS server at the
     * 169.254.169.253 IP address, or the reserved IP address at the base of the
     * VPC IPv4 network range plus two will succeed.
     *
     * @default true
     * @experimental
     */
    readonly enableDnsSupport?: boolean;
    /**
     * (experimental) The default tenancy of instances launched into the VPC.
     *
     * By setting this to dedicated tenancy, instances will be launched on
     * hardware dedicated to a single AWS customer, unless specifically specified
     * at instance launch time. Please note, not all instance types are usable
     * with Dedicated tenancy.
     *
     * @default DefaultInstanceTenancy.Default (shared) tenancy
     * @experimental
     */
    readonly defaultInstanceTenancy?: DefaultInstanceTenancy;
    /**
     * (experimental) Define the maximum number of AZs to use in this region.
     *
     * If the region has more AZs than you want to use (for example, because of
     * EIP limits), pick a lower number here. The AZs will be sorted and picked
     * from the start of the list.
     *
     * If you pick a higher number than the number of AZs in the region, all AZs
     * in the region will be selected. To use "all AZs" available to your
     * account, use a high number (such as 99).
     *
     * Be aware that environment-agnostic stacks will be created with access to
     * only 2 AZs, so to use more than 2 AZs, be sure to specify the account and
     * region on your stack.
     *
     * @default 3
     * @experimental
     */
    readonly maxAzs?: number;
    /**
     * (experimental) The number of NAT Gateways/Instances to create.
     *
     * The type of NAT gateway or instance will be determined by the
     * `natGatewayProvider` parameter.
     *
     * You can set this number lower than the number of Availability Zones in your
     * VPC in order to save on NAT cost. Be aware you may be charged for
     * cross-AZ data traffic instead.
     *
     * @default - One NAT gateway/instance per Availability Zone
     * @experimental
     */
    readonly natGateways?: number;
    /**
     * (experimental) Configures the subnets which will have NAT Gateways/Instances.
     *
     * You can pick a specific group of subnets by specifying the group name;
     * the picked subnets must be public subnets.
     *
     * Only necessary if you have more than one public subnet group.
     *
     * @default - All public subnets.
     * @experimental
     */
    readonly natGatewaySubnets?: SubnetSelection;
    /**
     * (experimental) What type of NAT provider to use.
     *
     * Select between NAT gateways or NAT instances. NAT gateways
     * may not be available in all AWS regions.
     *
     * @default NatProvider.gateway()
     * @experimental
     */
    readonly natGatewayProvider?: NatProvider;
    /**
     * (experimental) Configure the subnets to build for each AZ.
     *
     * Each entry in this list configures a Subnet Group; each group will contain a
     * subnet for each Availability Zone.
     *
     * For example, if you want 1 public subnet, 1 private subnet, and 1 isolated
     * subnet in each AZ provide the following:
     *
     * ```ts
     * new ec2.Vpc(this, 'VPC', {
     *    subnetConfiguration: [
     *       {
     *         cidrMask: 24,
     *         name: 'ingress',
     *         subnetType: ec2.SubnetType.PUBLIC,
     *       },
     *       {
     *         cidrMask: 24,
     *         name: 'application',
     *         subnetType: ec2.SubnetType.PRIVATE,
     *       },
     *       {
     *         cidrMask: 28,
     *         name: 'rds',
     *         subnetType: ec2.SubnetType.ISOLATED,
     *       }
     *    ]
     * });
     * ```
     *
     * @default - The VPC CIDR will be evenly divided between 1 public and 1
     * private subnet per AZ.
     * @experimental
     */
    readonly subnetConfiguration?: SubnetConfiguration[];
    /**
     * (experimental) Indicates whether a VPN gateway should be created and attached to this VPC.
     *
     * @default - true when vpnGatewayAsn or vpnConnections is specified
     * @experimental
     */
    readonly vpnGateway?: boolean;
    /**
     * (experimental) The private Autonomous System Number (ASN) for the VPN gateway.
     *
     * @default - Amazon default ASN.
     * @experimental
     */
    readonly vpnGatewayAsn?: number;
    /**
     * (experimental) VPN connections to this VPC.
     *
     * @default - No connections.
     * @experimental
     */
    readonly vpnConnections?: {
        [id: string]: VpnConnectionOptions;
    };
    /**
     * (experimental) Where to propagate VPN routes.
     *
     * @default - On the route tables associated with private subnets. If no
     * private subnets exists, isolated subnets are used. If no isolated subnets
     * exists, public subnets are used.
     * @experimental
     */
    readonly vpnRoutePropagation?: SubnetSelection[];
    /**
     * (experimental) Gateway endpoints to add to this VPC.
     *
     * @default - None.
     * @experimental
     */
    readonly gatewayEndpoints?: {
        [id: string]: GatewayVpcEndpointOptions;
    };
    /**
     * (experimental) Flow logs to add to this VPC.
     *
     * @default - No flow logs.
     * @experimental
     */
    readonly flowLogs?: {
        [id: string]: FlowLogOptions;
    };
}
/**
 * (experimental) The default tenancy of instances launched into the VPC.
 *
 * @experimental
 */
export declare enum DefaultInstanceTenancy {
    /**
     * (experimental) Instances can be launched with any tenancy.
     *
     * @experimental
     */
    DEFAULT = "default",
    /**
     * (experimental) Any instance launched into the VPC automatically has dedicated tenancy, unless you launch it with the default tenancy.
     *
     * @experimental
     */
    DEDICATED = "dedicated"
}
/**
 * (experimental) Specify configuration parameters for a single subnet group in a VPC.
 *
 * @experimental
 */
export interface SubnetConfiguration {
    /**
     * (experimental) The number of leading 1 bits in the routing mask.
     *
     * The number of available IP addresses in each subnet of this group
     * will be equal to `2^(32 - cidrMask) - 2`.
     *
     * Valid values are `16--28`.
     *
     * @default - Available IP space is evenly divided across subnets.
     * @experimental
     */
    readonly cidrMask?: number;
    /**
     * (experimental) The type of Subnet to configure.
     *
     * The Subnet type will control the ability to route and connect to the
     * Internet.
     *
     * @experimental
     */
    readonly subnetType: SubnetType;
    /**
     * (experimental) Logical name for the subnet group.
     *
     * This name can be used when selecting VPC subnets to distinguish
     * between different subnet groups of the same type.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) Controls if subnet IP space needs to be reserved.
     *
     * When true, the IP space for the subnet is reserved but no actual
     * resources are provisioned. This space is only dependent on the
     * number of availibility zones and on `cidrMask` - all other subnet
     * properties are ignored.
     *
     * @default false
     * @experimental
     */
    readonly reserved?: boolean;
}
/**
 * (experimental) Define an AWS Virtual Private Cloud.
 *
 * See the package-level documentation of this package for an overview
 * of the various dimensions in which you can configure your VPC.
 *
 * For example:
 *
 * ```ts
 * const vpc = new ec2.Vpc(this, 'TheVPC', {
 *    cidr: "10.0.0.0/16"
 * })
 *
 * // Iterate the private subnets
 * const selection = vpc.selectSubnets({
 *    subnetType: ec2.SubnetType.PRIVATE
 * });
 *
 * for (const subnet of selection.subnets) {
 *    // ...
 * }
 * ```
 *
 * @experimental
 * @resource AWS::EC2::VPC
 */
export declare class Vpc extends VpcBase {
    /**
     * (experimental) The default CIDR range used when creating VPCs.
     *
     * This can be overridden using VpcProps when creating a VPCNetwork resource.
     * e.g. new VpcResource(this, { cidr: '192.168.0.0./16' })
     *
     * @experimental
     */
    static readonly DEFAULT_CIDR_RANGE: string;
    /**
     * (experimental) The default subnet configuration.
     *
     * 1 Public and 1 Private subnet per AZ evenly split
     *
     * @experimental
     */
    static readonly DEFAULT_SUBNETS: SubnetConfiguration[];
    /**
     * (experimental) The default subnet configuration if natGateways specified to be 0.
     *
     * 1 Public and 1 Isolated Subnet per AZ evenly split
     *
     * @experimental
     */
    static readonly DEFAULT_SUBNETS_NO_NAT: SubnetConfiguration[];
    /**
     * (experimental) Import an exported VPC.
     *
     * @experimental
     */
    static fromVpcAttributes(scope: Construct, id: string, attrs: VpcAttributes): IVpc;
    /**
     * (experimental) Import an existing VPC from by querying the AWS environment this stack is deployed to.
     *
     * This function only needs to be used to use VPCs not defined in your CDK
     * application. If you are looking to share a VPC between stacks, you can
     * pass the `Vpc` object between stacks and use it as normal.
     *
     * Calling this method will lead to a lookup when the CDK CLI is executed.
     * You can therefore not use any values that will only be available at
     * CloudFormation execution time (i.e., Tokens).
     *
     * The VPC information will be cached in `cdk.context.json` and the same VPC
     * will be used on future runs. To refresh the lookup, you will have to
     * evict the value from the cache using the `cdk context` command. See
     * https://docs.aws.amazon.com/cdk/latest/guide/context.html for more information.
     *
     * @experimental
     */
    static fromLookup(scope: Construct, id: string, options: VpcLookupOptions): IVpc;
    /**
     * (experimental) Identifier for this VPC.
     *
     * @experimental
     */
    readonly vpcId: string;
    /**
     * (experimental) CIDR range for this VPC.
     *
     * @experimental
     * @attribute true
     */
    readonly vpcCidrBlock: string;
    /**
     * @experimental
     * @attribute true
     */
    readonly vpcDefaultNetworkAcl: string;
    /**
     * @experimental
     * @attribute true
     */
    readonly vpcCidrBlockAssociations: string[];
    /**
     * @experimental
     * @attribute true
     */
    readonly vpcDefaultSecurityGroup: string;
    /**
     * @experimental
     * @attribute true
     */
    readonly vpcIpv6CidrBlocks: string[];
    /**
     * (experimental) List of public subnets in this VPC.
     *
     * @experimental
     */
    readonly publicSubnets: ISubnet[];
    /**
     * (experimental) List of private subnets in this VPC.
     *
     * @experimental
     */
    readonly privateSubnets: ISubnet[];
    /**
     * (experimental) List of isolated subnets in this VPC.
     *
     * @experimental
     */
    readonly isolatedSubnets: ISubnet[];
    /**
     * (experimental) AZs for this VPC.
     *
     * @experimental
     */
    readonly availabilityZones: string[];
    /**
     * (experimental) Internet Gateway for the VPC.
     *
     * Note that in case the VPC is configured only
     * with ISOLATED subnets, this attribute will be `undefined`.
     *
     * @experimental
     */
    readonly internetGatewayId?: string;
    /**
     * (experimental) Dependencies for internet connectivity.
     *
     * @experimental
     */
    readonly internetConnectivityEstablished: IDependable;
    /**
     * (experimental) Indicates if instances launched in this VPC will have public DNS hostnames.
     *
     * @experimental
     */
    readonly dnsHostnamesEnabled: boolean;
    /**
     * (experimental) Indicates if DNS support is enabled for this VPC.
     *
     * @experimental
     */
    readonly dnsSupportEnabled: boolean;
    /**
     * The VPC resource
     */
    private readonly resource;
    /**
     * The NetworkBuilder
     */
    private networkBuilder;
    /**
     * Subnet configurations for this VPC
     */
    private subnetConfiguration;
    private readonly _internetConnectivityEstablished;
    /**
     * (experimental) Vpc creates a VPC that spans a whole region.
     *
     * It will automatically divide the provided VPC CIDR range, and create public and private subnets per Availability Zone.
     * Network routing for the public subnets will be configured to allow outbound access directly via an Internet Gateway.
     * Network routing for the private subnets will be configured to allow outbound access via a set of resilient NAT Gateways (one per AZ).
     *
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: VpcProps);
    /**
     * (deprecated) Adds a new S3 gateway endpoint to this VPC.
     *
     * @deprecated use `addGatewayEndpoint()` instead
     */
    addS3Endpoint(id: string, subnets?: SubnetSelection[]): GatewayVpcEndpoint;
    /**
     * (deprecated) Adds a new DynamoDB gateway endpoint to this VPC.
     *
     * @deprecated use `addGatewayEndpoint()` instead
     */
    addDynamoDbEndpoint(id: string, subnets?: SubnetSelection[]): GatewayVpcEndpoint;
    private createNatGateways;
    /**
     * createSubnets creates the subnets specified by the subnet configuration
     * array or creates the `DEFAULT_SUBNETS` configuration
     */
    private createSubnets;
    private createSubnetResources;
}
/**
 * (experimental) Specify configuration parameters for a VPC subnet.
 *
 * @experimental
 */
export interface SubnetProps {
    /**
     * (experimental) The availability zone for the subnet.
     *
     * @experimental
     */
    readonly availabilityZone: string;
    /**
     * (experimental) The VPC which this subnet is part of.
     *
     * @experimental
     */
    readonly vpcId: string;
    /**
     * (experimental) The CIDR notation for this subnet.
     *
     * @experimental
     */
    readonly cidrBlock: string;
    /**
     * (experimental) Controls if a public IP is associated to an instance at launch.
     *
     * @default true in Subnet.Public, false in Subnet.Private or Subnet.Isolated.
     * @experimental
     */
    readonly mapPublicIpOnLaunch?: boolean;
}
/**
 * (experimental) Represents a new VPC subnet resource.
 *
 * @experimental
 * @resource AWS::EC2::Subnet
 */
export declare class Subnet extends Resource implements ISubnet {
    /**
     * @experimental
     */
    static isVpcSubnet(x: any): x is Subnet;
    /**
     * @experimental
     */
    static fromSubnetAttributes(scope: Construct, id: string, attrs: SubnetAttributes): ISubnet;
    /**
     * (experimental) Import existing subnet from id.
     *
     * @experimental
     */
    static fromSubnetId(scope: Construct, id: string, subnetId: string): ISubnet;
    /**
     * (experimental) The Availability Zone the subnet is located in.
     *
     * @experimental
     */
    readonly availabilityZone: string;
    /**
     * (experimental) The IPv4 CIDR block for this subnet.
     *
     * @experimental
     * @attribute true
     */
    readonly ipv4CidrBlock: string;
    /**
     * (experimental) The subnetId for this particular subnet.
     *
     * @experimental
     */
    readonly subnetId: string;
    /**
     * @experimental
     * @attribute true
     */
    readonly subnetVpcId: string;
    /**
     * @experimental
     * @attribute true
     */
    readonly subnetAvailabilityZone: string;
    /**
     * @experimental
     * @attribute true
     */
    readonly subnetIpv6CidrBlocks: string[];
    /**
     * @experimental
     * @attribute true
     */
    readonly subnetNetworkAclAssociationId: string;
    /**
     * (experimental) Parts of this VPC subnet.
     *
     * @experimental
     */
    readonly dependencyElements: IDependable[];
    /**
     * (experimental) The routeTableId attached to this subnet.
     *
     * @experimental
     */
    readonly routeTable: IRouteTable;
    /**
     * (experimental) Dependable that can be depended upon to force internet connectivity established on the VPC.
     *
     * @experimental
     */
    readonly internetConnectivityEstablished: IDependable;
    private readonly _internetConnectivityEstablished;
    private _networkAcl;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: SubnetProps);
    /**
     * (experimental) Create a default route that points to a passed IGW, with a dependency on the IGW's attachment to the VPC.
     *
     * @param gatewayId the logical ID (ref) of the gateway attached to your VPC.
     * @param gatewayAttachment the gateway attachment construct to be added as a dependency.
     * @experimental
     */
    addDefaultInternetRoute(gatewayId: string, gatewayAttachment: IDependable): void;
    /**
     * (experimental) Network ACL associated with this Subnet.
     *
     * Upon creation, this is the default ACL which allows all traffic, except
     * explicit DENY entries that you add.
     *
     * You can replace it with a custom ACL which denies all traffic except
     * the explic it ALLOW entries that you add by creating a `NetworkAcl`
     * object and calling `associateNetworkAcl()`.
     *
     * @experimental
     */
    get networkAcl(): INetworkAcl;
    /**
     * (experimental) Adds an entry to this subnets route table that points to the passed NATGatwayId.
     *
     * @param natGatewayId The ID of the NAT gateway.
     * @experimental
     */
    addDefaultNatRoute(natGatewayId: string): void;
    /**
     * (experimental) Adds an entry to this subnets route table.
     *
     * @experimental
     */
    addRoute(id: string, options: AddRouteOptions): void;
    /**
     * (experimental) Associate a Network ACL with this subnet.
     *
     * @experimental
     */
    associateNetworkAcl(id: string, networkAcl: INetworkAcl): void;
}
/**
 * (experimental) Options for adding a new route to a subnet.
 *
 * @experimental
 */
export interface AddRouteOptions {
    /**
     * (experimental) IPv4 range this route applies to.
     *
     * @default '0.0.0.0/0'
     * @experimental
     */
    readonly destinationCidrBlock?: string;
    /**
     * (experimental) IPv6 range this route applies to.
     *
     * @default - Uses IPv6
     * @experimental
     */
    readonly destinationIpv6CidrBlock?: string;
    /**
     * (experimental) What type of router to route this traffic to.
     *
     * @experimental
     */
    readonly routerType: RouterType;
    /**
     * (experimental) The ID of the router.
     *
     * Can be an instance ID, gateway ID, etc, depending on the router type.
     *
     * @experimental
     */
    readonly routerId: string;
    /**
     * (experimental) Whether this route will enable internet connectivity.
     *
     * If true, this route will be added before any AWS resources that depend
     * on internet connectivity in the VPC will be created.
     *
     * @default false
     * @experimental
     */
    readonly enablesInternetConnectivity?: boolean;
}
/**
 * (experimental) Type of router used in route.
 *
 * @experimental
 */
export declare enum RouterType {
    /**
     * (experimental) Egress-only Internet Gateway.
     *
     * @experimental
     */
    EGRESS_ONLY_INTERNET_GATEWAY = "EgressOnlyInternetGateway",
    /**
     * (experimental) Internet Gateway.
     *
     * @experimental
     */
    GATEWAY = "Gateway",
    /**
     * (experimental) Instance.
     *
     * @experimental
     */
    INSTANCE = "Instance",
    /**
     * (experimental) NAT Gateway.
     *
     * @experimental
     */
    NAT_GATEWAY = "NatGateway",
    /**
     * (experimental) Network Interface.
     *
     * @experimental
     */
    NETWORK_INTERFACE = "NetworkInterface",
    /**
     * (experimental) VPC peering connection.
     *
     * @experimental
     */
    VPC_PEERING_CONNECTION = "VpcPeeringConnection"
}
/**
 * @experimental
 */
export interface PublicSubnetProps extends SubnetProps {
}
/**
 * @experimental
 */
export interface IPublicSubnet extends ISubnet {
}
/**
 * @experimental
 */
export interface PublicSubnetAttributes extends SubnetAttributes {
}
/**
 * (experimental) Represents a public VPC subnet resource.
 *
 * @experimental
 */
export declare class PublicSubnet extends Subnet implements IPublicSubnet {
    /**
     * @experimental
     */
    static fromPublicSubnetAttributes(scope: Construct, id: string, attrs: PublicSubnetAttributes): IPublicSubnet;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: PublicSubnetProps);
    /**
     * (experimental) Creates a new managed NAT gateway attached to this public subnet.
     *
     * Also adds the EIP for the managed NAT.
     *
     * @returns A ref to the the NAT Gateway ID
     * @experimental
     */
    addNatGateway(): CfnNatGateway;
}
/**
 * @experimental
 */
export interface PrivateSubnetProps extends SubnetProps {
}
/**
 * @experimental
 */
export interface IPrivateSubnet extends ISubnet {
}
/**
 * @experimental
 */
export interface PrivateSubnetAttributes extends SubnetAttributes {
}
/**
 * (experimental) Represents a private VPC subnet resource.
 *
 * @experimental
 */
export declare class PrivateSubnet extends Subnet implements IPrivateSubnet {
    /**
     * @experimental
     */
    static fromPrivateSubnetAttributes(scope: Construct, id: string, attrs: PrivateSubnetAttributes): IPrivateSubnet;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: PrivateSubnetProps);
}
export {};
