import * as iam from "../../aws-iam";
import { IResource, Resource } from "../../core";
import { Construct } from 'constructs';
import { Connections, IConnectable } from './connections';
import { ISecurityGroup } from './security-group';
import { IVpc, SubnetSelection } from './vpc';
/**
 * (experimental) A VPC endpoint.
 *
 * @experimental
 */
export interface IVpcEndpoint extends IResource {
    /**
     * (experimental) The VPC endpoint identifier.
     *
     * @experimental
     * @attribute true
     */
    readonly vpcEndpointId: string;
}
/**
 * @experimental
 */
export declare abstract class VpcEndpoint extends Resource implements IVpcEndpoint {
    /**
     * (experimental) The VPC endpoint identifier.
     *
     * @experimental
     */
    abstract readonly vpcEndpointId: string;
    /**
     * @experimental
     */
    protected policyDocument?: iam.PolicyDocument;
    /**
     * (experimental) Adds a statement to the policy document of the VPC endpoint. The statement must have a Principal.
     *
     * Not all interface VPC endpoints support policy. For more information
     * see https://docs.aws.amazon.com/vpc/latest/userguide/vpce-interface.html
     *
     * @param statement the IAM statement to add.
     * @experimental
     */
    addToPolicy(statement: iam.PolicyStatement): void;
}
/**
 * (experimental) A gateway VPC endpoint.
 *
 * @experimental
 */
export interface IGatewayVpcEndpoint extends IVpcEndpoint {
}
/**
 * (experimental) The type of VPC endpoint.
 *
 * @experimental
 */
export declare enum VpcEndpointType {
    /**
     * (experimental) Interface.
     *
     * An interface endpoint is an elastic network interface with a private IP
     * address that serves as an entry point for traffic destined to a supported
     * service.
     *
     * @experimental
     */
    INTERFACE = "Interface",
    /**
     * (experimental) Gateway.
     *
     * A gateway endpoint is a gateway that is a target for a specified route in
     * your route table, used for traffic destined to a supported AWS service.
     *
     * @experimental
     */
    GATEWAY = "Gateway"
}
/**
 * (experimental) A service for a gateway VPC endpoint.
 *
 * @experimental
 */
export interface IGatewayVpcEndpointService {
    /**
     * (experimental) The name of the service.
     *
     * @experimental
     */
    readonly name: string;
}
/**
 * (experimental) An AWS service for a gateway VPC endpoint.
 *
 * @experimental
 */
export declare class GatewayVpcEndpointAwsService implements IGatewayVpcEndpointService {
    /**
     * @experimental
     */
    static readonly DYNAMODB: GatewayVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly S3: GatewayVpcEndpointAwsService;
    /**
     * (experimental) The name of the service.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * @experimental
     */
    constructor(name: string, prefix?: string);
}
/**
 * (experimental) Options to add a gateway endpoint to a VPC.
 *
 * @experimental
 */
export interface GatewayVpcEndpointOptions {
    /**
     * (experimental) The service to use for this gateway VPC endpoint.
     *
     * @experimental
     */
    readonly service: IGatewayVpcEndpointService;
    /**
     * (experimental) Where to add endpoint routing.
     *
     * By default, this endpoint will be routable from all subnets in the VPC.
     * Specify a list of subnet selection objects here to be more specific.
     *
     * @default - All subnets in the VPC
     * @experimental
     * @example
     *
     * vpc.addGatewayEndpoint('DynamoDbEndpoint', {
     *   service: ec2.GatewayVpcEndpointAwsService.DYNAMODB,
     *   // Add only to ISOLATED subnets
     *   subnets: [
     *     { subnetType: ec2.SubnetType.ISOLATED }
     *   ]
     * });
     */
    readonly subnets?: SubnetSelection[];
}
/**
 * (experimental) Construction properties for a GatewayVpcEndpoint.
 *
 * @experimental
 */
export interface GatewayVpcEndpointProps extends GatewayVpcEndpointOptions {
    /**
     * (experimental) The VPC network in which the gateway endpoint will be used.
     *
     * @experimental
     */
    readonly vpc: IVpc;
}
/**
 * (experimental) A gateway VPC endpoint.
 *
 * @experimental
 * @resource AWS::EC2::VPCEndpoint
 */
export declare class GatewayVpcEndpoint extends VpcEndpoint implements IGatewayVpcEndpoint {
    /**
     * @experimental
     */
    static fromGatewayVpcEndpointId(scope: Construct, id: string, gatewayVpcEndpointId: string): IGatewayVpcEndpoint;
    /**
     * (experimental) The gateway VPC endpoint identifier.
     *
     * @experimental
     */
    readonly vpcEndpointId: string;
    /**
     * (experimental) The date and time the gateway VPC endpoint was created.
     *
     * @experimental
     * @attribute true
     */
    readonly vpcEndpointCreationTimestamp: string;
    /**
     * @experimental
     * @attribute true
     */
    readonly vpcEndpointNetworkInterfaceIds: string[];
    /**
     * @experimental
     * @attribute true
     */
    readonly vpcEndpointDnsEntries: string[];
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: GatewayVpcEndpointProps);
}
/**
 * (experimental) A service for an interface VPC endpoint.
 *
 * @experimental
 */
export interface IInterfaceVpcEndpointService {
    /**
     * (experimental) The name of the service.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) The port of the service.
     *
     * @experimental
     */
    readonly port: number;
    /**
     * (experimental) Whether Private DNS is supported by default.
     *
     * @experimental
     */
    readonly privateDnsDefault?: boolean;
}
/**
 * (experimental) A custom-hosted service for an interface VPC endpoint.
 *
 * @experimental
 */
export declare class InterfaceVpcEndpointService implements IInterfaceVpcEndpointService {
    /**
     * (experimental) The name of the service.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) The port of the service.
     *
     * @experimental
     */
    readonly port: number;
    /**
     * (experimental) Whether Private DNS is supported by default.
     *
     * @experimental
     */
    readonly privateDnsDefault?: boolean;
    /**
     * @experimental
     */
    constructor(name: string, port?: number);
}
/**
 * (experimental) An AWS service for an interface VPC endpoint.
 *
 * @experimental
 */
export declare class InterfaceVpcEndpointAwsService implements IInterfaceVpcEndpointService {
    /**
     * @experimental
     */
    static readonly SAGEMAKER_NOTEBOOK: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly CLOUDFORMATION: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly CLOUDTRAIL: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly CODEBUILD: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly CODEBUILD_FIPS: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly CODECOMMIT: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly CODECOMMIT_FIPS: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly CODEPIPELINE: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly CONFIG: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly EC2: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly EC2_MESSAGES: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly ECR: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly ECR_DOCKER: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly ECS: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly ECS_AGENT: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly ECS_TELEMETRY: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly ELASTIC_FILESYSTEM: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly ELASTIC_FILESYSTEM_FIPS: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly ELASTIC_INFERENCE_RUNTIME: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly ELASTIC_LOAD_BALANCING: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly CLOUDWATCH_EVENTS: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly APIGATEWAY: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly CODECOMMIT_GIT: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly CODECOMMIT_GIT_FIPS: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly KINESIS_STREAMS: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly KMS: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly CLOUDWATCH_LOGS: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly CLOUDWATCH: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly SAGEMAKER_API: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly SAGEMAKER_RUNTIME: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly SAGEMAKER_RUNTIME_FIPS: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly SECRETS_MANAGER: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly SERVICE_CATALOG: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly SNS: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly SQS: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly SSM: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly SSM_MESSAGES: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly STS: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly TRANSFER: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly STORAGE_GATEWAY: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly REKOGNITION: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly REKOGNITION_FIPS: InterfaceVpcEndpointAwsService;
    /**
     * @experimental
     */
    static readonly STEP_FUNCTIONS: InterfaceVpcEndpointAwsService;
    /**
     * (experimental) The name of the service.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) The port of the service.
     *
     * @experimental
     */
    readonly port: number;
    /**
     * (experimental) Whether Private DNS is supported by default.
     *
     * @experimental
     */
    readonly privateDnsDefault?: boolean;
    /**
     * @experimental
     */
    constructor(name: string, prefix?: string, port?: number);
}
/**
 * (experimental) Options to add an interface endpoint to a VPC.
 *
 * @experimental
 */
export interface InterfaceVpcEndpointOptions {
    /**
     * (experimental) The service to use for this interface VPC endpoint.
     *
     * @experimental
     */
    readonly service: IInterfaceVpcEndpointService;
    /**
     * (experimental) Whether to associate a private hosted zone with the specified VPC.
     *
     * This
     * allows you to make requests to the service using its default DNS hostname.
     *
     * @default set by the instance of IInterfaceVpcEndpointService, or true if
     * not defined by the instance of IInterfaceVpcEndpointService
     * @experimental
     */
    readonly privateDnsEnabled?: boolean;
    /**
     * (experimental) The subnets in which to create an endpoint network interface.
     *
     * At most one
     * per availability zone.
     *
     * @default - private subnets
     * @experimental
     */
    readonly subnets?: SubnetSelection;
    /**
     * (experimental) The security groups to associate with this interface VPC endpoint.
     *
     * @default - a new security group is created
     * @experimental
     */
    readonly securityGroups?: ISecurityGroup[];
    /**
     * (experimental) Whether to automatically allow VPC traffic to the endpoint.
     *
     * If enabled, all traffic to the endpoint from within the VPC will be
     * automatically allowed. This is done based on the VPC's CIDR range.
     *
     * @default true
     * @experimental
     */
    readonly open?: boolean;
    /**
     * (experimental) Limit to only those availability zones where the endpoint service can be created.
     *
     * Setting this to 'true' requires a lookup to be performed at synthesis time. Account
     * and region must be set on the containing stack for this to work.
     *
     * @default false
     * @experimental
     */
    readonly lookupSupportedAzs?: boolean;
}
/**
 * (experimental) Construction properties for an InterfaceVpcEndpoint.
 *
 * @experimental
 */
export interface InterfaceVpcEndpointProps extends InterfaceVpcEndpointOptions {
    /**
     * (experimental) The VPC network in which the interface endpoint will be used.
     *
     * @experimental
     */
    readonly vpc: IVpc;
}
/**
 * (experimental) An interface VPC endpoint.
 *
 * @experimental
 */
export interface IInterfaceVpcEndpoint extends IVpcEndpoint, IConnectable {
}
/**
 * (experimental) A interface VPC endpoint.
 *
 * @experimental
 * @resource AWS::EC2::VPCEndpoint
 */
export declare class InterfaceVpcEndpoint extends VpcEndpoint implements IInterfaceVpcEndpoint {
    /**
     * (experimental) Imports an existing interface VPC endpoint.
     *
     * @experimental
     */
    static fromInterfaceVpcEndpointAttributes(scope: Construct, id: string, attrs: InterfaceVpcEndpointAttributes): IInterfaceVpcEndpoint;
    /**
     * (experimental) The interface VPC endpoint identifier.
     *
     * @experimental
     */
    readonly vpcEndpointId: string;
    /**
     * (experimental) The date and time the interface VPC endpoint was created.
     *
     * @experimental
     * @attribute true
     */
    readonly vpcEndpointCreationTimestamp: string;
    /**
     * (experimental) The DNS entries for the interface VPC endpoint.
     *
     * @experimental
     * @attribute true
     */
    readonly vpcEndpointDnsEntries: string[];
    /**
     * (experimental) One or more network interfaces for the interface VPC endpoint.
     *
     * @experimental
     * @attribute true
     */
    readonly vpcEndpointNetworkInterfaceIds: string[];
    /**
     * (deprecated) The identifier of the first security group associated with this interface VPC endpoint.
     *
     * @deprecated use the `connections` object
     */
    readonly securityGroupId: string;
    /**
     * (experimental) Access to network connections.
     *
     * @experimental
     */
    readonly connections: Connections;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: InterfaceVpcEndpointProps);
    /**
     * Determine which subnets to place the endpoint in. This is in its own function
     * because there's a lot of code.
     */
    private endpointSubnets;
    private availableAvailabilityZones;
}
/**
 * (experimental) Construction properties for an ImportedInterfaceVpcEndpoint.
 *
 * @experimental
 */
export interface InterfaceVpcEndpointAttributes {
    /**
     * (experimental) The interface VPC endpoint identifier.
     *
     * @experimental
     */
    readonly vpcEndpointId: string;
    /**
     * (deprecated) The identifier of the security group associated with the interface VPC endpoint.
     *
     * @deprecated use `securityGroups` instead
     */
    readonly securityGroupId?: string;
    /**
     * (experimental) The security groups associated with the interface VPC endpoint.
     *
     * @experimental
     */
    readonly securityGroups?: ISecurityGroup[];
    /**
     * (experimental) The port of the service of the interface VPC endpoint.
     *
     * @experimental
     */
    readonly port: number;
}
