import { IBucket } from "../../aws-s3";
import { Resource } from "../../core";
import { OperatingSystemType } from './machine-image';
/**
 * (experimental) Options when constructing UserData for Linux.
 *
 * @experimental
 */
export interface LinuxUserDataOptions {
    /**
     * (experimental) Shebang for the UserData script.
     *
     * @default "#!/bin/bash"
     * @experimental
     */
    readonly shebang?: string;
}
/**
 * (experimental) Options when downloading files from S3.
 *
 * @experimental
 */
export interface S3DownloadOptions {
    /**
     * (experimental) Name of the S3 bucket to download from.
     *
     * @experimental
     */
    readonly bucket: IBucket;
    /**
     * (experimental) The key of the file to download.
     *
     * @experimental
     */
    readonly bucketKey: string;
    /**
     * (experimental) The name of the local file.
     *
     * @default Linux   - /tmp/bucketKey
     * Windows - %TEMP%/bucketKey
     * @experimental
     */
    readonly localFile?: string;
}
/**
 * (experimental) Options when executing a file.
 *
 * @experimental
 */
export interface ExecuteFileOptions {
    /**
     * (experimental) The path to the file.
     *
     * @experimental
     */
    readonly filePath: string;
    /**
     * (experimental) The arguments to be passed to the file.
     *
     * @default No arguments are passed to the file.
     * @experimental
     */
    readonly arguments?: string;
}
/**
 * (experimental) Instance User Data.
 *
 * @experimental
 */
export declare abstract class UserData {
    /**
     * (experimental) Create a userdata object for Linux hosts.
     *
     * @experimental
     */
    static forLinux(options?: LinuxUserDataOptions): UserData;
    /**
     * (experimental) Create a userdata object for Windows hosts.
     *
     * @experimental
     */
    static forWindows(): UserData;
    /**
     * (experimental) Create a userdata object with custom content.
     *
     * @experimental
     */
    static custom(content: string): UserData;
    /**
     * @experimental
     */
    static forOperatingSystem(os: OperatingSystemType): UserData;
    /**
     * (experimental) Add one or more commands to the user data.
     *
     * @experimental
     */
    abstract addCommands(...commands: string[]): void;
    /**
     * (experimental) Add one or more commands to the user data that will run when the script exits.
     *
     * @experimental
     */
    abstract addOnExitCommands(...commands: string[]): void;
    /**
     * (experimental) Render the UserData for use in a construct.
     *
     * @experimental
     */
    abstract render(): string;
    /**
     * (experimental) Adds commands to download a file from S3.
     *
     * @returns : The local path that the file will be downloaded to
     * @experimental
     */
    abstract addS3DownloadCommand(params: S3DownloadOptions): string;
    /**
     * (experimental) Adds commands to execute a file.
     *
     * @experimental
     */
    abstract addExecuteFileCommand(params: ExecuteFileOptions): void;
    /**
     * (experimental) Adds a command which will send a cfn-signal when the user data script ends.
     *
     * @experimental
     */
    abstract addSignalOnExitCommand(resource: Resource): void;
}
