"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Port = exports.Protocol = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * (experimental) Protocol for use in Connection Rules.
 *
 * @experimental
 */
var Protocol;
(function (Protocol) {
    Protocol["ALL"] = "-1";
    Protocol["TCP"] = "tcp";
    Protocol["UDP"] = "udp";
    Protocol["ICMP"] = "icmp";
    Protocol["ICMPV6"] = "58";
})(Protocol = exports.Protocol || (exports.Protocol = {}));
/**
 * (experimental) Interface for classes that provide the connection-specification parts of a security group rule.
 *
 * @experimental
 */
class Port {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
        this.canInlineRule = !core_1.Token.isUnresolved(props.fromPort) && !core_1.Token.isUnresolved(props.toPort);
    }
    /**
     * (experimental) A single TCP port.
     *
     * @experimental
     */
    static tcp(port) {
        return new Port({
            protocol: Protocol.TCP,
            fromPort: port,
            toPort: port,
            stringRepresentation: renderPort(port),
        });
    }
    /**
     * (experimental) A TCP port range.
     *
     * @experimental
     */
    static tcpRange(startPort, endPort) {
        return new Port({
            protocol: Protocol.TCP,
            fromPort: startPort,
            toPort: endPort,
            stringRepresentation: `${renderPort(startPort)}-${renderPort(endPort)}`,
        });
    }
    /**
     * (experimental) Any TCP traffic.
     *
     * @experimental
     */
    static allTcp() {
        return new Port({
            protocol: Protocol.TCP,
            fromPort: 0,
            toPort: 65535,
            stringRepresentation: 'ALL PORTS',
        });
    }
    /**
     * (experimental) A single UDP port.
     *
     * @experimental
     */
    static udp(port) {
        return new Port({
            protocol: Protocol.UDP,
            fromPort: port,
            toPort: port,
            stringRepresentation: `UDP ${renderPort(port)}`,
        });
    }
    /**
     * (experimental) A UDP port range.
     *
     * @experimental
     */
    static udpRange(startPort, endPort) {
        return new Port({
            protocol: Protocol.UDP,
            fromPort: startPort,
            toPort: endPort,
            stringRepresentation: `UDP ${renderPort(startPort)}-${renderPort(endPort)}`,
        });
    }
    /**
     * (experimental) Any UDP traffic.
     *
     * @experimental
     */
    static allUdp() {
        return new Port({
            protocol: Protocol.UDP,
            fromPort: 0,
            toPort: 65535,
            stringRepresentation: 'UDP ALL PORTS',
        });
    }
    /**
     * (experimental) A specific combination of ICMP type and code.
     *
     * @see https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml
     * @experimental
     */
    static icmpTypeAndCode(type, code) {
        return new Port({
            protocol: Protocol.ICMP,
            fromPort: type,
            toPort: code,
            stringRepresentation: `ICMP Type ${type} Code ${code}`,
        });
    }
    /**
     * (experimental) All codes for a single ICMP type.
     *
     * @experimental
     */
    static icmpType(type) {
        return new Port({
            protocol: Protocol.ICMP,
            fromPort: type,
            toPort: -1,
            stringRepresentation: `ICMP Type ${type}`,
        });
    }
    /**
     * (experimental) ICMP ping (echo) traffic.
     *
     * @experimental
     */
    static icmpPing() {
        return Port.icmpType(8);
    }
    /**
     * (experimental) All ICMP traffic.
     *
     * @experimental
     */
    static allIcmp() {
        return new Port({
            protocol: Protocol.ICMP,
            fromPort: -1,
            toPort: -1,
            stringRepresentation: 'ALL ICMP',
        });
    }
    /**
     * (experimental) All traffic.
     *
     * @experimental
     */
    static allTraffic() {
        return new Port({
            protocol: Protocol.ALL,
            stringRepresentation: 'ALL TRAFFIC',
        });
    }
    /**
     * (experimental) Produce the ingress/egress rule JSON for the given connection.
     *
     * @experimental
     */
    toRuleJson() {
        return {
            ipProtocol: this.props.protocol,
            fromPort: this.props.fromPort,
            toPort: this.props.toPort,
        };
    }
    /**
     * @experimental
     */
    toString() {
        return this.props.stringRepresentation;
    }
}
exports.Port = Port;
function renderPort(port) {
    return core_1.Token.isUnresolved(port) ? '{IndirectPort}' : port.toString();
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicG9ydC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInBvcnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEscUNBQW1DLENBQUMsZ0RBQWdEOzs7Ozs7QUFJcEYsSUFBWSxRQU1YO0FBTkQsV0FBWSxRQUFRO0lBQ2hCLHNCQUFVLENBQUE7SUFDVix1QkFBVyxDQUFBO0lBQ1gsdUJBQVcsQ0FBQTtJQUNYLHlCQUFhLENBQUE7SUFDYix5QkFBYSxDQUFBO0FBQ2pCLENBQUMsRUFOVyxRQUFRLEdBQVIsZ0JBQVEsS0FBUixnQkFBUSxRQU1uQjs7Ozs7O0FBNkJELE1BQWEsSUFBSTs7OztJQXlIYixZQUE2QixLQUFnQjtRQUFoQixVQUFLLEdBQUwsS0FBSyxDQUFXO1FBQ3pDLElBQUksQ0FBQyxhQUFhLEdBQUcsQ0FBQyxZQUFLLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLFlBQUssQ0FBQyxZQUFZLENBQUMsS0FBSyxDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQ2xHLENBQUM7Ozs7OztJQXZITSxNQUFNLENBQUMsR0FBRyxDQUFDLElBQVk7UUFDMUIsT0FBTyxJQUFJLElBQUksQ0FBQztZQUNaLFFBQVEsRUFBRSxRQUFRLENBQUMsR0FBRztZQUN0QixRQUFRLEVBQUUsSUFBSTtZQUNkLE1BQU0sRUFBRSxJQUFJO1lBQ1osb0JBQW9CLEVBQUUsVUFBVSxDQUFDLElBQUksQ0FBQztTQUN6QyxDQUFDLENBQUM7SUFDUCxDQUFDOzs7Ozs7SUFJTSxNQUFNLENBQUMsUUFBUSxDQUFDLFNBQWlCLEVBQUUsT0FBZTtRQUNyRCxPQUFPLElBQUksSUFBSSxDQUFDO1lBQ1osUUFBUSxFQUFFLFFBQVEsQ0FBQyxHQUFHO1lBQ3RCLFFBQVEsRUFBRSxTQUFTO1lBQ25CLE1BQU0sRUFBRSxPQUFPO1lBQ2Ysb0JBQW9CLEVBQUUsR0FBRyxVQUFVLENBQUMsU0FBUyxDQUFDLElBQUksVUFBVSxDQUFDLE9BQU8sQ0FBQyxFQUFFO1NBQzFFLENBQUMsQ0FBQztJQUNQLENBQUM7Ozs7OztJQUlNLE1BQU0sQ0FBQyxNQUFNO1FBQ2hCLE9BQU8sSUFBSSxJQUFJLENBQUM7WUFDWixRQUFRLEVBQUUsUUFBUSxDQUFDLEdBQUc7WUFDdEIsUUFBUSxFQUFFLENBQUM7WUFDWCxNQUFNLEVBQUUsS0FBSztZQUNiLG9CQUFvQixFQUFFLFdBQVc7U0FDcEMsQ0FBQyxDQUFDO0lBQ1AsQ0FBQzs7Ozs7O0lBSU0sTUFBTSxDQUFDLEdBQUcsQ0FBQyxJQUFZO1FBQzFCLE9BQU8sSUFBSSxJQUFJLENBQUM7WUFDWixRQUFRLEVBQUUsUUFBUSxDQUFDLEdBQUc7WUFDdEIsUUFBUSxFQUFFLElBQUk7WUFDZCxNQUFNLEVBQUUsSUFBSTtZQUNaLG9CQUFvQixFQUFFLE9BQU8sVUFBVSxDQUFDLElBQUksQ0FBQyxFQUFFO1NBQ2xELENBQUMsQ0FBQztJQUNQLENBQUM7Ozs7OztJQUlNLE1BQU0sQ0FBQyxRQUFRLENBQUMsU0FBaUIsRUFBRSxPQUFlO1FBQ3JELE9BQU8sSUFBSSxJQUFJLENBQUM7WUFDWixRQUFRLEVBQUUsUUFBUSxDQUFDLEdBQUc7WUFDdEIsUUFBUSxFQUFFLFNBQVM7WUFDbkIsTUFBTSxFQUFFLE9BQU87WUFDZixvQkFBb0IsRUFBRSxPQUFPLFVBQVUsQ0FBQyxTQUFTLENBQUMsSUFBSSxVQUFVLENBQUMsT0FBTyxDQUFDLEVBQUU7U0FDOUUsQ0FBQyxDQUFDO0lBQ1AsQ0FBQzs7Ozs7O0lBSU0sTUFBTSxDQUFDLE1BQU07UUFDaEIsT0FBTyxJQUFJLElBQUksQ0FBQztZQUNaLFFBQVEsRUFBRSxRQUFRLENBQUMsR0FBRztZQUN0QixRQUFRLEVBQUUsQ0FBQztZQUNYLE1BQU0sRUFBRSxLQUFLO1lBQ2Isb0JBQW9CLEVBQUUsZUFBZTtTQUN4QyxDQUFDLENBQUM7SUFDUCxDQUFDOzs7Ozs7O0lBTU0sTUFBTSxDQUFDLGVBQWUsQ0FBQyxJQUFZLEVBQUUsSUFBWTtRQUNwRCxPQUFPLElBQUksSUFBSSxDQUFDO1lBQ1osUUFBUSxFQUFFLFFBQVEsQ0FBQyxJQUFJO1lBQ3ZCLFFBQVEsRUFBRSxJQUFJO1lBQ2QsTUFBTSxFQUFFLElBQUk7WUFDWixvQkFBb0IsRUFBRSxhQUFhLElBQUksU0FBUyxJQUFJLEVBQUU7U0FDekQsQ0FBQyxDQUFDO0lBQ1AsQ0FBQzs7Ozs7O0lBSU0sTUFBTSxDQUFDLFFBQVEsQ0FBQyxJQUFZO1FBQy9CLE9BQU8sSUFBSSxJQUFJLENBQUM7WUFDWixRQUFRLEVBQUUsUUFBUSxDQUFDLElBQUk7WUFDdkIsUUFBUSxFQUFFLElBQUk7WUFDZCxNQUFNLEVBQUUsQ0FBQyxDQUFDO1lBQ1Ysb0JBQW9CLEVBQUUsYUFBYSxJQUFJLEVBQUU7U0FDNUMsQ0FBQyxDQUFDO0lBQ1AsQ0FBQzs7Ozs7O0lBSU0sTUFBTSxDQUFDLFFBQVE7UUFDbEIsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQzVCLENBQUM7Ozs7OztJQUlNLE1BQU0sQ0FBQyxPQUFPO1FBQ2pCLE9BQU8sSUFBSSxJQUFJLENBQUM7WUFDWixRQUFRLEVBQUUsUUFBUSxDQUFDLElBQUk7WUFDdkIsUUFBUSxFQUFFLENBQUMsQ0FBQztZQUNaLE1BQU0sRUFBRSxDQUFDLENBQUM7WUFDVixvQkFBb0IsRUFBRSxVQUFVO1NBQ25DLENBQUMsQ0FBQztJQUNQLENBQUM7Ozs7OztJQUlNLE1BQU0sQ0FBQyxVQUFVO1FBQ3BCLE9BQU8sSUFBSSxJQUFJLENBQUM7WUFDWixRQUFRLEVBQUUsUUFBUSxDQUFDLEdBQUc7WUFDdEIsb0JBQW9CLEVBQUUsYUFBYTtTQUN0QyxDQUFDLENBQUM7SUFDUCxDQUFDOzs7Ozs7SUFXTSxVQUFVO1FBQ2IsT0FBTztZQUNILFVBQVUsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVE7WUFDL0IsUUFBUSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUTtZQUM3QixNQUFNLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxNQUFNO1NBQzVCLENBQUM7SUFDTixDQUFDOzs7O0lBQ00sUUFBUTtRQUNYLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQztJQUMzQyxDQUFDO0NBQ0o7QUF6SUQsb0JBeUlDO0FBQ0QsU0FBUyxVQUFVLENBQUMsSUFBWTtJQUM1QixPQUFPLFlBQUssQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFLENBQUM7QUFDekUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFRva2VuIH0gZnJvbSBcIi4uLy4uL2NvcmVcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2NvcmUnXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGVudW0gUHJvdG9jb2wge1xuICAgIEFMTCA9ICctMScsXG4gICAgVENQID0gJ3RjcCcsXG4gICAgVURQID0gJ3VkcCcsXG4gICAgSUNNUCA9ICdpY21wJyxcbiAgICBJQ01QVjYgPSAnNTgnXG59XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBQb3J0UHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHJlYWRvbmx5IHByb3RvY29sOiBQcm90b2NvbDtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcmVhZG9ubHkgZnJvbVBvcnQ/OiBudW1iZXI7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSB0b1BvcnQ/OiBudW1iZXI7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSBzdHJpbmdSZXByZXNlbnRhdGlvbjogc3RyaW5nO1xufVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgUG9ydCB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyB0Y3AocG9ydDogbnVtYmVyKTogUG9ydCB7XG4gICAgICAgIHJldHVybiBuZXcgUG9ydCh7XG4gICAgICAgICAgICBwcm90b2NvbDogUHJvdG9jb2wuVENQLFxuICAgICAgICAgICAgZnJvbVBvcnQ6IHBvcnQsXG4gICAgICAgICAgICB0b1BvcnQ6IHBvcnQsXG4gICAgICAgICAgICBzdHJpbmdSZXByZXNlbnRhdGlvbjogcmVuZGVyUG9ydChwb3J0KSxcbiAgICAgICAgfSk7XG4gICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyB0Y3BSYW5nZShzdGFydFBvcnQ6IG51bWJlciwgZW5kUG9ydDogbnVtYmVyKSB7XG4gICAgICAgIHJldHVybiBuZXcgUG9ydCh7XG4gICAgICAgICAgICBwcm90b2NvbDogUHJvdG9jb2wuVENQLFxuICAgICAgICAgICAgZnJvbVBvcnQ6IHN0YXJ0UG9ydCxcbiAgICAgICAgICAgIHRvUG9ydDogZW5kUG9ydCxcbiAgICAgICAgICAgIHN0cmluZ1JlcHJlc2VudGF0aW9uOiBgJHtyZW5kZXJQb3J0KHN0YXJ0UG9ydCl9LSR7cmVuZGVyUG9ydChlbmRQb3J0KX1gLFxuICAgICAgICB9KTtcbiAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgYWxsVGNwKCkge1xuICAgICAgICByZXR1cm4gbmV3IFBvcnQoe1xuICAgICAgICAgICAgcHJvdG9jb2w6IFByb3RvY29sLlRDUCxcbiAgICAgICAgICAgIGZyb21Qb3J0OiAwLFxuICAgICAgICAgICAgdG9Qb3J0OiA2NTUzNSxcbiAgICAgICAgICAgIHN0cmluZ1JlcHJlc2VudGF0aW9uOiAnQUxMIFBPUlRTJyxcbiAgICAgICAgfSk7XG4gICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgdWRwKHBvcnQ6IG51bWJlcik6IFBvcnQge1xuICAgICAgICByZXR1cm4gbmV3IFBvcnQoe1xuICAgICAgICAgICAgcHJvdG9jb2w6IFByb3RvY29sLlVEUCxcbiAgICAgICAgICAgIGZyb21Qb3J0OiBwb3J0LFxuICAgICAgICAgICAgdG9Qb3J0OiBwb3J0LFxuICAgICAgICAgICAgc3RyaW5nUmVwcmVzZW50YXRpb246IGBVRFAgJHtyZW5kZXJQb3J0KHBvcnQpfWAsXG4gICAgICAgIH0pO1xuICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgdWRwUmFuZ2Uoc3RhcnRQb3J0OiBudW1iZXIsIGVuZFBvcnQ6IG51bWJlcikge1xuICAgICAgICByZXR1cm4gbmV3IFBvcnQoe1xuICAgICAgICAgICAgcHJvdG9jb2w6IFByb3RvY29sLlVEUCxcbiAgICAgICAgICAgIGZyb21Qb3J0OiBzdGFydFBvcnQsXG4gICAgICAgICAgICB0b1BvcnQ6IGVuZFBvcnQsXG4gICAgICAgICAgICBzdHJpbmdSZXByZXNlbnRhdGlvbjogYFVEUCAke3JlbmRlclBvcnQoc3RhcnRQb3J0KX0tJHtyZW5kZXJQb3J0KGVuZFBvcnQpfWAsXG4gICAgICAgIH0pO1xuICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyBhbGxVZHAoKSB7XG4gICAgICAgIHJldHVybiBuZXcgUG9ydCh7XG4gICAgICAgICAgICBwcm90b2NvbDogUHJvdG9jb2wuVURQLFxuICAgICAgICAgICAgZnJvbVBvcnQ6IDAsXG4gICAgICAgICAgICB0b1BvcnQ6IDY1NTM1LFxuICAgICAgICAgICAgc3RyaW5nUmVwcmVzZW50YXRpb246ICdVRFAgQUxMIFBPUlRTJyxcbiAgICAgICAgfSk7XG4gICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgaWNtcFR5cGVBbmRDb2RlKHR5cGU6IG51bWJlciwgY29kZTogbnVtYmVyKSB7XG4gICAgICAgIHJldHVybiBuZXcgUG9ydCh7XG4gICAgICAgICAgICBwcm90b2NvbDogUHJvdG9jb2wuSUNNUCxcbiAgICAgICAgICAgIGZyb21Qb3J0OiB0eXBlLFxuICAgICAgICAgICAgdG9Qb3J0OiBjb2RlLFxuICAgICAgICAgICAgc3RyaW5nUmVwcmVzZW50YXRpb246IGBJQ01QIFR5cGUgJHt0eXBlfSBDb2RlICR7Y29kZX1gLFxuICAgICAgICB9KTtcbiAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyBpY21wVHlwZSh0eXBlOiBudW1iZXIpOiBQb3J0IHtcbiAgICAgICAgcmV0dXJuIG5ldyBQb3J0KHtcbiAgICAgICAgICAgIHByb3RvY29sOiBQcm90b2NvbC5JQ01QLFxuICAgICAgICAgICAgZnJvbVBvcnQ6IHR5cGUsXG4gICAgICAgICAgICB0b1BvcnQ6IC0xLFxuICAgICAgICAgICAgc3RyaW5nUmVwcmVzZW50YXRpb246IGBJQ01QIFR5cGUgJHt0eXBlfWAsXG4gICAgICAgIH0pO1xuICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyBpY21wUGluZygpIHtcbiAgICAgICAgcmV0dXJuIFBvcnQuaWNtcFR5cGUoOCk7XG4gICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyBhbGxJY21wKCkge1xuICAgICAgICByZXR1cm4gbmV3IFBvcnQoe1xuICAgICAgICAgICAgcHJvdG9jb2w6IFByb3RvY29sLklDTVAsXG4gICAgICAgICAgICBmcm9tUG9ydDogLTEsXG4gICAgICAgICAgICB0b1BvcnQ6IC0xLFxuICAgICAgICAgICAgc3RyaW5nUmVwcmVzZW50YXRpb246ICdBTEwgSUNNUCcsXG4gICAgICAgIH0pO1xuICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIGFsbFRyYWZmaWMoKSB7XG4gICAgICAgIHJldHVybiBuZXcgUG9ydCh7XG4gICAgICAgICAgICBwcm90b2NvbDogUHJvdG9jb2wuQUxMLFxuICAgICAgICAgICAgc3RyaW5nUmVwcmVzZW50YXRpb246ICdBTEwgVFJBRkZJQycsXG4gICAgICAgIH0pO1xuICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHJlYWRvbmx5IGNhbklubGluZVJ1bGU6IGJvb2xlYW47XG4gICAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBwcm9wczogUG9ydFByb3BzKSB7XG4gICAgICAgIHRoaXMuY2FuSW5saW5lUnVsZSA9ICFUb2tlbi5pc1VucmVzb2x2ZWQocHJvcHMuZnJvbVBvcnQpICYmICFUb2tlbi5pc1VucmVzb2x2ZWQocHJvcHMudG9Qb3J0KTtcbiAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgdG9SdWxlSnNvbigpOiBhbnkge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgaXBQcm90b2NvbDogdGhpcy5wcm9wcy5wcm90b2NvbCxcbiAgICAgICAgICAgIGZyb21Qb3J0OiB0aGlzLnByb3BzLmZyb21Qb3J0LFxuICAgICAgICAgICAgdG9Qb3J0OiB0aGlzLnByb3BzLnRvUG9ydCxcbiAgICAgICAgfTtcbiAgICB9XG4gICAgcHVibGljIHRvU3RyaW5nKCk6IHN0cmluZyB7XG4gICAgICAgIHJldHVybiB0aGlzLnByb3BzLnN0cmluZ1JlcHJlc2VudGF0aW9uO1xuICAgIH1cbn1cbmZ1bmN0aW9uIHJlbmRlclBvcnQocG9ydDogbnVtYmVyKSB7XG4gICAgcmV0dXJuIFRva2VuLmlzVW5yZXNvbHZlZChwb3J0KSA/ICd7SW5kaXJlY3RQb3J0fScgOiBwb3J0LnRvU3RyaW5nKCk7XG59XG4iXX0=