import { IConnectable } from './connections';
/**
 * (experimental) Interface for classes that provide the peer-specification parts of a security group rule.
 *
 * @experimental
 */
export interface IPeer extends IConnectable {
    /**
     * (experimental) Whether the rule can be inlined into a SecurityGroup or not.
     *
     * @experimental
     */
    readonly canInlineRule: boolean;
    /**
     * (experimental) A unique identifier for this connection peer.
     *
     * @experimental
     */
    readonly uniqueId: string;
    /**
     * (experimental) Produce the ingress rule JSON for the given connection.
     *
     * @experimental
     */
    toIngressRuleConfig(): any;
    /**
     * (experimental) Produce the egress rule JSON for the given connection.
     *
     * @experimental
     */
    toEgressRuleConfig(): any;
}
/**
 * (experimental) Peer object factories (to be used in Security Group management).
 *
 * The static methods on this object can be used to create peer objects
 * which represent a connection partner in Security Group rules.
 *
 * Use this object if you need to represent connection partners using plain IP
 * addresses, or a prefix list ID.
 *
 * If you want to address a connection partner by Security Group, you can just
 * use the Security Group (or the construct that contains a Security Group)
 * directly, as it already implements `IPeer`.
 *
 * @experimental
 */
export declare class Peer {
    /**
     * (experimental) Create an IPv4 peer from a CIDR.
     *
     * @experimental
     */
    static ipv4(cidrIp: string): IPeer;
    /**
     * (experimental) Any IPv4 address.
     *
     * @experimental
     */
    static anyIpv4(): IPeer;
    /**
     * (experimental) Create an IPv6 peer from a CIDR.
     *
     * @experimental
     */
    static ipv6(cidrIp: string): IPeer;
    /**
     * (experimental) Any IPv6 address.
     *
     * @experimental
     */
    static anyIpv6(): IPeer;
    /**
     * (experimental) A prefix list.
     *
     * @experimental
     */
    static prefixList(prefixListId: string): IPeer;
    /**
     * @experimental
     */
    protected constructor();
}
