import { Construct } from "../../core";
import { UserData } from './user-data';
import { WindowsVersion } from './windows-versions';
/**
 * (experimental) Interface for classes that can select an appropriate machine image to use.
 *
 * @experimental
 */
export interface IMachineImage {
    /**
     * (experimental) Return the image to use in the given context.
     *
     * @experimental
     */
    getImage(scope: Construct): MachineImageConfig;
}
/**
 * (experimental) Factory functions for standard Amazon Machine Image objects.
 *
 * @experimental
 */
export declare abstract class MachineImage {
    /**
     * (experimental) A Windows image that is automatically kept up-to-date.
     *
     * This Machine Image automatically updates to the latest version on every
     * deployment. Be aware this will cause your instances to be replaced when a
     * new version of the image becomes available. Do not store stateful information
     * on the instance if you are using this image.
     *
     * @experimental
     */
    static latestWindows(version: WindowsVersion, props?: WindowsImageProps): IMachineImage;
    /**
     * (experimental) An Amazon Linux image that is automatically kept up-to-date.
     *
     * This Machine Image automatically updates to the latest version on every
     * deployment. Be aware this will cause your instances to be replaced when a
     * new version of the image becomes available. Do not store stateful information
     * on the instance if you are using this image.
     *
     * @experimental
     */
    static latestAmazonLinux(props?: AmazonLinuxImageProps): IMachineImage;
    /**
     * (experimental) A Linux image where you specify the AMI ID for every region.
     *
     * @param amiMap For every region where you are deploying the stack, specify the AMI ID for that region.
     * @param props Customize the image by supplying additional props.
     * @experimental
     */
    static genericLinux(amiMap: Record<string, string>, props?: GenericLinuxImageProps): IMachineImage;
    /**
     * (experimental) A Windows image where you specify the AMI ID for every region.
     *
     * @param amiMap For every region where you are deploying the stack, specify the AMI ID for that region.
     * @param props Customize the image by supplying additional props.
     * @experimental
     */
    static genericWindows(amiMap: Record<string, string>, props?: GenericWindowsImageProps): IMachineImage;
    /**
     * (experimental) An image specified in SSM parameter store that is automatically kept up-to-date.
     *
     * This Machine Image automatically updates to the latest version on every
     * deployment. Be aware this will cause your instances to be replaced when a
     * new version of the image becomes available. Do not store stateful information
     * on the instance if you are using this image.
     *
     * @param parameterName The name of SSM parameter containing the AMi id.
     * @param os The operating system type of the AMI.
     * @param userData optional user data for the given image.
     * @experimental
     */
    static fromSSMParameter(parameterName: string, os: OperatingSystemType, userData?: UserData): IMachineImage;
    /**
     * (experimental) Look up a shared Machine Image using DescribeImages.
     *
     * The most recent, available, launchable image matching the given filter
     * criteria will be used. Looking up AMIs may take a long time; specify
     * as many filter criteria as possible to narrow down the search.
     *
     * The AMI selected will be cached in `cdk.context.json` and the same value
     * will be used on future runs. To refresh the AMI lookup, you will have to
     * evict the value from the cache using the `cdk context` command. See
     * https://docs.aws.amazon.com/cdk/latest/guide/context.html for more information.
     *
     * @experimental
     */
    static lookup(props: LookupMachineImageProps): IMachineImage;
}
/**
 * (experimental) Configuration for a machine image.
 *
 * @experimental
 */
export interface MachineImageConfig {
    /**
     * (experimental) The AMI ID of the image to use.
     *
     * @experimental
     */
    readonly imageId: string;
    /**
     * (experimental) Operating system type for this image.
     *
     * @experimental
     */
    readonly osType: OperatingSystemType;
    /**
     * (experimental) Initial UserData for this image.
     *
     * @experimental
     */
    readonly userData: UserData;
}
/**
 * (experimental) Select the image based on a given SSM parameter.
 *
 * This Machine Image automatically updates to the latest version on every
 * deployment. Be aware this will cause your instances to be replaced when a
 * new version of the image becomes available. Do not store stateful information
 * on the instance if you are using this image.
 *
 * The AMI ID is selected using the values published to the SSM parameter store.
 *
 * @experimental
 */
export declare class GenericSSMParameterImage implements IMachineImage {
    private readonly parameterName;
    private readonly os;
    private readonly userData?;
    /**
     * @experimental
     */
    constructor(parameterName: string, os: OperatingSystemType, userData?: UserData | undefined);
    /**
     * (experimental) Return the image to use in the given context.
     *
     * @experimental
     */
    getImage(scope: Construct): MachineImageConfig;
}
/**
 * (experimental) Configuration options for WindowsImage.
 *
 * @experimental
 */
export interface WindowsImageProps {
    /**
     * (experimental) Initial user data.
     *
     * @default - Empty UserData for Windows machines
     * @experimental
     */
    readonly userData?: UserData;
}
/**
 * (experimental) Select the latest version of the indicated Windows version.
 *
 * This Machine Image automatically updates to the latest version on every
 * deployment. Be aware this will cause your instances to be replaced when a
 * new version of the image becomes available. Do not store stateful information
 * on the instance if you are using this image.
 *
 * The AMI ID is selected using the values published to the SSM parameter store.
 *
 * https://aws.amazon.com/blogs/mt/query-for-the-latest-windows-ami-using-systems-manager-parameter-store/
 *
 * @experimental
 */
export declare class WindowsImage extends GenericSSMParameterImage {
    /**
     * @experimental
     */
    constructor(version: WindowsVersion, props?: WindowsImageProps);
}
/**
 * (experimental) CPU type.
 *
 * @experimental
 */
export declare enum AmazonLinuxCpuType {
    /**
     * (experimental) arm64 CPU type.
     *
     * @experimental
     */
    ARM_64 = "arm64",
    /**
     * (experimental) x86_64 CPU type.
     *
     * @experimental
     */
    X86_64 = "x86_64"
}
/**
 * (experimental) Amazon Linux image properties.
 *
 * @experimental
 */
export interface AmazonLinuxImageProps {
    /**
     * (experimental) What generation of Amazon Linux to use.
     *
     * @default AmazonLinux
     * @experimental
     */
    readonly generation?: AmazonLinuxGeneration;
    /**
     * (experimental) What edition of Amazon Linux to use.
     *
     * @default Standard
     * @experimental
     */
    readonly edition?: AmazonLinuxEdition;
    /**
     * (experimental) Virtualization type.
     *
     * @default HVM
     * @experimental
     */
    readonly virtualization?: AmazonLinuxVirt;
    /**
     * (experimental) What storage backed image to use.
     *
     * @default GeneralPurpose
     * @experimental
     */
    readonly storage?: AmazonLinuxStorage;
    /**
     * (experimental) Initial user data.
     *
     * @default - Empty UserData for Linux machines
     * @experimental
     */
    readonly userData?: UserData;
    /**
     * (experimental) CPU Type.
     *
     * @default X86_64
     * @experimental
     */
    readonly cpuType?: AmazonLinuxCpuType;
}
/**
 * (experimental) Selects the latest version of Amazon Linux.
 *
 * This Machine Image automatically updates to the latest version on every
 * deployment. Be aware this will cause your instances to be replaced when a
 * new version of the image becomes available. Do not store stateful information
 * on the instance if you are using this image.
 *
 * The AMI ID is selected using the values published to the SSM parameter store.
 *
 * @experimental
 */
export declare class AmazonLinuxImage extends GenericSSMParameterImage {
    /**
     * @experimental
     */
    constructor(props?: AmazonLinuxImageProps);
}
/**
 * (experimental) What generation of Amazon Linux to use.
 *
 * @experimental
 */
export declare enum AmazonLinuxGeneration {
    /**
     * (experimental) Amazon Linux.
     *
     * @experimental
     */
    AMAZON_LINUX = "amzn",
    /**
     * (experimental) Amazon Linux 2.
     *
     * @experimental
     */
    AMAZON_LINUX_2 = "amzn2"
}
/**
 * (experimental) Amazon Linux edition.
 *
 * @experimental
 */
export declare enum AmazonLinuxEdition {
    /**
     * (experimental) Standard edition.
     *
     * @experimental
     */
    STANDARD = "standard",
    /**
     * (experimental) Minimal edition.
     *
     * @experimental
     */
    MINIMAL = "minimal"
}
/**
 * (experimental) Virtualization type for Amazon Linux.
 *
 * @experimental
 */
export declare enum AmazonLinuxVirt {
    /**
     * (experimental) HVM virtualization (recommended).
     *
     * @experimental
     */
    HVM = "hvm",
    /**
     * (experimental) PV virtualization.
     *
     * @experimental
     */
    PV = "pv"
}
/**
 * @experimental
 */
export declare enum AmazonLinuxStorage {
    /**
     * (experimental) EBS-backed storage.
     *
     * @experimental
     */
    EBS = "ebs",
    /**
     * S3-backed storage
     */
    S3 = "ebs",
    /**
     * (experimental) General Purpose-based storage (recommended).
     *
     * @experimental
     */
    GENERAL_PURPOSE = "gp2"
}
/**
 * (experimental) Configuration options for GenericLinuxImage.
 *
 * @experimental
 */
export interface GenericLinuxImageProps {
    /**
     * (experimental) Initial user data.
     *
     * @default - Empty UserData for Linux machines
     * @experimental
     */
    readonly userData?: UserData;
}
/**
 * (experimental) Configuration options for GenericWindowsImage.
 *
 * @experimental
 */
export interface GenericWindowsImageProps {
    /**
     * (experimental) Initial user data.
     *
     * @default - Empty UserData for Windows machines
     * @experimental
     */
    readonly userData?: UserData;
}
/**
 * (experimental) Construct a Linux machine image from an AMI map.
 *
 * Linux images IDs are not published to SSM parameter store yet, so you'll have to
 * manually specify an AMI map.
 *
 * @experimental
 */
export declare class GenericLinuxImage implements IMachineImage {
    private readonly amiMap;
    private readonly props;
    /**
     * @experimental
     */
    constructor(amiMap: {
        [region: string]: string;
    }, props?: GenericLinuxImageProps);
    /**
     * (experimental) Return the image to use in the given context.
     *
     * @experimental
     */
    getImage(scope: Construct): MachineImageConfig;
}
/**
 * (experimental) Construct a Windows machine image from an AMI map.
 *
 * Allows you to create a generic Windows EC2 , manually specify an AMI map.
 *
 * @experimental
 */
export declare class GenericWindowsImage implements IMachineImage {
    private readonly amiMap;
    private readonly props;
    /**
     * @experimental
     */
    constructor(amiMap: {
        [region: string]: string;
    }, props?: GenericWindowsImageProps);
    /**
     * (experimental) Return the image to use in the given context.
     *
     * @experimental
     */
    getImage(scope: Construct): MachineImageConfig;
}
/**
 * (experimental) The OS type of a particular image.
 *
 * @experimental
 */
export declare enum OperatingSystemType {
    /**
     * @experimental
     */
    LINUX = 0,
    /**
     * @experimental
     */
    WINDOWS = 1,
    /**
     * (experimental) Used when the type of the operating system is not known (for example, for imported Auto-Scaling Groups).
     *
     * @experimental
     */
    UNKNOWN = 2
}
/**
 * (experimental) A machine image whose AMI ID will be searched using DescribeImages.
 *
 * The most recent, available, launchable image matching the given filter
 * criteria will be used. Looking up AMIs may take a long time; specify
 * as many filter criteria as possible to narrow down the search.
 *
 * The AMI selected will be cached in `cdk.context.json` and the same value
 * will be used on future runs. To refresh the AMI lookup, you will have to
 * evict the value from the cache using the `cdk context` command. See
 * https://docs.aws.amazon.com/cdk/latest/guide/context.html for more information.
 *
 * @experimental
 */
export declare class LookupMachineImage implements IMachineImage {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: LookupMachineImageProps);
    /**
     * (experimental) Return the image to use in the given context.
     *
     * @experimental
     */
    getImage(scope: Construct): MachineImageConfig;
}
/**
 * (experimental) Properties for looking up an image.
 *
 * @experimental
 */
export interface LookupMachineImageProps {
    /**
     * (experimental) Name of the image (may contain wildcards).
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) Owner account IDs or aliases.
     *
     * @default - All owners
     * @experimental
     */
    readonly owners?: string[];
    /**
     * (experimental) Additional filters on the AMI.
     *
     * @default - No additional filters
     * @see https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImages.html
     * @experimental
     */
    readonly filters?: {
        [key: string]: string[];
    };
    /**
     * (experimental) Look for Windows images.
     *
     * @default false
     * @experimental
     */
    readonly windows?: boolean;
    /**
     * (experimental) Custom userdata for this image.
     *
     * @default - Empty user data appropriate for the platform type
     * @experimental
     */
    readonly userData?: UserData;
}
