"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceType = exports.InstanceSize = exports.InstanceClass = void 0;
/**
 * (experimental) What class and generation of instance to use.
 *
 * We have both symbolic and concrete enums for every type.
 *
 * The first are for people that want to specify by purpose,
 * the second one are for people who already know exactly what
 * 'R4' means.
 *
 * @experimental
 */
var InstanceClass;
(function (InstanceClass) {
    InstanceClass["STANDARD3"] = "m3";
    /**
     * Standard instances, 3rd generation
     */
    InstanceClass["M3"] = "m3";
    InstanceClass["STANDARD4"] = "m4";
    /**
     * Standard instances, 4th generation
     */
    InstanceClass["M4"] = "m4";
    InstanceClass["STANDARD5"] = "m5";
    /**
     * Standard instances, 5th generation
     */
    InstanceClass["M5"] = "m5";
    InstanceClass["STANDARD5_NVME_DRIVE"] = "m5d";
    /**
     * Standard instances with local NVME drive, 5th generation
     */
    InstanceClass["M5D"] = "m5d";
    InstanceClass["STANDARD5_AMD"] = "m5a";
    /**
     * Standard instances based on AMD EPYC, 5th generation
     */
    InstanceClass["M5A"] = "m5a";
    InstanceClass["STANDARD5_AMD_NVME_DRIVE"] = "m5ad";
    /**
     * Standard instances based on AMD EPYC with local NVME drive, 5th generation
     */
    InstanceClass["M5AD"] = "m5ad";
    InstanceClass["MEMORY3"] = "r3";
    /**
     * Memory optimized instances, 3rd generation
     */
    InstanceClass["R3"] = "r3";
    InstanceClass["MEMORY4"] = "r4";
    /**
     * Memory optimized instances, 4th generation
     */
    InstanceClass["R4"] = "r4";
    InstanceClass["MEMORY5"] = "r5";
    /**
     * Memory optimized instances, 5th generation
     */
    InstanceClass["R5"] = "r5";
    InstanceClass["MEMORY5_HIGH_PERFORMANCE"] = "r5n";
    /**
     * Memory optimized instances for high performance computing, 5th generation
     */
    InstanceClass["R5N"] = "r5n";
    InstanceClass["MEMORY5_NVME_DRIVE"] = "r5d";
    /**
     * Memory optimized instances with local NVME drive, 5th generation
     */
    InstanceClass["R5D"] = "r5d";
    InstanceClass["MEMORY5_NVME_DRIVE_HIGH_PERFORMANCE"] = "r5dn";
    /**
     * Memory optimized instances with local NVME drive for high performance computing, 5th generation
     */
    InstanceClass["R5DN"] = "r5dn";
    InstanceClass["MEMORY5_AMD"] = "r5a";
    /**
     * Memory optimized instances based on AMD EPYC, 5th generation
     */
    InstanceClass["R5A"] = "r5a";
    /**
     * Memory optimized instances based on AMD EPYC with local NVME drive, 5th generation
     */
    InstanceClass["MEMORY5_AMD_NVME_DRIVE"] = "r5a";
    /**
     * Memory optimized instances based on AMD EPYC with local NVME drive, 5th generation
     */
    InstanceClass["R5AD"] = "r5a";
    InstanceClass["COMPUTE3"] = "c3";
    /**
     * Compute optimized instances, 3rd generation
     */
    InstanceClass["C3"] = "c3";
    InstanceClass["COMPUTE4"] = "c4";
    /**
     * Compute optimized instances, 4th generation
     */
    InstanceClass["C4"] = "c4";
    InstanceClass["COMPUTE5"] = "c5";
    /**
     * Compute optimized instances, 5th generation
     */
    InstanceClass["C5"] = "c5";
    InstanceClass["COMPUTE5_NVME_DRIVE"] = "c5d";
    /**
     * Compute optimized instances with local NVME drive, 5th generation
     */
    InstanceClass["C5D"] = "c5d";
    InstanceClass["COMPUTE5_HIGH_PERFORMANCE"] = "c5n";
    /**
     * Compute optimized instances for high performance computing, 5th generation
     */
    InstanceClass["C5N"] = "c5n";
    InstanceClass["COMPUTE6_GRAVITON2"] = "c6g";
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors
     */
    InstanceClass["C6G"] = "c6g";
    InstanceClass["COMPUTE6_GRAVITON2_NVME_DRIVE"] = "c6gd";
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors
     * and local NVME drive
     */
    InstanceClass["C6GD"] = "c6gd";
    InstanceClass["STORAGE2"] = "d2";
    /**
     * Storage-optimized instances, 2nd generation
     */
    InstanceClass["D2"] = "d2";
    InstanceClass["STORAGE_COMPUTE_1"] = "h1";
    /**
     * Storage/compute balanced instances, 1st generation
     */
    InstanceClass["H1"] = "h1";
    InstanceClass["IO3"] = "i3";
    /**
     * I/O-optimized instances, 3rd generation
     */
    InstanceClass["I3"] = "i3";
    InstanceClass["IO3_DENSE_NVME_DRIVE"] = "i3en";
    /**
     * I/O-optimized instances with local NVME drive, 3rd generation
     */
    InstanceClass["I3EN"] = "i3en";
    InstanceClass["BURSTABLE2"] = "t2";
    /**
     * Burstable instances, 2nd generation
     */
    InstanceClass["T2"] = "t2";
    InstanceClass["BURSTABLE3"] = "t3";
    /**
     * Burstable instances, 3rd generation
     */
    InstanceClass["T3"] = "t3";
    InstanceClass["BURSTABLE3_AMD"] = "t3a";
    /**
     * Burstable instances based on AMD EPYC, 3rd generation
     */
    InstanceClass["T3A"] = "t3a";
    InstanceClass["MEMORY_INTENSIVE_1"] = "x1";
    /**
     * Memory-intensive instances, 1st generation
     */
    InstanceClass["X1"] = "x1";
    InstanceClass["MEMORY_INTENSIVE_1_EXTENDED"] = "x1e";
    /**
     * Memory-intensive instances, 1st generation
     */
    InstanceClass["X1E"] = "x1e";
    InstanceClass["FPGA1"] = "f1";
    /**
     * Instances with customizable hardware acceleration, 1st generation
     */
    InstanceClass["F1"] = "f1";
    InstanceClass["GRAPHICS3"] = "g3";
    /**
     * Graphics-optimized instances, 3rd generation
     */
    InstanceClass["G3"] = "g3";
    InstanceClass["GRAPHICS4_NVME_DRIVE_HIGH_PERFORMANCE"] = "g4dn";
    /**
     * Graphics-optimized instances with NVME drive for high performance computing, 4th generation
     */
    InstanceClass["G4DN"] = "g4dn";
    InstanceClass["PARALLEL2"] = "p2";
    /**
     * Parallel-processing optimized instances, 2nd generation
     */
    InstanceClass["P2"] = "p2";
    InstanceClass["PARALLEL3"] = "p3";
    /**
     * Parallel-processing optimized instances, 3nd generation
     */
    InstanceClass["P3"] = "p3";
    InstanceClass["ARM1"] = "a1";
    /**
     * Arm processor based instances, 1st generation
     */
    InstanceClass["A1"] = "a1";
    InstanceClass["STANDARD6_GRAVITON"] = "m6g";
    /**
     * Arm processor based instances, 2nd generation
     */
    InstanceClass["M6G"] = "m6g";
    InstanceClass["HIGH_COMPUTE_MEMORY1"] = "z1d";
    /**
     * High memory and compute capacity instances, 1st generation
     */
    InstanceClass["Z1D"] = "z1d";
    InstanceClass["INFERENCE1"] = "inf1";
    /**
     * Inferentia Chips based instances for machine learning inference applications, 1st generation
     */
    InstanceClass["INF1"] = "inf1";
})(InstanceClass = exports.InstanceClass || (exports.InstanceClass = {}));
/**
 * (experimental) What size of instance to use.
 *
 * @experimental
 */
var InstanceSize;
(function (InstanceSize) {
    InstanceSize["NANO"] = "nano";
    InstanceSize["MICRO"] = "micro";
    InstanceSize["SMALL"] = "small";
    InstanceSize["MEDIUM"] = "medium";
    InstanceSize["LARGE"] = "large";
    InstanceSize["XLARGE"] = "xlarge";
    InstanceSize["XLARGE2"] = "2xlarge";
    InstanceSize["XLARGE4"] = "4xlarge";
    InstanceSize["XLARGE6"] = "6xlarge";
    InstanceSize["XLARGE8"] = "8xlarge";
    InstanceSize["XLARGE9"] = "9xlarge";
    InstanceSize["XLARGE10"] = "10xlarge";
    InstanceSize["XLARGE12"] = "12xlarge";
    InstanceSize["XLARGE16"] = "16xlarge";
    InstanceSize["XLARGE18"] = "18xlarge";
    InstanceSize["XLARGE24"] = "24xlarge";
    InstanceSize["XLARGE32"] = "32xlarge";
    InstanceSize["METAL"] = "metal";
})(InstanceSize = exports.InstanceSize || (exports.InstanceSize = {}));
/**
 * (experimental) Instance type for EC2 instances.
 *
 * This class takes a literal string, good if you already
 * know the identifier of the type you want.
 *
 * @experimental
 */
class InstanceType {
    /**
     * @experimental
     */
    constructor(instanceTypeIdentifier) {
        this.instanceTypeIdentifier = instanceTypeIdentifier;
    }
    /**
     * (experimental) Instance type for EC2 instances.
     *
     * This class takes a combination of a class and size.
     *
     * Be aware that not all combinations of class and size are available, and not all
     * classes are available in all regions.
     *
     * @experimental
     */
    static of(instanceClass, instanceSize) {
        return new InstanceType(`${instanceClass}.${instanceSize}`);
    }
    /**
     * (experimental) Return the instance type as a dotted string.
     *
     * @experimental
     */
    toString() {
        return this.instanceTypeIdentifier;
    }
}
exports.InstanceType = InstanceType;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5zdGFuY2UtdHlwZXMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbnN0YW5jZS10eXBlcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7OztBQVNBLElBQVksYUEyVFg7QUEzVEQsV0FBWSxhQUFhO0lBSXJCLGlDQUFnQixDQUFBO0lBQ2hCOztPQUVHO0lBQ0gsMEJBQVMsQ0FBQTtJQUlULGlDQUFnQixDQUFBO0lBQ2hCOztPQUVHO0lBQ0gsMEJBQVMsQ0FBQTtJQUlULGlDQUFnQixDQUFBO0lBQ2hCOztPQUVHO0lBQ0gsMEJBQVMsQ0FBQTtJQUlULDZDQUE0QixDQUFBO0lBQzVCOztPQUVHO0lBQ0gsNEJBQVcsQ0FBQTtJQUlYLHNDQUFxQixDQUFBO0lBQ3JCOztPQUVHO0lBQ0gsNEJBQVcsQ0FBQTtJQUlYLGtEQUFpQyxDQUFBO0lBQ2pDOztPQUVHO0lBQ0gsOEJBQWEsQ0FBQTtJQUliLCtCQUFjLENBQUE7SUFDZDs7T0FFRztJQUNILDBCQUFTLENBQUE7SUFJVCwrQkFBYyxDQUFBO0lBQ2Q7O09BRUc7SUFDSCwwQkFBUyxDQUFBO0lBSVQsK0JBQWMsQ0FBQTtJQUNkOztPQUVHO0lBQ0gsMEJBQVMsQ0FBQTtJQUlULGlEQUFnQyxDQUFBO0lBQ2hDOztPQUVHO0lBQ0gsNEJBQVcsQ0FBQTtJQUlYLDJDQUEwQixDQUFBO0lBQzFCOztPQUVHO0lBQ0gsNEJBQVcsQ0FBQTtJQUlYLDZEQUE0QyxDQUFBO0lBQzVDOztPQUVHO0lBQ0gsOEJBQWEsQ0FBQTtJQUliLG9DQUFtQixDQUFBO0lBQ25COztPQUVHO0lBQ0gsNEJBQVcsQ0FBQTtJQUNYOztPQUVHO0lBQ0gsK0NBQThCLENBQUE7SUFDOUI7O09BRUc7SUFDSCw2QkFBWSxDQUFBO0lBSVosZ0NBQWUsQ0FBQTtJQUNmOztPQUVHO0lBQ0gsMEJBQVMsQ0FBQTtJQUlULGdDQUFlLENBQUE7SUFDZjs7T0FFRztJQUNILDBCQUFTLENBQUE7SUFJVCxnQ0FBZSxDQUFBO0lBQ2Y7O09BRUc7SUFDSCwwQkFBUyxDQUFBO0lBSVQsNENBQTJCLENBQUE7SUFDM0I7O09BRUc7SUFDSCw0QkFBVyxDQUFBO0lBSVgsa0RBQWlDLENBQUE7SUFDakM7O09BRUc7SUFDSCw0QkFBVyxDQUFBO0lBSVgsMkNBQTBCLENBQUE7SUFDMUI7O09BRUc7SUFDSCw0QkFBVyxDQUFBO0lBS1gsdURBQXNDLENBQUE7SUFDdEM7OztPQUdHO0lBQ0gsOEJBQWEsQ0FBQTtJQUliLGdDQUFlLENBQUE7SUFDZjs7T0FFRztJQUNILDBCQUFTLENBQUE7SUFJVCx5Q0FBd0IsQ0FBQTtJQUN4Qjs7T0FFRztJQUNILDBCQUFTLENBQUE7SUFJVCwyQkFBVSxDQUFBO0lBQ1Y7O09BRUc7SUFDSCwwQkFBUyxDQUFBO0lBSVQsOENBQTZCLENBQUE7SUFDN0I7O09BRUc7SUFDSCw4QkFBYSxDQUFBO0lBSWIsa0NBQWlCLENBQUE7SUFDakI7O09BRUc7SUFDSCwwQkFBUyxDQUFBO0lBSVQsa0NBQWlCLENBQUE7SUFDakI7O09BRUc7SUFDSCwwQkFBUyxDQUFBO0lBSVQsdUNBQXNCLENBQUE7SUFDdEI7O09BRUc7SUFDSCw0QkFBVyxDQUFBO0lBSVgsMENBQXlCLENBQUE7SUFDekI7O09BRUc7SUFDSCwwQkFBUyxDQUFBO0lBSVQsb0RBQW1DLENBQUE7SUFDbkM7O09BRUc7SUFDSCw0QkFBVyxDQUFBO0lBSVgsNkJBQVksQ0FBQTtJQUNaOztPQUVHO0lBQ0gsMEJBQVMsQ0FBQTtJQUlULGlDQUFnQixDQUFBO0lBQ2hCOztPQUVHO0lBQ0gsMEJBQVMsQ0FBQTtJQUlULCtEQUE4QyxDQUFBO0lBQzlDOztPQUVHO0lBQ0gsOEJBQWEsQ0FBQTtJQUliLGlDQUFnQixDQUFBO0lBQ2hCOztPQUVHO0lBQ0gsMEJBQVMsQ0FBQTtJQUlULGlDQUFnQixDQUFBO0lBQ2hCOztPQUVHO0lBQ0gsMEJBQVMsQ0FBQTtJQUlULDRCQUFXLENBQUE7SUFDWDs7T0FFRztJQUNILDBCQUFTLENBQUE7SUFJVCwyQ0FBMEIsQ0FBQTtJQUMxQjs7T0FFRztJQUNILDRCQUFXLENBQUE7SUFJWCw2Q0FBNEIsQ0FBQTtJQUM1Qjs7T0FFRztJQUNILDRCQUFXLENBQUE7SUFJWCxvQ0FBbUIsQ0FBQTtJQUNuQjs7T0FFRztJQUNILDhCQUFhLENBQUE7QUFDakIsQ0FBQyxFQTNUVyxhQUFhLEdBQWIscUJBQWEsS0FBYixxQkFBYSxRQTJUeEI7Ozs7OztBQUlELElBQVksWUF5RVg7QUF6RUQsV0FBWSxZQUFZO0lBSXBCLDZCQUFhLENBQUE7SUFJYiwrQkFBZSxDQUFBO0lBSWYsK0JBQWUsQ0FBQTtJQUlmLGlDQUFpQixDQUFBO0lBSWpCLCtCQUFlLENBQUE7SUFJZixpQ0FBaUIsQ0FBQTtJQUlqQixtQ0FBbUIsQ0FBQTtJQUluQixtQ0FBbUIsQ0FBQTtJQUluQixtQ0FBbUIsQ0FBQTtJQUluQixtQ0FBbUIsQ0FBQTtJQUluQixtQ0FBbUIsQ0FBQTtJQUluQixxQ0FBcUIsQ0FBQTtJQUlyQixxQ0FBcUIsQ0FBQTtJQUlyQixxQ0FBcUIsQ0FBQTtJQUlyQixxQ0FBcUIsQ0FBQTtJQUlyQixxQ0FBcUIsQ0FBQTtJQUlyQixxQ0FBcUIsQ0FBQTtJQUlyQiwrQkFBZSxDQUFBO0FBQ25CLENBQUMsRUF6RVcsWUFBWSxHQUFaLG9CQUFZLEtBQVosb0JBQVksUUF5RXZCOzs7Ozs7Ozs7QUFPRCxNQUFhLFlBQVk7Ozs7SUFZckIsWUFBNkIsc0JBQThCO1FBQTlCLDJCQUFzQixHQUF0QixzQkFBc0IsQ0FBUTtJQUMzRCxDQUFDOzs7Ozs7Ozs7OztJQUpNLE1BQU0sQ0FBQyxFQUFFLENBQUMsYUFBNEIsRUFBRSxZQUEwQjtRQUNyRSxPQUFPLElBQUksWUFBWSxDQUFDLEdBQUcsYUFBYSxJQUFJLFlBQVksRUFBRSxDQUFDLENBQUM7SUFDaEUsQ0FBQzs7Ozs7O0lBTU0sUUFBUTtRQUNYLE9BQU8sSUFBSSxDQUFDLHNCQUFzQixDQUFDO0lBQ3ZDLENBQUM7Q0FDSjtBQXBCRCxvQ0FvQkMiLCJzb3VyY2VzQ29udGVudCI6WyIgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGVudW0gSW5zdGFuY2VDbGFzcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBTVEFOREFSRDMgPSAnbTMnLFxuICAgIC8qKlxuICAgICAqIFN0YW5kYXJkIGluc3RhbmNlcywgM3JkIGdlbmVyYXRpb25cbiAgICAgKi9cbiAgICBNMyA9ICdtMycsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBTVEFOREFSRDQgPSAnbTQnLFxuICAgIC8qKlxuICAgICAqIFN0YW5kYXJkIGluc3RhbmNlcywgNHRoIGdlbmVyYXRpb25cbiAgICAgKi9cbiAgICBNNCA9ICdtNCcsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBTVEFOREFSRDUgPSAnbTUnLFxuICAgIC8qKlxuICAgICAqIFN0YW5kYXJkIGluc3RhbmNlcywgNXRoIGdlbmVyYXRpb25cbiAgICAgKi9cbiAgICBNNSA9ICdtNScsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgU1RBTkRBUkQ1X05WTUVfRFJJVkUgPSAnbTVkJyxcbiAgICAvKipcbiAgICAgKiBTdGFuZGFyZCBpbnN0YW5jZXMgd2l0aCBsb2NhbCBOVk1FIGRyaXZlLCA1dGggZ2VuZXJhdGlvblxuICAgICAqL1xuICAgIE01RCA9ICdtNWQnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgU1RBTkRBUkQ1X0FNRCA9ICdtNWEnLFxuICAgIC8qKlxuICAgICAqIFN0YW5kYXJkIGluc3RhbmNlcyBiYXNlZCBvbiBBTUQgRVBZQywgNXRoIGdlbmVyYXRpb25cbiAgICAgKi9cbiAgICBNNUEgPSAnbTVhJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBTVEFOREFSRDVfQU1EX05WTUVfRFJJVkUgPSAnbTVhZCcsXG4gICAgLyoqXG4gICAgICogU3RhbmRhcmQgaW5zdGFuY2VzIGJhc2VkIG9uIEFNRCBFUFlDIHdpdGggbG9jYWwgTlZNRSBkcml2ZSwgNXRoIGdlbmVyYXRpb25cbiAgICAgKi9cbiAgICBNNUFEID0gJ201YWQnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBNRU1PUlkzID0gJ3IzJyxcbiAgICAvKipcbiAgICAgKiBNZW1vcnkgb3B0aW1pemVkIGluc3RhbmNlcywgM3JkIGdlbmVyYXRpb25cbiAgICAgKi9cbiAgICBSMyA9ICdyMycsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIE1FTU9SWTQgPSAncjQnLFxuICAgIC8qKlxuICAgICAqIE1lbW9yeSBvcHRpbWl6ZWQgaW5zdGFuY2VzLCA0dGggZ2VuZXJhdGlvblxuICAgICAqL1xuICAgIFI0ID0gJ3I0JyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgTUVNT1JZNSA9ICdyNScsXG4gICAgLyoqXG4gICAgICogTWVtb3J5IG9wdGltaXplZCBpbnN0YW5jZXMsIDV0aCBnZW5lcmF0aW9uXG4gICAgICovXG4gICAgUjUgPSAncjUnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgTUVNT1JZNV9ISUdIX1BFUkZPUk1BTkNFID0gJ3I1bicsXG4gICAgLyoqXG4gICAgICogTWVtb3J5IG9wdGltaXplZCBpbnN0YW5jZXMgZm9yIGhpZ2ggcGVyZm9ybWFuY2UgY29tcHV0aW5nLCA1dGggZ2VuZXJhdGlvblxuICAgICAqL1xuICAgIFI1TiA9ICdyNW4nLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgTUVNT1JZNV9OVk1FX0RSSVZFID0gJ3I1ZCcsXG4gICAgLyoqXG4gICAgICogTWVtb3J5IG9wdGltaXplZCBpbnN0YW5jZXMgd2l0aCBsb2NhbCBOVk1FIGRyaXZlLCA1dGggZ2VuZXJhdGlvblxuICAgICAqL1xuICAgIFI1RCA9ICdyNWQnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIE1FTU9SWTVfTlZNRV9EUklWRV9ISUdIX1BFUkZPUk1BTkNFID0gJ3I1ZG4nLFxuICAgIC8qKlxuICAgICAqIE1lbW9yeSBvcHRpbWl6ZWQgaW5zdGFuY2VzIHdpdGggbG9jYWwgTlZNRSBkcml2ZSBmb3IgaGlnaCBwZXJmb3JtYW5jZSBjb21wdXRpbmcsIDV0aCBnZW5lcmF0aW9uXG4gICAgICovXG4gICAgUjVETiA9ICdyNWRuJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgTUVNT1JZNV9BTUQgPSAncjVhJyxcbiAgICAvKipcbiAgICAgKiBNZW1vcnkgb3B0aW1pemVkIGluc3RhbmNlcyBiYXNlZCBvbiBBTUQgRVBZQywgNXRoIGdlbmVyYXRpb25cbiAgICAgKi9cbiAgICBSNUEgPSAncjVhJyxcbiAgICAvKipcbiAgICAgKiBNZW1vcnkgb3B0aW1pemVkIGluc3RhbmNlcyBiYXNlZCBvbiBBTUQgRVBZQyB3aXRoIGxvY2FsIE5WTUUgZHJpdmUsIDV0aCBnZW5lcmF0aW9uXG4gICAgICovXG4gICAgTUVNT1JZNV9BTURfTlZNRV9EUklWRSA9ICdyNWEnLFxuICAgIC8qKlxuICAgICAqIE1lbW9yeSBvcHRpbWl6ZWQgaW5zdGFuY2VzIGJhc2VkIG9uIEFNRCBFUFlDIHdpdGggbG9jYWwgTlZNRSBkcml2ZSwgNXRoIGdlbmVyYXRpb25cbiAgICAgKi9cbiAgICBSNUFEID0gJ3I1YScsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBDT01QVVRFMyA9ICdjMycsXG4gICAgLyoqXG4gICAgICogQ29tcHV0ZSBvcHRpbWl6ZWQgaW5zdGFuY2VzLCAzcmQgZ2VuZXJhdGlvblxuICAgICAqL1xuICAgIEMzID0gJ2MzJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIENPTVBVVEU0ID0gJ2M0JyxcbiAgICAvKipcbiAgICAgKiBDb21wdXRlIG9wdGltaXplZCBpbnN0YW5jZXMsIDR0aCBnZW5lcmF0aW9uXG4gICAgICovXG4gICAgQzQgPSAnYzQnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgQ09NUFVURTUgPSAnYzUnLFxuICAgIC8qKlxuICAgICAqIENvbXB1dGUgb3B0aW1pemVkIGluc3RhbmNlcywgNXRoIGdlbmVyYXRpb25cbiAgICAgKi9cbiAgICBDNSA9ICdjNScsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgQ09NUFVURTVfTlZNRV9EUklWRSA9ICdjNWQnLFxuICAgIC8qKlxuICAgICAqIENvbXB1dGUgb3B0aW1pemVkIGluc3RhbmNlcyB3aXRoIGxvY2FsIE5WTUUgZHJpdmUsIDV0aCBnZW5lcmF0aW9uXG4gICAgICovXG4gICAgQzVEID0gJ2M1ZCcsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgQ09NUFVURTVfSElHSF9QRVJGT1JNQU5DRSA9ICdjNW4nLFxuICAgIC8qKlxuICAgICAqIENvbXB1dGUgb3B0aW1pemVkIGluc3RhbmNlcyBmb3IgaGlnaCBwZXJmb3JtYW5jZSBjb21wdXRpbmcsIDV0aCBnZW5lcmF0aW9uXG4gICAgICovXG4gICAgQzVOID0gJ2M1bicsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBDT01QVVRFNl9HUkFWSVRPTjIgPSAnYzZnJyxcbiAgICAvKipcbiAgICAgKiBDb21wdXRlIG9wdGltaXplZCBpbnN0YW5jZXMgZm9yIGhpZ2ggcGVyZm9ybWFuY2UgY29tcHV0aW5nLCA2dGggZ2VuZXJhdGlvbiB3aXRoIEdyYXZpdG9uMiBwcm9jZXNzb3JzXG4gICAgICovXG4gICAgQzZHID0gJ2M2ZycsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgQ09NUFVURTZfR1JBVklUT04yX05WTUVfRFJJVkUgPSAnYzZnZCcsXG4gICAgLyoqXG4gICAgICogQ29tcHV0ZSBvcHRpbWl6ZWQgaW5zdGFuY2VzIGZvciBoaWdoIHBlcmZvcm1hbmNlIGNvbXB1dGluZywgNnRoIGdlbmVyYXRpb24gd2l0aCBHcmF2aXRvbjIgcHJvY2Vzc29yc1xuICAgICAqIGFuZCBsb2NhbCBOVk1FIGRyaXZlXG4gICAgICovXG4gICAgQzZHRCA9ICdjNmdkJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIFNUT1JBR0UyID0gJ2QyJyxcbiAgICAvKipcbiAgICAgKiBTdG9yYWdlLW9wdGltaXplZCBpbnN0YW5jZXMsIDJuZCBnZW5lcmF0aW9uXG4gICAgICovXG4gICAgRDIgPSAnZDInLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIFNUT1JBR0VfQ09NUFVURV8xID0gJ2gxJyxcbiAgICAvKipcbiAgICAgKiBTdG9yYWdlL2NvbXB1dGUgYmFsYW5jZWQgaW5zdGFuY2VzLCAxc3QgZ2VuZXJhdGlvblxuICAgICAqL1xuICAgIEgxID0gJ2gxJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgSU8zID0gJ2kzJyxcbiAgICAvKipcbiAgICAgKiBJL08tb3B0aW1pemVkIGluc3RhbmNlcywgM3JkIGdlbmVyYXRpb25cbiAgICAgKi9cbiAgICBJMyA9ICdpMycsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBJTzNfREVOU0VfTlZNRV9EUklWRSA9ICdpM2VuJyxcbiAgICAvKipcbiAgICAgKiBJL08tb3B0aW1pemVkIGluc3RhbmNlcyB3aXRoIGxvY2FsIE5WTUUgZHJpdmUsIDNyZCBnZW5lcmF0aW9uXG4gICAgICovXG4gICAgSTNFTiA9ICdpM2VuJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBCVVJTVEFCTEUyID0gJ3QyJyxcbiAgICAvKipcbiAgICAgKiBCdXJzdGFibGUgaW5zdGFuY2VzLCAybmQgZ2VuZXJhdGlvblxuICAgICAqL1xuICAgIFQyID0gJ3QyJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBCVVJTVEFCTEUzID0gJ3QzJyxcbiAgICAvKipcbiAgICAgKiBCdXJzdGFibGUgaW5zdGFuY2VzLCAzcmQgZ2VuZXJhdGlvblxuICAgICAqL1xuICAgIFQzID0gJ3QzJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBCVVJTVEFCTEUzX0FNRCA9ICd0M2EnLFxuICAgIC8qKlxuICAgICAqIEJ1cnN0YWJsZSBpbnN0YW5jZXMgYmFzZWQgb24gQU1EIEVQWUMsIDNyZCBnZW5lcmF0aW9uXG4gICAgICovXG4gICAgVDNBID0gJ3QzYScsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIE1FTU9SWV9JTlRFTlNJVkVfMSA9ICd4MScsXG4gICAgLyoqXG4gICAgICogTWVtb3J5LWludGVuc2l2ZSBpbnN0YW5jZXMsIDFzdCBnZW5lcmF0aW9uXG4gICAgICovXG4gICAgWDEgPSAneDEnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgTUVNT1JZX0lOVEVOU0lWRV8xX0VYVEVOREVEID0gJ3gxZScsXG4gICAgLyoqXG4gICAgICogTWVtb3J5LWludGVuc2l2ZSBpbnN0YW5jZXMsIDFzdCBnZW5lcmF0aW9uXG4gICAgICovXG4gICAgWDFFID0gJ3gxZScsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgRlBHQTEgPSAnZjEnLFxuICAgIC8qKlxuICAgICAqIEluc3RhbmNlcyB3aXRoIGN1c3RvbWl6YWJsZSBoYXJkd2FyZSBhY2NlbGVyYXRpb24sIDFzdCBnZW5lcmF0aW9uXG4gICAgICovXG4gICAgRjEgPSAnZjEnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIEdSQVBISUNTMyA9ICdnMycsXG4gICAgLyoqXG4gICAgICogR3JhcGhpY3Mtb3B0aW1pemVkIGluc3RhbmNlcywgM3JkIGdlbmVyYXRpb25cbiAgICAgKi9cbiAgICBHMyA9ICdnMycsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBHUkFQSElDUzRfTlZNRV9EUklWRV9ISUdIX1BFUkZPUk1BTkNFID0gJ2c0ZG4nLFxuICAgIC8qKlxuICAgICAqIEdyYXBoaWNzLW9wdGltaXplZCBpbnN0YW5jZXMgd2l0aCBOVk1FIGRyaXZlIGZvciBoaWdoIHBlcmZvcm1hbmNlIGNvbXB1dGluZywgNHRoIGdlbmVyYXRpb25cbiAgICAgKi9cbiAgICBHNEROID0gJ2c0ZG4nLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgUEFSQUxMRUwyID0gJ3AyJyxcbiAgICAvKipcbiAgICAgKiBQYXJhbGxlbC1wcm9jZXNzaW5nIG9wdGltaXplZCBpbnN0YW5jZXMsIDJuZCBnZW5lcmF0aW9uXG4gICAgICovXG4gICAgUDIgPSAncDInLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgUEFSQUxMRUwzID0gJ3AzJyxcbiAgICAvKipcbiAgICAgKiBQYXJhbGxlbC1wcm9jZXNzaW5nIG9wdGltaXplZCBpbnN0YW5jZXMsIDNuZCBnZW5lcmF0aW9uXG4gICAgICovXG4gICAgUDMgPSAncDMnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBBUk0xID0gJ2ExJyxcbiAgICAvKipcbiAgICAgKiBBcm0gcHJvY2Vzc29yIGJhc2VkIGluc3RhbmNlcywgMXN0IGdlbmVyYXRpb25cbiAgICAgKi9cbiAgICBBMSA9ICdhMScsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIFNUQU5EQVJENl9HUkFWSVRPTiA9ICdtNmcnLFxuICAgIC8qKlxuICAgICAqIEFybSBwcm9jZXNzb3IgYmFzZWQgaW5zdGFuY2VzLCAybmQgZ2VuZXJhdGlvblxuICAgICAqL1xuICAgIE02RyA9ICdtNmcnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgSElHSF9DT01QVVRFX01FTU9SWTEgPSAnejFkJyxcbiAgICAvKipcbiAgICAgKiBIaWdoIG1lbW9yeSBhbmQgY29tcHV0ZSBjYXBhY2l0eSBpbnN0YW5jZXMsIDFzdCBnZW5lcmF0aW9uXG4gICAgICovXG4gICAgWjFEID0gJ3oxZCcsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgSU5GRVJFTkNFMSA9ICdpbmYxJyxcbiAgICAvKipcbiAgICAgKiBJbmZlcmVudGlhIENoaXBzIGJhc2VkIGluc3RhbmNlcyBmb3IgbWFjaGluZSBsZWFybmluZyBpbmZlcmVuY2UgYXBwbGljYXRpb25zLCAxc3QgZ2VuZXJhdGlvblxuICAgICAqL1xuICAgIElORjEgPSAnaW5mMSdcbn1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGVudW0gSW5zdGFuY2VTaXplIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIE5BTk8gPSAnbmFubycsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIE1JQ1JPID0gJ21pY3JvJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgU01BTEwgPSAnc21hbGwnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIE1FRElVTSA9ICdtZWRpdW0nLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBMQVJHRSA9ICdsYXJnZScsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgWExBUkdFID0gJ3hsYXJnZScsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBYTEFSR0UyID0gJzJ4bGFyZ2UnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgWExBUkdFNCA9ICc0eGxhcmdlJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIFhMQVJHRTYgPSAnNnhsYXJnZScsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBYTEFSR0U4ID0gJzh4bGFyZ2UnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgWExBUkdFOSA9ICc5eGxhcmdlJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgWExBUkdFMTAgPSAnMTB4bGFyZ2UnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBYTEFSR0UxMiA9ICcxMnhsYXJnZScsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIFhMQVJHRTE2ID0gJzE2eGxhcmdlJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgWExBUkdFMTggPSAnMTh4bGFyZ2UnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBYTEFSR0UyNCA9ICcyNHhsYXJnZScsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIFhMQVJHRTMyID0gJzMyeGxhcmdlJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgTUVUQUwgPSAnbWV0YWwnXG59XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgSW5zdGFuY2VUeXBlIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIG9mKGluc3RhbmNlQ2xhc3M6IEluc3RhbmNlQ2xhc3MsIGluc3RhbmNlU2l6ZTogSW5zdGFuY2VTaXplKSB7XG4gICAgICAgIHJldHVybiBuZXcgSW5zdGFuY2VUeXBlKGAke2luc3RhbmNlQ2xhc3N9LiR7aW5zdGFuY2VTaXplfWApO1xuICAgIH1cbiAgICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IGluc3RhbmNlVHlwZUlkZW50aWZpZXI6IHN0cmluZykge1xuICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyB0b1N0cmluZygpOiBzdHJpbmcge1xuICAgICAgICByZXR1cm4gdGhpcy5pbnN0YW5jZVR5cGVJZGVudGlmaWVyO1xuICAgIH1cbn1cbiJdfQ==