import * as cloudwatch from "../../aws-cloudwatch";
declare module "./vpn" {
    /**
     * @experimental
     */
    interface IVpnConnection {
        /**
         * (experimental) Return the given named metric for this VPNConnection.
         *
         * @experimental
         */
        metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The state of the tunnel. 0 indicates DOWN and 1 indicates UP.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricTunnelState(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The bytes received through the VPN tunnel.
         *
         * Sum over 5 minutes
         *
         * @experimental
         */
        metricTunnelDataIn(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The bytes sent through the VPN tunnel.
         *
         * Sum over 5 minutes
         *
         * @experimental
         */
        metricTunnelDataOut(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    }
    /**
     * (experimental) Define a VPN Connection.
     *
     * @experimental
     * @resource AWS::EC2::VPNConnection
     */
    interface VpnConnection {
        /**
         * (experimental) Return the given named metric for this VPNConnection.
         *
         * @experimental
         */
        metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The state of the tunnel. 0 indicates DOWN and 1 indicates UP.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricTunnelState(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The bytes received through the VPN tunnel.
         *
         * Sum over 5 minutes
         *
         * @experimental
         */
        metricTunnelDataIn(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The bytes sent through the VPN tunnel.
         *
         * Sum over 5 minutes
         *
         * @experimental
         */
        metricTunnelDataOut(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    }
}
