import { InitElement } from './cfn-init-elements';
/**
 * (experimental) A CloudFormation-init configuration.
 *
 * @experimental
 */
export declare class CloudFormationInit {
    /**
     * (experimental) Build a new config from a set of Init Elements.
     *
     * @experimental
     */
    static fromElements(...elements: InitElement[]): CloudFormationInit;
    /**
     * (experimental) Use an existing InitConfig object as the default and only config.
     *
     * @experimental
     */
    static fromConfig(config: InitConfig): CloudFormationInit;
    /**
     * (experimental) Build a CloudFormationInit from config sets.
     *
     * @experimental
     */
    static fromConfigSets(props: ConfigSetProps): CloudFormationInit;
    private readonly _configSets;
    private readonly _configs;
    private constructor();
    /**
     * (experimental) Add a config with the given name to this CloudFormationInit object.
     *
     * @experimental
     */
    addConfig(configName: string, config: InitConfig): void;
    /**
     * (experimental) Add a config set with the given name to this CloudFormationInit object.
     *
     * The new configset will reference the given configs in the given order.
     *
     * @experimental
     */
    addConfigSet(configSetName: string, configNames?: string[]): void;
    private bind;
}
/**
 * (experimental) A collection of configuration elements.
 *
 * @experimental
 */
export declare class InitConfig {
    private readonly elements;
    /**
     * @experimental
     */
    constructor(elements: InitElement[]);
    /**
     * (experimental) Whether this configset has elements or not.
     *
     * @experimental
     */
    isEmpty(): boolean;
    /**
     * (experimental) Add one or more elements to the config.
     *
     * @experimental
     */
    add(...elements: InitElement[]): void;
    private bindForType;
    private initPlatformFromOSType;
}
/**
 * (experimental) Options for CloudFormationInit.withConfigSets.
 *
 * @experimental
 */
export interface ConfigSetProps {
    /**
     * (experimental) The definitions of each config set.
     *
     * @experimental
     */
    readonly configSets: Record<string, string[]>;
    /**
     * (experimental) The sets of configs to pick from.
     *
     * @experimental
     */
    readonly configs: Record<string, InitConfig>;
}
