import * as appscaling from "../../aws-applicationautoscaling";
/**
 * (experimental) Interface for scalable attributes.
 *
 * @experimental
 */
export interface IScalableTableAttribute {
    /**
     * (experimental) Add scheduled scaling for this scaling attribute.
     *
     * @experimental
     */
    scaleOnSchedule(id: string, actions: appscaling.ScalingSchedule): void;
    /**
     * (experimental) Scale out or in to keep utilization at a given level.
     *
     * @experimental
     */
    scaleOnUtilization(props: UtilizationScalingProps): void;
}
/**
 * (experimental) Properties for enabling DynamoDB capacity scaling.
 *
 * @experimental
 */
export interface EnableScalingProps {
    /**
     * (experimental) Minimum capacity to scale to.
     *
     * @experimental
     */
    readonly minCapacity: number;
    /**
     * (experimental) Maximum capacity to scale to.
     *
     * @experimental
     */
    readonly maxCapacity: number;
}
/**
 * (experimental) Properties for enabling DynamoDB utilization tracking.
 *
 * @experimental
 */
export interface UtilizationScalingProps extends appscaling.BaseTargetTrackingProps {
    /**
     * (experimental) Target utilization percentage for the attribute.
     *
     * @experimental
     */
    readonly targetUtilizationPercent: number;
}
