import * as ec2 from "../../aws-ec2";
import * as kms from "../../aws-kms";
import * as secretsmanager from "../../aws-secretsmanager";
import { Duration, SecretValue } from "../../core";
import { IClusterParameterGroup } from './parameter-group';
/**
 * (experimental) Backup configuration for DocumentDB databases.
 *
 * @default - The retention period for automated backups is 1 day.
 * The preferred backup window will be a 30-minute window selected at random
 * from an 8-hour block of time for each AWS Region.
 * @see https://docs.aws.amazon.com/documentdb/latest/developerguide/backup-restore.db-cluster-snapshots.html#backup-restore.backup-window
 * @experimental
 */
export interface BackupProps {
    /**
     * (experimental) How many days to retain the backup.
     *
     * @experimental
     */
    readonly retention: Duration;
    /**
     * (experimental) A daily time range in 24-hours UTC format in which backups preferably execute.
     *
     * Must be at least 30 minutes long.
     *
     * Example: '01:00-02:00'
     *
     * @default - a 30-minute window selected at random from an 8-hour block of
     * time for each AWS Region. To see the time blocks available, see
     * https://docs.aws.amazon.com/documentdb/latest/developerguide/backup-restore.db-cluster-snapshots.html#backup-restore.backup-window
     * @experimental
     */
    readonly preferredWindow?: string;
}
/**
 * (experimental) Login credentials for a database cluster.
 *
 * @experimental
 */
export interface Login {
    /**
     * (experimental) Username.
     *
     * @experimental
     */
    readonly username: string;
    /**
     * (experimental) Password.
     *
     * Do not put passwords in your CDK code directly.
     *
     * @default a Secrets Manager generated password
     * @experimental
     */
    readonly password?: SecretValue;
    /**
     * (experimental) KMS encryption key to encrypt the generated secret.
     *
     * @default default master key
     * @experimental
     */
    readonly kmsKey?: kms.IKey;
}
/**
 * (experimental) Instance properties for database instances.
 *
 * @experimental
 */
export interface InstanceProps {
    /**
     * (experimental) What type of instance to start for the replicas.
     *
     * @experimental
     */
    readonly instanceType: ec2.InstanceType;
    /**
     * (experimental) What subnets to run the DocumentDB instances in.
     *
     * Must be at least 2 subnets in two different AZs.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * (experimental) Where to place the instances within the VPC.
     *
     * @default private subnets
     * @experimental
     */
    readonly vpcSubnets?: ec2.SubnetSelection;
    /**
     * (experimental) Security group.
     *
     * @default a new security group is created.
     * @experimental
     */
    readonly securityGroup?: ec2.ISecurityGroup;
    /**
     * (experimental) The DB parameter group to associate with the instance.
     *
     * @default no parameter group
     * @experimental
     */
    readonly parameterGroup?: IClusterParameterGroup;
}
/**
 * (experimental) Options to add the multi user rotation.
 *
 * @experimental
 */
export interface RotationMultiUserOptions {
    /**
     * (experimental) The secret to rotate.
     *
     * It must be a JSON string with the following format:
     * ```
     * {
     *    "engine": <required: must be set to 'mongo'>,
     *    "host": <required: instance host name>,
     *    "username": <required: username>,
     *    "password": <required: password>,
     *    "dbname": <optional: database name>,
     *    "port": <optional: if not specified, default port 27017 will be used>,
     *    "masterarn": <required: the arn of the master secret which will be used to create users/change passwords>
     *    "ssl": <optional: if not specified, defaults to false. This must be true if being used for DocumentDB rotations
     *           where the cluster has TLS enabled>
     * }
     * ```
     *
     * @experimental
     */
    readonly secret: secretsmanager.ISecret;
    /**
     * (experimental) Specifies the number of days after the previous rotation before Secrets Manager triggers the next automatic rotation.
     *
     * @default Duration.days(30)
     * @experimental
     */
    readonly automaticallyAfter?: Duration;
}
