import * as events from "../../aws-events";
import * as lambda from "../../aws-lambda";
import { IResource, Resource } from "../../core";
import { Construct } from 'constructs';
import { CfnConfigRule } from './config.generated';
/**
 * (experimental) A config rule.
 *
 * @experimental
 */
export interface IRule extends IResource {
    /**
     * (experimental) The name of the rule.
     *
     * @experimental
     * @attribute true
     */
    readonly configRuleName: string;
    /**
     * (experimental) Defines a CloudWatch event rule which triggers for rule events.
     *
     * Use
     * `rule.addEventPattern(pattern)` to specify a filter.
     *
     * @experimental
     */
    onEvent(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines a CloudWatch event rule which triggers for rule compliance events.
     *
     * @experimental
     */
    onComplianceChange(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines a CloudWatch event rule which triggers for rule re-evaluation status events.
     *
     * @experimental
     */
    onReEvaluationStatus(id: string, options?: events.OnEventOptions): events.Rule;
}
/**
 * A new or imported rule.
 */
declare abstract class RuleBase extends Resource implements IRule {
    abstract readonly configRuleName: string;
    /**
     * (experimental) Defines a CloudWatch event rule which triggers for rule events.
     *
     * Use
     * `rule.addEventPattern(pattern)` to specify a filter.
     *
     * @experimental
     */
    onEvent(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines a CloudWatch event rule which triggers for rule compliance events.
     *
     * @experimental
     */
    onComplianceChange(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines a CloudWatch event rule which triggers for rule re-evaluation status events.
     *
     * @experimental
     */
    onReEvaluationStatus(id: string, options?: events.OnEventOptions): events.Rule;
}
/**
 * A new managed or custom rule.
 */
declare abstract class RuleNew extends RuleBase {
    /**
     * (experimental) Imports an existing rule.
     *
     * @param configRuleName the name of the rule.
     * @experimental
     */
    static fromConfigRuleName(scope: Construct, id: string, configRuleName: string): IRule;
    /**
     * The arn of the rule.
     */
    abstract readonly configRuleArn: string;
    /**
     * The id of the rule.
     */
    abstract readonly configRuleId: string;
    /**
     * The compliance status of the rule.
     */
    abstract readonly configRuleComplianceType: string;
    /**
     * @experimental
     */
    protected scope?: CfnConfigRule.ScopeProperty;
    /**
     * @experimental
     */
    protected isManaged?: boolean;
    /**
     * @experimental
     */
    protected isCustomWithChanges?: boolean;
    /**
     * (experimental) Restrict scope of changes to a specific resource.
     *
     * @param type the resource type.
     * @param identifier the resource identifier.
     * @see https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources
     * @experimental
     */
    scopeToResource(type: string, identifier?: string): void;
    /**
     * (experimental) Restrict scope of changes to specific resource types.
     *
     * @param types resource types.
     * @see https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources
     * @experimental
     */
    scopeToResources(...types: string[]): void;
    /**
     * (experimental) Restrict scope of changes to a specific tag.
     *
     * @param key the tag key.
     * @param value the tag value.
     * @experimental
     */
    scopeToTag(key: string, value?: string): void;
}
/**
 * (experimental) The maximum frequency at which the AWS Config rule runs evaluations.
 *
 * @experimental
 */
export declare enum MaximumExecutionFrequency {
    /**
     * (experimental) 1 hour.
     *
     * @experimental
     */
    ONE_HOUR = "One_Hour",
    /**
     * (experimental) 3 hours.
     *
     * @experimental
     */
    THREE_HOURS = "Three_Hours",
    /**
     * (experimental) 6 hours.
     *
     * @experimental
     */
    SIX_HOURS = "Six_Hours",
    /**
     * (experimental) 12 hours.
     *
     * @experimental
     */
    TWELVE_HOURS = "Twelve_Hours",
    /**
     * (experimental) 24 hours.
     *
     * @experimental
     */
    TWENTY_FOUR_HOURS = "TwentyFour_Hours"
}
/**
 * (experimental) Construction properties for a new rule.
 *
 * @experimental
 */
export interface RuleProps {
    /**
     * (experimental) A name for the AWS Config rule.
     *
     * @default - CloudFormation generated name
     * @experimental
     */
    readonly configRuleName?: string;
    /**
     * (experimental) A description about this AWS Config rule.
     *
     * @default - No description
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) Input parameter values that are passed to the AWS Config rule.
     *
     * @default - No input parameters
     * @experimental
     */
    readonly inputParameters?: {
        [key: string]: any;
    };
    /**
     * (experimental) The maximum frequency at which the AWS Config rule runs evaluations.
     *
     * @default MaximumExecutionFrequency.TWENTY_FOUR_HOURS
     * @experimental
     */
    readonly maximumExecutionFrequency?: MaximumExecutionFrequency;
}
/**
 * (experimental) Construction properties for a ManagedRule.
 *
 * @experimental
 */
export interface ManagedRuleProps extends RuleProps {
    /**
     * (experimental) The identifier of the AWS managed rule.
     *
     * @see https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html
     * @experimental
     */
    readonly identifier: string;
}
/**
 * (experimental) A new managed rule.
 *
 * @experimental
 * @resource AWS::Config::ConfigRule
 */
export declare class ManagedRule extends RuleNew {
    /**
     * (experimental) The name of the rule.
     *
     * @experimental
     * @attribute true
     */
    readonly configRuleName: string;
    /**
     * (experimental) The arn of the rule.
     *
     * @experimental
     * @attribute true
     */
    readonly configRuleArn: string;
    /**
     * (experimental) The id of the rule.
     *
     * @experimental
     * @attribute true
     */
    readonly configRuleId: string;
    /**
     * (experimental) The compliance status of the rule.
     *
     * @experimental
     * @attribute true
     */
    readonly configRuleComplianceType: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ManagedRuleProps);
}
/**
 * (experimental) Construction properties for a CustomRule.
 *
 * @experimental
 */
export interface CustomRuleProps extends RuleProps {
    /**
     * (experimental) The Lambda function to run.
     *
     * @experimental
     */
    readonly lambdaFunction: lambda.IFunction;
    /**
     * (experimental) Whether to run the rule on configuration changes.
     *
     * @default false
     * @experimental
     */
    readonly configurationChanges?: boolean;
    /**
     * (experimental) Whether to run the rule on a fixed frequency.
     *
     * @default false
     * @experimental
     */
    readonly periodic?: boolean;
}
/**
 * (experimental) A new custom rule.
 *
 * @experimental
 * @resource AWS::Config::ConfigRule
 */
export declare class CustomRule extends RuleNew {
    /**
     * (experimental) The name of the rule.
     *
     * @experimental
     * @attribute true
     */
    readonly configRuleName: string;
    /**
     * (experimental) The arn of the rule.
     *
     * @experimental
     * @attribute true
     */
    readonly configRuleArn: string;
    /**
     * (experimental) The id of the rule.
     *
     * @experimental
     * @attribute true
     */
    readonly configRuleId: string;
    /**
     * (experimental) The compliance status of the rule.
     *
     * @experimental
     * @attribute true
     */
    readonly configRuleComplianceType: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: CustomRuleProps);
}
export {};
