import { Construct } from 'constructs';
import { UserPoolIdentityProviderBase, UserPoolIdentityProviderProps } from './base';
/**
 * (experimental) Properties to initialize UserPoolFacebookIdentityProvider.
 *
 * @experimental
 */
export interface UserPoolIdentityProviderFacebookProps extends UserPoolIdentityProviderProps {
    /**
     * (experimental) The client id recognized by Facebook APIs.
     *
     * @experimental
     */
    readonly clientId: string;
    /**
     * (experimental) The client secret to be accompanied with clientUd for Facebook to authenticate the client.
     *
     * @see https://developers.facebook.com/docs/facebook-login/security#appsecret
     * @experimental
     */
    readonly clientSecret: string;
    /**
     * (experimental) The list of facebook permissions to obtain for getting access to the Facebook profile.
     *
     * @default [ public_profile ]
     * @see https://developers.facebook.com/docs/facebook-login/permissions
     * @experimental
     */
    readonly scopes?: string[];
    /**
     * (experimental) The Facebook API version to use.
     *
     * @default - to the oldest version supported by Facebook
     * @experimental
     */
    readonly apiVersion?: string;
}
/**
 * (experimental) Represents a identity provider that integrates with 'Facebook Login'.
 *
 * @experimental
 * @resource AWS::Cognito::UserPoolIdentityProvider
 */
export declare class UserPoolIdentityProviderFacebook extends UserPoolIdentityProviderBase {
    /**
     * (experimental) The primary identifier of this identity provider.
     *
     * @experimental
     */
    readonly providerName: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: UserPoolIdentityProviderFacebookProps);
}
