"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolIdentityProviderBase = exports.ProviderAttribute = void 0;
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const attr_names_1 = require("../private/attr-names");
/**
 * (experimental) An attribute available from a third party identity provider.
 *
 * @experimental
 */
class ProviderAttribute {
    constructor(attributeName) {
        this.attributeName = attributeName;
    }
    /**
     * (experimental) Use this to specify an attribute from the identity provider that is not pre-defined in the CDK.
     *
     * @param attributeName the attribute value string as recognized by the provider.
     * @experimental
     */
    static other(attributeName) {
        return new ProviderAttribute(attributeName);
    }
}
exports.ProviderAttribute = ProviderAttribute;
/**
 * (experimental) The user id attribute provided by Amazon.
 *
 * @experimental
 */
ProviderAttribute.AMAZON_USER_ID = new ProviderAttribute('user_id');
/**
 * (experimental) The email attribute provided by Amazon.
 *
 * @experimental
 */
ProviderAttribute.AMAZON_EMAIL = new ProviderAttribute('email');
/**
 * (experimental) The name attribute provided by Amazon.
 *
 * @experimental
 */
ProviderAttribute.AMAZON_NAME = new ProviderAttribute('name');
/**
 * (experimental) The postal code attribute provided by Amazon.
 *
 * @experimental
 */
ProviderAttribute.AMAZON_POSTAL_CODE = new ProviderAttribute('postal_code');
/**
 * (experimental) The user id attribute provided by Facebook.
 *
 * @experimental
 */
ProviderAttribute.FACEBOOK_ID = new ProviderAttribute('id');
/**
 * (experimental) The birthday attribute provided by Facebook.
 *
 * @experimental
 */
ProviderAttribute.FACEBOOK_BIRTHDAY = new ProviderAttribute('birthday');
/**
 * (experimental) The email attribute provided by Facebook.
 *
 * @experimental
 */
ProviderAttribute.FACEBOOK_EMAIL = new ProviderAttribute('email');
/**
 * (experimental) The name attribute provided by Facebook.
 *
 * @experimental
 */
ProviderAttribute.FACEBOOK_NAME = new ProviderAttribute('name');
/**
 * (experimental) The first name attribute provided by Facebook.
 *
 * @experimental
 */
ProviderAttribute.FACEBOOK_FIRST_NAME = new ProviderAttribute('first_name');
/**
 * (experimental) The last name attribute provided by Facebook.
 *
 * @experimental
 */
ProviderAttribute.FACEBOOK_LAST_NAME = new ProviderAttribute('last_name');
/**
 * (experimental) The middle name attribute provided by Facebook.
 *
 * @experimental
 */
ProviderAttribute.FACEBOOK_MIDDLE_NAME = new ProviderAttribute('middle_name');
/**
 * (experimental) The gender attribute provided by Facebook.
 *
 * @experimental
 */
ProviderAttribute.FACEBOOK_GENDER = new ProviderAttribute('gender');
/**
 * (experimental) The locale attribute provided by Facebook.
 *
 * @experimental
 */
ProviderAttribute.FACEBOOK_LOCALE = new ProviderAttribute('locale');
/**
 * (experimental) Options to integrate with the various social identity providers.
 *
 * @experimental
 */
class UserPoolIdentityProviderBase extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        props.userPool.registerIdentityProvider(this);
    }
    /**
     * @experimental
     */
    configureAttributeMapping() {
        if (!this.props.attributeMapping) {
            return undefined;
        }
        let mapping = {};
        mapping = Object.entries(this.props.attributeMapping)
            .filter(([k, _]) => k !== 'custom') // 'custom' handled later separately
            .reduce((agg, [k, v]) => {
            return { ...agg, [attr_names_1.StandardAttributeNames[k]]: v.attributeName };
        }, mapping);
        if (this.props.attributeMapping.custom) {
            mapping = Object.entries(this.props.attributeMapping.custom).reduce((agg, [k, v]) => {
                return { ...agg, [k]: v.attributeName };
            }, mapping);
        }
        if (Object.keys(mapping).length === 0) {
            return undefined;
        }
        return mapping;
    }
}
exports.UserPoolIdentityProviderBase = UserPoolIdentityProviderBase;
//# sourceMappingURL=data:application/json;base64,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