import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::CodeStarConnections::Connection`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestarconnections-connection.html
 * @external
 */
export interface CfnConnectionProps {
    /**
     * `AWS::CodeStarConnections::Connection.ConnectionName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestarconnections-connection.html#cfn-codestarconnections-connection-connectionname
     * @external
     */
    readonly connectionName: string;
    /**
     * `AWS::CodeStarConnections::Connection.HostArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestarconnections-connection.html#cfn-codestarconnections-connection-hostarn
     * @external
     */
    readonly hostArn?: string;
    /**
     * `AWS::CodeStarConnections::Connection.ProviderType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestarconnections-connection.html#cfn-codestarconnections-connection-providertype
     * @external
     */
    readonly providerType?: string;
    /**
     * `AWS::CodeStarConnections::Connection.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestarconnections-connection.html#cfn-codestarconnections-connection-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::CodeStarConnections::Connection`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestarconnections-connection.html
 * @external
 * @cloudformationResource AWS::CodeStarConnections::Connection
 */
export declare class CfnConnection extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CodeStarConnections::Connection";
    /**
     * @external
     * @cloudformationAttribute ConnectionArn
     */
    readonly attrConnectionArn: string;
    /**
     * @external
     * @cloudformationAttribute ConnectionStatus
     */
    readonly attrConnectionStatus: string;
    /**
     * @external
     * @cloudformationAttribute OwnerAccountId
     */
    readonly attrOwnerAccountId: string;
    /**
     * `AWS::CodeStarConnections::Connection.ConnectionName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestarconnections-connection.html#cfn-codestarconnections-connection-connectionname
     * @external
     */
    connectionName: string;
    /**
     * `AWS::CodeStarConnections::Connection.HostArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestarconnections-connection.html#cfn-codestarconnections-connection-hostarn
     * @external
     */
    hostArn: string | undefined;
    /**
     * `AWS::CodeStarConnections::Connection.ProviderType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestarconnections-connection.html#cfn-codestarconnections-connection-providertype
     * @external
     */
    providerType: string | undefined;
    /**
     * `AWS::CodeStarConnections::Connection.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestarconnections-connection.html#cfn-codestarconnections-connection-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::CodeStarConnections::Connection`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnConnectionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
