import * as events from "../../aws-events";
import * as iam from "../../aws-iam";
import * as s3 from "../../aws-s3";
import { Resource, Stack } from "../../core";
import { Construct } from 'constructs';
import { IAction, IPipeline, IStage } from './action';
/**
 * (experimental) Allows you to control where to place a new Stage when it's added to the Pipeline.
 *
 * Note that you can provide only one of the below properties -
 * specifying more than one will result in a validation error.
 *
 * @see #justAfter
 * @experimental
 */
export interface StagePlacement {
    /**
     * (experimental) Inserts the new Stage as a parent of the given Stage (changing its current parent Stage, if it had one).
     *
     * @experimental
     */
    readonly rightBefore?: IStage;
    /**
     * (experimental) Inserts the new Stage as a child of the given Stage (changing its current child Stage, if it had one).
     *
     * @experimental
     */
    readonly justAfter?: IStage;
}
/**
 * (experimental) Construction properties of a Pipeline Stage.
 *
 * @experimental
 */
export interface StageProps {
    /**
     * (experimental) The physical, human-readable name to assign to this Pipeline Stage.
     *
     * @experimental
     */
    readonly stageName: string;
    /**
     * (experimental) The list of Actions to create this Stage with.
     *
     * You can always add more Actions later by calling {@link IStage#addAction}.
     *
     * @experimental
     */
    readonly actions?: IAction[];
}
/**
 * @experimental
 */
export interface StageOptions extends StageProps {
    /**
     * @experimental
     */
    readonly placement?: StagePlacement;
}
/**
 * @experimental
 */
export interface PipelineProps {
    /**
     * (experimental) The S3 bucket used by this Pipeline to store artifacts.
     *
     * @default - A new S3 bucket will be created.
     * @experimental
     */
    readonly artifactBucket?: s3.IBucket;
    /**
     * (experimental) The IAM role to be assumed by this Pipeline.
     *
     * @default a new IAM role will be created.
     * @experimental
     */
    readonly role?: iam.IRole;
    /**
     * (experimental) Indicates whether to rerun the AWS CodePipeline pipeline after you update it.
     *
     * @default false
     * @experimental
     */
    readonly restartExecutionOnUpdate?: boolean;
    /**
     * (experimental) Name of the pipeline.
     *
     * @default - AWS CloudFormation generates an ID and uses that for the pipeline name.
     * @experimental
     */
    readonly pipelineName?: string;
    /**
     * (experimental) A map of region to S3 bucket name used for cross-region CodePipeline.
     *
     * For every Action that you specify targeting a different region than the Pipeline itself,
     * if you don't provide an explicit Bucket for that region using this property,
     * the construct will automatically create a Stack containing an S3 Bucket in that region.
     *
     * @default - None.
     * @experimental
     */
    readonly crossRegionReplicationBuckets?: {
        [region: string]: s3.IBucket;
    };
    /**
     * (experimental) The list of Stages, in order, to create this Pipeline with.
     *
     * You can always add more Stages later by calling {@link Pipeline#addStage}.
     *
     * @default - None.
     * @experimental
     */
    readonly stages?: StageProps[];
    /**
     * (experimental) Create KMS keys for cross-account deployments.
     *
     * This controls whether the pipeline is enabled for cross-account deployments.
     *
     * By default cross-account deployments are enabled, but this feature requires
     * that KMS Customer Master Keys are created which have a cost of $1/month.
     *
     * If you do not need cross-account deployments, you can set this to `false` to
     * not create those keys and save on that cost (the artifact bucket will be
     * encrypted with an AWS-managed key). However, cross-account deployments will
     * no longer be possible.
     *
     * @default true
     * @experimental
     */
    readonly crossAccountKeys?: boolean;
}
declare abstract class PipelineBase extends Resource implements IPipeline {
    abstract readonly pipelineName: string;
    abstract readonly pipelineArn: string;
    /**
     * (experimental) Defines an event rule triggered by this CodePipeline.
     *
     * @param id Identifier for this event handler.
     * @param options Additional options to pass to the event rule.
     * @experimental
     */
    onEvent(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines an event rule triggered by the "CodePipeline Pipeline Execution State Change" event emitted from this pipeline.
     *
     * @param id Identifier for this event handler.
     * @param options Additional options to pass to the event rule.
     * @experimental
     */
    onStateChange(id: string, options?: events.OnEventOptions): events.Rule;
}
/**
 * (experimental) An AWS CodePipeline pipeline with its associated IAM role and S3 bucket.
 *
 * @experimental
 * @example
 *
 * // create a pipeline
 * const pipeline = new Pipeline(this, 'Pipeline');
 *
 * // add a stage
 * const sourceStage = pipeline.addStage({ stageName: 'Source' });
 *
 * // add a source action to the stage
 * sourceStage.addAction(new codepipeline_actions.CodeCommitSourceAction({
 *   actionName: 'Source',
 *   outputArtifactName: 'SourceArtifact',
 *   repository: repo,
 * }));
 *
 * // ... add more stages
 */
export declare class Pipeline extends PipelineBase {
    /**
     * (experimental) Import a pipeline into this app.
     *
     * @param scope the scope into which to import this pipeline.
     * @param id the logical ID of the returned pipeline construct.
     * @param pipelineArn The ARN of the pipeline (e.g. `arn:aws:codepipeline:us-east-1:123456789012:MyDemoPipeline`).
     * @experimental
     */
    static fromPipelineArn(scope: Construct, id: string, pipelineArn: string): IPipeline;
    /**
     * (experimental) The IAM role AWS CodePipeline will use to perform actions or assume roles for actions with a more specific IAM role.
     *
     * @experimental
     */
    readonly role: iam.IRole;
    /**
     * (experimental) ARN of this pipeline.
     *
     * @experimental
     */
    readonly pipelineArn: string;
    /**
     * (experimental) The name of the pipeline.
     *
     * @experimental
     */
    readonly pipelineName: string;
    /**
     * (experimental) The version of the pipeline.
     *
     * @experimental
     * @attribute true
     */
    readonly pipelineVersion: string;
    /**
     * (experimental) Bucket used to store output artifacts.
     *
     * @experimental
     */
    readonly artifactBucket: s3.IBucket;
    private readonly _stages;
    private readonly crossRegionBucketsPassed;
    private readonly _crossRegionSupport;
    private readonly _crossAccountSupport;
    private readonly crossAccountKeys;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: PipelineProps);
    /**
     * (experimental) Creates a new Stage, and adds it to this Pipeline.
     *
     * @param props the creation properties of the new Stage.
     * @returns the newly created Stage
     * @experimental
     */
    addStage(props: StageOptions): IStage;
    /**
     * (experimental) Adds a statement to the pipeline role.
     *
     * @experimental
     */
    addToRolePolicy(statement: iam.PolicyStatement): void;
    /**
     * (experimental) Get the number of Stages in this Pipeline.
     *
     * @experimental
     */
    get stageCount(): number;
    /**
     * (experimental) Returns the stages that comprise the pipeline.
     *
     * **Note**: the returned array is a defensive copy,
     * so adding elements to it has no effect.
     * Instead, use the {@link addStage} method if you want to add more stages
     * to the pipeline.
     *
     * @experimental
     */
    get stages(): IStage[];
    /**
     * (experimental) Access one of the pipeline's stages by stage name.
     *
     * @experimental
     */
    stage(stageName: string): IStage;
    /**
     * (experimental) Returns all of the {@link CrossRegionSupportStack}s that were generated automatically when dealing with Actions that reside in a different region than the Pipeline itself.
     *
     * @experimental
     */
    get crossRegionSupport(): {
        [region: string]: CrossRegionSupport;
    };
    /**
     * (experimental) Validate the pipeline structure.
     *
     * Validation happens according to the rules documented at
     *
     * https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#pipeline-requirements
     *
     * @experimental
     * @override true
     */
    protected validate(): string[];
    private ensureReplicationResourcesExistFor;
    /**
     * Get or create the cross-region support construct for the given action
     */
    private obtainCrossRegionSupportFor;
    private createSupportResourcesForRegion;
    private getCrossRegionSupportSynthesizer;
    private generateNameForDefaultBucketKeyAlias;
    /**
     * Gets the role used for this action,
     * including handling the case when the action is supposed to be cross-account.
     *
     * @param stage the stage the action belongs to
     * @param action the action to return/create a role for
     * @param actionScope the scope, unique to the action, to create new resources in
     */
    private getRoleForAction;
    private getRoleFromActionPropsOrGenerateIfCrossAccount;
    /**
     * Returns the Stack this Action belongs to if this is a cross-account Action.
     * If this Action is not cross-account (i.e., it lives in the same account as the Pipeline),
     * it returns undefined.
     *
     * @param action the Action to return the Stack for
     */
    private getOtherStackIfActionIsCrossAccount;
    private isAwsOwned;
    private getArtifactBucketFromProps;
    private calculateInsertIndexFromPlacement;
    private findStageIndex;
    private validateSourceActionLocations;
    private validateHasStages;
    private validateStages;
    private validateArtifacts;
    private renderArtifactStoresProperty;
    private renderArtifactStoreProperty;
    private renderPrimaryArtifactStore;
    private renderArtifactStore;
    private get crossRegion();
    private renderStages;
    private requireRegion;
    private requireApp;
}
/**
 * (experimental) An interface representing resources generated in order to support the cross-region capabilities of CodePipeline.
 *
 * You get instances of this interface from the {@link Pipeline#crossRegionSupport} property.
 *
 * @experimental
 */
export interface CrossRegionSupport {
    /**
     * (experimental) The Stack that has been created to house the replication Bucket required for this  region.
     *
     * @experimental
     */
    readonly stack: Stack;
    /**
     * (experimental) The replication Bucket used by CodePipeline to operate in this region.
     *
     * Belongs to {@link stack}.
     *
     * @experimental
     */
    readonly replicationBucket: s3.IBucket;
}
export {};
