import * as codepipeline from "../../../aws-codepipeline";
import * as stepfunction from "../../../aws-stepfunctions";
import * as cdk from "../../../core";
import { Action } from '../action';
/**
 * (experimental) Represents the input for the StateMachine.
 *
 * @experimental
 */
export declare class StateMachineInput {
    /**
     * (experimental) When the input type is FilePath, input artifact and filepath must be specified.
     *
     * @experimental
     */
    static filePath(inputFile: codepipeline.ArtifactPath): StateMachineInput;
    /**
     * (experimental) When the input type is Literal, input value is passed directly to the state machine input.
     *
     * @experimental
     */
    static literal(object: object): StateMachineInput;
    /**
     * (experimental) The optional input Artifact of the Action.
     *
     * If InputType is set to FilePath, this artifact is required
     * and is used to source the input for the state machine execution.
     *
     * @default - the Action will not have any inputs
     * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-StepFunctions.html#action-reference-StepFunctions-example
     * @experimental
     */
    readonly inputArtifact?: codepipeline.Artifact;
    /**
     * (experimental) Optional StateMachine InputType InputType can be Literal or FilePath.
     *
     * @default - Literal
     * @experimental
     */
    readonly inputType?: string;
    /**
     * (experimental) When InputType is set to Literal (default), the Input field is used directly as the input for the state machine execution.
     *
     * Otherwise, the state machine is invoked with an empty JSON object {}.
     *
     * When InputType is set to FilePath, this field is required.
     * An input artifact is also required when InputType is set to FilePath.
     *
     * @default - none
     * @experimental
     */
    readonly input: any;
    private constructor();
}
/**
 * (experimental) Construction properties of the {@link StepFunctionsInvokeAction StepFunction Invoke Action}.
 *
 * @experimental
 */
export interface StepFunctionsInvokeActionProps extends codepipeline.CommonAwsActionProps {
    /**
     * (experimental) The optional output Artifact of the Action.
     *
     * @default the Action will not have any outputs
     * @experimental
     */
    readonly output?: codepipeline.Artifact;
    /**
     * (experimental) The state machine to invoke.
     *
     * @experimental
     */
    readonly stateMachine: stepfunction.IStateMachine;
    /**
     * (experimental) Represents the input to the StateMachine.
     *
     * This includes input artifact, input type and the statemachine input.
     *
     * @default - none
     * @experimental
     */
    readonly stateMachineInput?: StateMachineInput;
    /**
     * (experimental) Prefix (optional).
     *
     * By default, the action execution ID is used as the state machine execution name.
     * If a prefix is provided, it is prepended to the action execution ID with a hyphen and
     * together used as the state machine execution name.
     *
     * @default - action execution ID
     * @experimental
     */
    readonly executionNamePrefix?: string;
}
/**
 * (experimental) StepFunctionInvokeAction that is provided by an AWS CodePipeline.
 *
 * @experimental
 */
export declare class StepFunctionInvokeAction extends Action {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: StepFunctionsInvokeActionProps);
    /**
     * (experimental) The method called when an Action is attached to a Pipeline.
     *
     * This method is guaranteed to be called only once for each Action instance.
     *
     * @experimental
     */
    protected bound(_scope: cdk.Construct, _stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
}
