"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManualApprovalAction = void 0;
const codepipeline = require("../../aws-codepipeline"); // Automatically re-written from '@aws-cdk/aws-codepipeline'
const sns = require("../../aws-sns"); // Automatically re-written from '@aws-cdk/aws-sns'
const subs = require("../../aws-sns-subscriptions"); // Automatically re-written from '@aws-cdk/aws-sns-subscriptions'
const action_1 = require("./action");
/**
 * (experimental) Manual approval action.
 *
 * @experimental
 */
class ManualApprovalAction extends action_1.Action {
    /**
     * @experimental
     */
    constructor(props) {
        super({
            ...props,
            category: codepipeline.ActionCategory.APPROVAL,
            provider: 'Manual',
            artifactBounds: { minInputs: 0, maxInputs: 0, minOutputs: 0, maxOutputs: 0 },
        });
        this.props = props;
    }
    /**
     * @experimental
     */
    get notificationTopic() {
        return this._notificationTopic;
    }
    /**
     * (experimental) The method called when an Action is attached to a Pipeline.
     *
     * This method is guaranteed to be called only once for each Action instance.
     *
     * @experimental
     */
    bound(scope, _stage, options) {
        var _a;
        if (this.props.notificationTopic) {
            this._notificationTopic = this.props.notificationTopic;
        }
        else if ((this.props.notifyEmails || []).length > 0) {
            this._notificationTopic = new sns.Topic(scope, 'TopicResource');
        }
        if (this._notificationTopic) {
            this._notificationTopic.grantPublish(options.role);
            for (const notifyEmail of this.props.notifyEmails || []) {
                this._notificationTopic.addSubscription(new subs.EmailSubscription(notifyEmail));
            }
        }
        return {
            configuration: undefinedIfAllValuesAreEmpty({
                NotificationArn: (_a = this._notificationTopic) === null || _a === void 0 ? void 0 : _a.topicArn,
                CustomData: this.props.additionalInformation,
                ExternalEntityLink: this.props.externalEntityLink,
            }),
        };
    }
}
exports.ManualApprovalAction = ManualApprovalAction;
function undefinedIfAllValuesAreEmpty(object) {
    return Object.values(object).some(v => v !== undefined) ? object : undefined;
}
//# sourceMappingURL=data:application/json;base64,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