import * as codepipeline from "../../../aws-codepipeline";
import * as lambda from "../../../aws-lambda";
import { Construct } from "../../../core";
import { Action } from '../action';
/**
 * (experimental) Construction properties of the {@link LambdaInvokeAction Lambda invoke CodePipeline Action}.
 *
 * @experimental
 */
export interface LambdaInvokeActionProps extends codepipeline.CommonAwsActionProps {
    /**
     * (experimental) The optional input Artifacts of the Action.
     *
     * A Lambda Action can have up to 5 inputs.
     * The inputs will appear in the event passed to the Lambda,
     * under the `'CodePipeline.job'.data.inputArtifacts` path.
     *
     * @default the Action will not have any inputs
     * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-invoke-lambda-function.html#actions-invoke-lambda-function-json-event-example
     * @experimental
     */
    readonly inputs?: codepipeline.Artifact[];
    /**
     * (experimental) The optional names of the output Artifacts of the Action.
     *
     * A Lambda Action can have up to 5 outputs.
     * The outputs will appear in the event passed to the Lambda,
     * under the `'CodePipeline.job'.data.outputArtifacts` path.
     * It is the responsibility of the Lambda to upload ZIP files with the Artifact contents to the provided locations.
     *
     * @default the Action will not have any outputs
     * @experimental
     */
    readonly outputs?: codepipeline.Artifact[];
    /**
     * (experimental) A set of key-value pairs that will be accessible to the invoked Lambda inside the event that the Pipeline will call it with.
     *
     * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-invoke-lambda-function.html#actions-invoke-lambda-function-json-event-example
     * @experimental
     */
    readonly userParameters?: {
        [key: string]: any;
    };
    /**
     * (experimental) The lambda function to invoke.
     *
     * @experimental
     */
    readonly lambda: lambda.IFunction;
}
/**
 * (experimental) CodePipeline invoke Action that is provided by an AWS Lambda function.
 *
 * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-invoke-lambda-function.html
 * @experimental
 */
export declare class LambdaInvokeAction extends Action {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: LambdaInvokeActionProps);
    /**
     * (experimental) Reference a CodePipeline variable defined by the Lambda function this action points to.
     *
     * Variables in Lambda invoke actions are defined by calling the PutJobSuccessResult CodePipeline API call
     * with the 'outputVariables' property filled.
     *
     * @param variableName the name of the variable to reference.
     * @see https://docs.aws.amazon.com/codepipeline/latest/APIReference/API_PutJobSuccessResult.html
     * @experimental
     */
    variable(variableName: string): string;
    /**
     * (experimental) The method called when an Action is attached to a Pipeline.
     *
     * This method is guaranteed to be called only once for each Action instance.
     *
     * @experimental
     */
    protected bound(scope: Construct, _stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
}
