import * as codecommit from "../../../aws-codecommit";
import * as codepipeline from "../../../aws-codepipeline";
import { Construct } from "../../../core";
import { Action } from '../action';
/**
 * (experimental) How should the CodeCommit Action detect changes.
 *
 * This is the type of the {@link CodeCommitSourceAction.trigger} property.
 *
 * @experimental
 */
export declare enum CodeCommitTrigger {
    /**
     * (experimental) The Action will never detect changes - the Pipeline it's part of will only begin a run when explicitly started.
     *
     * @experimental
     */
    NONE = "None",
    /**
     * (experimental) CodePipeline will poll the repository to detect changes.
     *
     * @experimental
     */
    POLL = "Poll",
    /**
     * (experimental) CodePipeline will use CloudWatch Events to be notified of changes.
     *
     * This is the default method of detecting changes.
     *
     * @experimental
     */
    EVENTS = "Events"
}
/**
 * (experimental) The CodePipeline variables emitted by the CodeCommit source Action.
 *
 * @experimental
 */
export interface CodeCommitSourceVariables {
    /**
     * (experimental) The name of the repository this action points to.
     *
     * @experimental
     */
    readonly repositoryName: string;
    /**
     * (experimental) The name of the branch this action tracks.
     *
     * @experimental
     */
    readonly branchName: string;
    /**
     * (experimental) The date the currently last commit on the tracked branch was authored, in ISO-8601 format.
     *
     * @experimental
     */
    readonly authorDate: string;
    /**
     * (experimental) The date the currently last commit on the tracked branch was committed, in ISO-8601 format.
     *
     * @experimental
     */
    readonly committerDate: string;
    /**
     * (experimental) The SHA1 hash of the currently last commit on the tracked branch.
     *
     * @experimental
     */
    readonly commitId: string;
    /**
     * (experimental) The message of the currently last commit on the tracked branch.
     *
     * @experimental
     */
    readonly commitMessage: string;
}
/**
 * (experimental) Construction properties of the {@link CodeCommitSourceAction CodeCommit source CodePipeline Action}.
 *
 * @experimental
 */
export interface CodeCommitSourceActionProps extends codepipeline.CommonAwsActionProps {
    /**
     * @experimental
     */
    readonly output: codepipeline.Artifact;
    /**
     * @default 'master'
     * @experimental
     */
    readonly branch?: string;
    /**
     * (experimental) How should CodePipeline detect source changes for this Action.
     *
     * @default CodeCommitTrigger.EVENTS
     * @experimental
     */
    readonly trigger?: CodeCommitTrigger;
    /**
     * (experimental) The CodeCommit repository.
     *
     * @experimental
     */
    readonly repository: codecommit.IRepository;
}
/**
 * (experimental) CodePipeline Source that is provided by an AWS CodeCommit repository.
 *
 * @experimental
 */
export declare class CodeCommitSourceAction extends Action {
    private readonly branch;
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: CodeCommitSourceActionProps);
    /**
     * (experimental) The variables emitted by this action.
     *
     * @experimental
     */
    get variables(): CodeCommitSourceVariables;
    /**
     * (experimental) The method called when an Action is attached to a Pipeline.
     *
     * This method is guaranteed to be called only once for each Action instance.
     *
     * @experimental
     */
    protected bound(_scope: Construct, stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
    private generateEventId;
    private eventIdFromPrefix;
}
