import * as codebuild from "../../../aws-codebuild";
import * as codepipeline from "../../../aws-codepipeline";
import * as cdk from "../../../core";
import { Action } from '../action';
/**
 * (experimental) The type of the CodeBuild action that determines its CodePipeline Category - Build, or Test.
 *
 * The default is Build.
 *
 * @experimental
 */
export declare enum CodeBuildActionType {
    /**
     * (experimental) The action will have the Build Category.
     *
     * This is the default.
     *
     * @experimental
     */
    BUILD = 0,
    /**
     * (experimental) The action will have the Test Category.
     *
     * @experimental
     */
    TEST = 1
}
/**
 * (experimental) Construction properties of the {@link CodeBuildAction CodeBuild build CodePipeline action}.
 *
 * @experimental
 */
export interface CodeBuildActionProps extends codepipeline.CommonAwsActionProps {
    /**
     * (experimental) The source to use as input for this action.
     *
     * @experimental
     */
    readonly input: codepipeline.Artifact;
    /**
     * (experimental) The list of additional input Artifacts for this action.
     *
     * The directories the additional inputs will be available at are available
     * during the project's build in the CODEBUILD_SRC_DIR_<artifact-name> environment variables.
     * The project's build always starts in the directory with the primary input artifact checked out,
     * the one pointed to by the {@link input} property.
     * For more information,
     * see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-multi-in-out.html .
     *
     * @experimental
     */
    readonly extraInputs?: codepipeline.Artifact[];
    /**
     * (experimental) The list of output Artifacts for this action.
     *
     * **Note**: if you specify more than one output Artifact here,
     * you cannot use the primary 'artifacts' section of the buildspec;
     * you have to use the 'secondary-artifacts' section instead.
     * See https://docs.aws.amazon.com/codebuild/latest/userguide/sample-multi-in-out.html
     * for details.
     *
     * @default the action will not have any outputs
     * @experimental
     */
    readonly outputs?: codepipeline.Artifact[];
    /**
     * (experimental) The action's Project.
     *
     * @experimental
     */
    readonly project: codebuild.IProject;
    /**
     * (experimental) The type of the action that determines its CodePipeline Category - Build, or Test.
     *
     * @default CodeBuildActionType.BUILD
     * @experimental
     */
    readonly type?: CodeBuildActionType;
    /**
     * (experimental) The environment variables to pass to the CodeBuild project when this action executes.
     *
     * If a variable with the same name was set both on the project level, and here,
     * this value will take precedence.
     *
     * @default - No additional environment variables are specified.
     * @experimental
     */
    readonly environmentVariables?: {
        [name: string]: codebuild.BuildEnvironmentVariable;
    };
}
/**
 * (experimental) CodePipeline build action that uses AWS CodeBuild.
 *
 * @experimental
 */
export declare class CodeBuildAction extends Action {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: CodeBuildActionProps);
    /**
     * (experimental) Reference a CodePipeline variable defined by the CodeBuild project this action points to.
     *
     * Variables in CodeBuild actions are defined using the 'exported-variables' subsection of the 'env'
     * section of the buildspec.
     *
     * @param variableName the name of the variable to reference.
     * @see https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-syntax
     * @experimental
     */
    variable(variableName: string): string;
    /**
     * (experimental) The method called when an Action is attached to a Pipeline.
     *
     * This method is guaranteed to be called only once for each Action instance.
     *
     * @experimental
     */
    protected bound(scope: cdk.Construct, _stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
}
