import * as codepipeline from "../../../aws-codepipeline";
import { Construct } from "../../../core";
import { Action } from '../action';
/**
 * (experimental) Construction properties for {@link BitBucketSourceAction}.
 *
 * @experimental
 */
export interface BitBucketSourceActionProps extends codepipeline.CommonAwsActionProps {
    /**
     * (experimental) The output artifact that this action produces.
     *
     * Can be used as input for further pipeline actions.
     *
     * @experimental
     */
    readonly output: codepipeline.Artifact;
    /**
     * (experimental) The ARN of the CodeStar Connection created in the AWS console that has permissions to access this BitBucket repository.
     *
     * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/connections-create.html
     * @experimental
     * @example
     *
     * 'arn:aws:codestar-connections:us-east-1:123456789012:connection/12345678-abcd-12ab-34cdef5678gh'
     */
    readonly connectionArn: string;
    /**
     * (experimental) The owning user or organization of the repository.
     *
     * @experimental
     * @example
     *
     * 'aws'
     */
    readonly owner: string;
    /**
     * (experimental) The name of the repository.
     *
     * @experimental
     * @example
     *
     * 'aws-cdk'
     */
    readonly repo: string;
    /**
     * (experimental) The branch to build.
     *
     * @default 'master'
     * @experimental
     */
    readonly branch?: string;
    /**
     * (experimental) Whether the output should be the contents of the repository (which is the default), or a link that allows CodeBuild to clone the repository before building.
     *
     * **Note**: if this option is true,
     * then only CodeBuild actions can use the resulting {@link output}.
     *
     * @default false
     * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodestarConnectionSource.html#action-reference-CodestarConnectionSource-config
     * @experimental
     */
    readonly codeBuildCloneOutput?: boolean;
}
/**
 * (experimental) A CodePipeline source action for BitBucket.
 *
 * @experimental
 */
export declare class BitBucketSourceAction extends Action {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: BitBucketSourceActionProps);
    /**
     * (experimental) The method called when an Action is attached to a Pipeline.
     *
     * This method is guaranteed to be called only once for each Action instance.
     *
     * @experimental
     */
    protected bound(_scope: Construct, _stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
}
