"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = void 0;
const events = require("../../aws-events"); // Automatically re-written from '@aws-cdk/aws-events'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * (experimental) Low-level class for generic CodePipeline Actions.
 *
 * WARNING: this class should not be externally exposed, but is currently visible
 * because of a limitation of jsii (https://github.com/aws/jsii/issues/524).
 *
 * This class will disappear in a future release and should not be used.
 *
 * @experimental
 */
class Action {
    /**
     * @experimental
     */
    constructor(actionProperties) {
        this.variableReferenced = false;
        this.customerProvidedNamespace = actionProperties.variablesNamespace;
        this.namespaceOrToken = core_1.Lazy.stringValue({
            produce: () => {
                // make sure the action was bound (= added to a pipeline)
                if (this.actualNamespace !== undefined) {
                    return this.customerProvidedNamespace !== undefined
                        // if a customer passed a namespace explicitly, always use that
                        ? this.customerProvidedNamespace
                        // otherwise, only return a namespace if any variable was referenced
                        : (this.variableReferenced ? this.actualNamespace : undefined);
                }
                else {
                    throw new Error(`Cannot reference variables of action '${this.actionProperties.actionName}', ` +
                        'as that action was never added to a pipeline');
                }
            },
        });
        this.actionProperties = {
            ...actionProperties,
            variablesNamespace: this.namespaceOrToken,
        };
    }
    /**
     * @experimental
     */
    bind(scope, stage, options) {
        this._pipeline = stage.pipeline;
        this._stage = stage;
        this._scope = scope;
        this.actualNamespace = this.customerProvidedNamespace === undefined
            // default a namespace name, based on the stage and action names
            ? `${stage.stageName}_${this.actionProperties.actionName}_NS`
            : this.customerProvidedNamespace;
        return this.bound(scope, stage, options);
    }
    /**
     * @experimental
     */
    onStateChange(name, target, options) {
        const rule = new events.Rule(this.scope, name, options);
        rule.addTarget(target);
        rule.addEventPattern({
            detailType: ['CodePipeline Action Execution State Change'],
            source: ['aws.codepipeline'],
            resources: [this.pipeline.pipelineArn],
            detail: {
                stage: [this.stage.stageName],
                action: [this.actionProperties.actionName],
            },
        });
        return rule;
    }
    /**
     * @experimental
     */
    variableExpression(variableName) {
        this.variableReferenced = true;
        return `#{${this.namespaceOrToken}.${variableName}}`;
    }
    get pipeline() {
        if (this._pipeline) {
            return this._pipeline;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline before using onStateChange');
        }
    }
    get stage() {
        if (this._stage) {
            return this._stage;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline before using onStateChange');
        }
    }
    /**
     * Retrieves the Construct scope of this Action.
     * Only available after the Action has been added to a Stage,
     * and that Stage to a Pipeline.
     */
    get scope() {
        if (this._scope) {
            return this._scope;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline first');
        }
    }
}
exports.Action = Action;
//# sourceMappingURL=data:application/json;base64,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