import * as cloudwatch from "../../../aws-cloudwatch";
import * as iam from "../../../aws-iam";
import * as lambda from "../../../aws-lambda";
import * as cdk from "../../../core";
import { Construct } from 'constructs';
import { AutoRollbackConfig } from '../rollback-config';
import { ILambdaApplication } from './application';
import { ILambdaDeploymentConfig } from './deployment-config';
/**
 * (experimental) Interface for a Lambda deployment groups.
 *
 * @experimental
 */
export interface ILambdaDeploymentGroup extends cdk.IResource {
    /**
     * (experimental) The reference to the CodeDeploy Lambda Application that this Deployment Group belongs to.
     *
     * @experimental
     */
    readonly application: ILambdaApplication;
    /**
     * (experimental) The physical name of the CodeDeploy Deployment Group.
     *
     * @experimental
     * @attribute true
     */
    readonly deploymentGroupName: string;
    /**
     * (experimental) The ARN of this Deployment Group.
     *
     * @experimental
     * @attribute true
     */
    readonly deploymentGroupArn: string;
    /**
     * (experimental) The Deployment Configuration this Group uses.
     *
     * @experimental
     */
    readonly deploymentConfig: ILambdaDeploymentConfig;
}
/**
 * (experimental) Construction properties for {@link LambdaDeploymentGroup}.
 *
 * @experimental
 */
export interface LambdaDeploymentGroupProps {
    /**
     * (experimental) The reference to the CodeDeploy Lambda Application that this Deployment Group belongs to.
     *
     * @default - One will be created for you.
     * @experimental
     */
    readonly application?: ILambdaApplication;
    /**
     * (experimental) The physical, human-readable name of the CodeDeploy Deployment Group.
     *
     * @default - An auto-generated name will be used.
     * @experimental
     */
    readonly deploymentGroupName?: string;
    /**
     * (experimental) The Deployment Configuration this Deployment Group uses.
     *
     * @default LambdaDeploymentConfig.CANARY_10PERCENT_5MINUTES
     * @experimental
     */
    readonly deploymentConfig?: ILambdaDeploymentConfig;
    /**
     * (experimental) The CloudWatch alarms associated with this Deployment Group.
     *
     * CodeDeploy will stop (and optionally roll back)
     * a deployment if during it any of the alarms trigger.
     *
     * Alarms can also be added after the Deployment Group is created using the {@link #addAlarm} method.
     *
     * @default []
     * @see https://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-create-alarms.html
     * @experimental
     */
    readonly alarms?: cloudwatch.IAlarm[];
    /**
     * (experimental) The service Role of this Deployment Group.
     *
     * @default - A new Role will be created.
     * @experimental
     */
    readonly role?: iam.IRole;
    /**
     * (experimental) Lambda Alias to shift traffic. Updating the version of the alias will trigger a CodeDeploy deployment.
     *
     * [disable-awslint:ref-via-interface] since we need to modify the alias CFN resource update policy
     *
     * @experimental
     */
    readonly alias: lambda.Alias;
    /**
     * (experimental) The Lambda function to run before traffic routing starts.
     *
     * @default - None.
     * @experimental
     */
    readonly preHook?: lambda.IFunction;
    /**
     * (experimental) The Lambda function to run after traffic routing starts.
     *
     * @default - None.
     * @experimental
     */
    readonly postHook?: lambda.IFunction;
    /**
     * (experimental) Whether to continue a deployment even if fetching the alarm status from CloudWatch failed.
     *
     * @default false
     * @experimental
     */
    readonly ignorePollAlarmsFailure?: boolean;
    /**
     * (experimental) The auto-rollback configuration for this Deployment Group.
     *
     * @default - default AutoRollbackConfig.
     * @experimental
     */
    readonly autoRollback?: AutoRollbackConfig;
}
/**
 * @experimental
 * @resource AWS::CodeDeploy::DeploymentGroup
 */
export declare class LambdaDeploymentGroup extends cdk.Resource implements ILambdaDeploymentGroup {
    /**
     * (experimental) Import an Lambda Deployment Group defined either outside the CDK app, or in a different AWS region.
     *
     * @param scope the parent Construct for this new Construct.
     * @param id the logical ID of this new Construct.
     * @param attrs the properties of the referenced Deployment Group.
     * @returns a Construct representing a reference to an existing Deployment Group
     * @experimental
     */
    static fromLambdaDeploymentGroupAttributes(scope: Construct, id: string, attrs: LambdaDeploymentGroupAttributes): ILambdaDeploymentGroup;
    /**
     * (experimental) The reference to the CodeDeploy Lambda Application that this Deployment Group belongs to.
     *
     * @experimental
     */
    readonly application: ILambdaApplication;
    /**
     * (experimental) The physical name of the CodeDeploy Deployment Group.
     *
     * @experimental
     */
    readonly deploymentGroupName: string;
    /**
     * (experimental) The ARN of this Deployment Group.
     *
     * @experimental
     */
    readonly deploymentGroupArn: string;
    /**
     * (experimental) The Deployment Configuration this Group uses.
     *
     * @experimental
     */
    readonly deploymentConfig: ILambdaDeploymentConfig;
    /**
     * @experimental
     */
    readonly role: iam.IRole;
    private readonly alarms;
    private preHook?;
    private postHook?;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: LambdaDeploymentGroupProps);
    /**
     * (experimental) Associates an additional alarm with this Deployment Group.
     *
     * @param alarm the alarm to associate with this Deployment Group.
     * @experimental
     */
    addAlarm(alarm: cloudwatch.IAlarm): void;
    /**
     * (experimental) Associate a function to run before deployment begins.
     *
     * @param preHook function to run before deployment beings.
     * @experimental
     * @throws an error if a pre-hook function is already configured
     */
    addPreHook(preHook: lambda.IFunction): void;
    /**
     * (experimental) Associate a function to run after deployment completes.
     *
     * @param postHook function to run after deployment completes.
     * @experimental
     * @throws an error if a post-hook function is already configured
     */
    addPostHook(postHook: lambda.IFunction): void;
    /**
     * (experimental) Grant a principal permission to codedeploy:PutLifecycleEventHookExecutionStatus on this deployment group resource.
     *
     * @param grantee to grant permission to.
     * @experimental
     */
    grantPutLifecycleEventHookExecutionStatus(grantee: iam.IGrantable): iam.Grant;
}
/**
 * (experimental) Properties of a reference to a CodeDeploy Lambda Deployment Group.
 *
 * @see LambdaDeploymentGroup#fromLambdaDeploymentGroupAttributes
 * @experimental
 */
export interface LambdaDeploymentGroupAttributes {
    /**
     * (experimental) The reference to the CodeDeploy Lambda Application that this Deployment Group belongs to.
     *
     * @experimental
     */
    readonly application: ILambdaApplication;
    /**
     * (experimental) The physical, human-readable name of the CodeDeploy Lambda Deployment Group that we are referencing.
     *
     * @experimental
     */
    readonly deploymentGroupName: string;
    /**
     * (experimental) The Deployment Configuration this Deployment Group uses.
     *
     * @default LambdaDeploymentConfig.CANARY_10PERCENT_5MINUTES
     * @experimental
     */
    readonly deploymentConfig?: ILambdaDeploymentConfig;
}
