import { IResource, Resource } from "../../../core";
import { Construct } from 'constructs';
/**
 * (experimental) Represents a reference to a CodeDeploy Application deploying to AWS Lambda.
 *
 * If you're managing the Application alongside the rest of your CDK resources,
 * use the {@link LambdaApplication} class.
 *
 * If you want to reference an already existing Application,
 * or one defined in a different CDK Stack,
 * use the {@link LambdaApplication#fromLambdaApplicationName} method.
 *
 * @experimental
 */
export interface ILambdaApplication extends IResource {
    /**
     * @experimental
     * @attribute true
     */
    readonly applicationArn: string;
    /**
     * @experimental
     * @attribute true
     */
    readonly applicationName: string;
}
/**
 * (experimental) Construction properties for {@link LambdaApplication}.
 *
 * @experimental
 */
export interface LambdaApplicationProps {
    /**
     * (experimental) The physical, human-readable name of the CodeDeploy Application.
     *
     * @default an auto-generated name will be used
     * @experimental
     */
    readonly applicationName?: string;
}
/**
 * (experimental) A CodeDeploy Application that deploys to an AWS Lambda function.
 *
 * @experimental
 * @resource AWS::CodeDeploy::Application
 */
export declare class LambdaApplication extends Resource implements ILambdaApplication {
    /**
     * (experimental) Import an Application defined either outside the CDK, or in a different CDK Stack.
     *
     * @param scope the parent Construct for this new Construct.
     * @param id the logical ID of this new Construct.
     * @param lambdaApplicationName the name of the application to import.
     * @returns a Construct representing a reference to an existing Application
     * @experimental
     */
    static fromLambdaApplicationName(scope: Construct, id: string, lambdaApplicationName: string): ILambdaApplication;
    /**
     * @experimental
     */
    readonly applicationArn: string;
    /**
     * @experimental
     */
    readonly applicationName: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: LambdaApplicationProps);
}
