import { IResource, Resource } from "../../../core";
import { Construct } from 'constructs';
/**
 * (experimental) Represents a reference to a CodeDeploy Application deploying to Amazon ECS.
 *
 * If you're managing the Application alongside the rest of your CDK resources,
 * use the {@link EcsApplication} class.
 *
 * If you want to reference an already existing Application,
 * or one defined in a different CDK Stack,
 * use the {@link EcsApplication#fromEcsApplicationName} method.
 *
 * @experimental
 */
export interface IEcsApplication extends IResource {
    /**
     * @experimental
     * @attribute true
     */
    readonly applicationArn: string;
    /**
     * @experimental
     * @attribute true
     */
    readonly applicationName: string;
}
/**
 * (experimental) Construction properties for {@link EcsApplication}.
 *
 * @experimental
 */
export interface EcsApplicationProps {
    /**
     * (experimental) The physical, human-readable name of the CodeDeploy Application.
     *
     * @default an auto-generated name will be used
     * @experimental
     */
    readonly applicationName?: string;
}
/**
 * (experimental) A CodeDeploy Application that deploys to an Amazon ECS service.
 *
 * @experimental
 * @resource AWS::CodeDeploy::Application
 */
export declare class EcsApplication extends Resource implements IEcsApplication {
    /**
     * (experimental) Import an Application defined either outside the CDK, or in a different CDK Stack.
     *
     * @param scope the parent Construct for this new Construct.
     * @param id the logical ID of this new Construct.
     * @param ecsApplicationName the name of the application to import.
     * @returns a Construct representing a reference to an existing Application
     * @experimental
     */
    static fromEcsApplicationName(scope: Construct, id: string, ecsApplicationName: string): IEcsApplication;
    /**
     * @experimental
     */
    readonly applicationArn: string;
    /**
     * @experimental
     */
    readonly applicationName: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: EcsApplicationProps);
}
