import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::CodeDeploy::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-application.html
 * @external
 */
export interface CfnApplicationProps {
    /**
     * `AWS::CodeDeploy::Application.ApplicationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-application.html#cfn-codedeploy-application-applicationname
     * @external
     */
    readonly applicationName?: string;
    /**
     * `AWS::CodeDeploy::Application.ComputePlatform`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-application.html#cfn-codedeploy-application-computeplatform
     * @external
     */
    readonly computePlatform?: string;
}
/**
 * A CloudFormation `AWS::CodeDeploy::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-application.html
 * @external
 * @cloudformationResource AWS::CodeDeploy::Application
 */
export declare class CfnApplication extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CodeDeploy::Application";
    /**
     * `AWS::CodeDeploy::Application.ApplicationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-application.html#cfn-codedeploy-application-applicationname
     * @external
     */
    applicationName: string | undefined;
    /**
     * `AWS::CodeDeploy::Application.ComputePlatform`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-application.html#cfn-codedeploy-application-computeplatform
     * @external
     */
    computePlatform: string | undefined;
    /**
     * Create a new `AWS::CodeDeploy::Application`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnApplicationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::CodeDeploy::DeploymentConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentconfig.html
 * @external
 */
export interface CfnDeploymentConfigProps {
    /**
     * `AWS::CodeDeploy::DeploymentConfig.DeploymentConfigName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentconfig.html#cfn-codedeploy-deploymentconfig-deploymentconfigname
     * @external
     */
    readonly deploymentConfigName?: string;
    /**
     * `AWS::CodeDeploy::DeploymentConfig.MinimumHealthyHosts`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentconfig.html#cfn-codedeploy-deploymentconfig-minimumhealthyhosts
     * @external
     */
    readonly minimumHealthyHosts?: CfnDeploymentConfig.MinimumHealthyHostsProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::CodeDeploy::DeploymentConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentconfig.html
 * @external
 * @cloudformationResource AWS::CodeDeploy::DeploymentConfig
 */
export declare class CfnDeploymentConfig extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CodeDeploy::DeploymentConfig";
    /**
     * `AWS::CodeDeploy::DeploymentConfig.DeploymentConfigName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentconfig.html#cfn-codedeploy-deploymentconfig-deploymentconfigname
     * @external
     */
    deploymentConfigName: string | undefined;
    /**
     * `AWS::CodeDeploy::DeploymentConfig.MinimumHealthyHosts`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentconfig.html#cfn-codedeploy-deploymentconfig-minimumhealthyhosts
     * @external
     */
    minimumHealthyHosts: CfnDeploymentConfig.MinimumHealthyHostsProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::CodeDeploy::DeploymentConfig`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnDeploymentConfigProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::CodeDeploy::DeploymentConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentconfig.html
 * @external
 * @cloudformationResource AWS::CodeDeploy::DeploymentConfig
 */
export declare namespace CfnDeploymentConfig {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentconfig-minimumhealthyhosts.html
     * @external
     */
    interface MinimumHealthyHostsProperty {
        /**
         * `CfnDeploymentConfig.MinimumHealthyHostsProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentconfig-minimumhealthyhosts.html#cfn-codedeploy-deploymentconfig-minimumhealthyhosts-type
         * @external
         */
        readonly type: string;
        /**
         * `CfnDeploymentConfig.MinimumHealthyHostsProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentconfig-minimumhealthyhosts.html#cfn-codedeploy-deploymentconfig-minimumhealthyhosts-value
         * @external
         */
        readonly value: number;
    }
}
/**
 * Properties for defining a `AWS::CodeDeploy::DeploymentGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html
 * @external
 */
export interface CfnDeploymentGroupProps {
    /**
     * `AWS::CodeDeploy::DeploymentGroup.ApplicationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-applicationname
     * @external
     */
    readonly applicationName: string;
    /**
     * `AWS::CodeDeploy::DeploymentGroup.ServiceRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-servicerolearn
     * @external
     */
    readonly serviceRoleArn: string;
    /**
     * `AWS::CodeDeploy::DeploymentGroup.AlarmConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-alarmconfiguration
     * @external
     */
    readonly alarmConfiguration?: CfnDeploymentGroup.AlarmConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::CodeDeploy::DeploymentGroup.AutoRollbackConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration
     * @external
     */
    readonly autoRollbackConfiguration?: CfnDeploymentGroup.AutoRollbackConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::CodeDeploy::DeploymentGroup.AutoScalingGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-autoscalinggroups
     * @external
     */
    readonly autoScalingGroups?: string[];
    /**
     * `AWS::CodeDeploy::DeploymentGroup.Deployment`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deployment
     * @external
     */
    readonly deployment?: CfnDeploymentGroup.DeploymentProperty | cdk.IResolvable;
    /**
     * `AWS::CodeDeploy::DeploymentGroup.DeploymentConfigName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentconfigname
     * @external
     */
    readonly deploymentConfigName?: string;
    /**
     * `AWS::CodeDeploy::DeploymentGroup.DeploymentGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentgroupname
     * @external
     */
    readonly deploymentGroupName?: string;
    /**
     * `AWS::CodeDeploy::DeploymentGroup.DeploymentStyle`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentstyle
     * @external
     */
    readonly deploymentStyle?: CfnDeploymentGroup.DeploymentStyleProperty | cdk.IResolvable;
    /**
     * `AWS::CodeDeploy::DeploymentGroup.Ec2TagFilters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-ec2tagfilters
     * @external
     */
    readonly ec2TagFilters?: Array<CfnDeploymentGroup.EC2TagFilterProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CodeDeploy::DeploymentGroup.Ec2TagSet`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-ec2tagset
     * @external
     */
    readonly ec2TagSet?: CfnDeploymentGroup.EC2TagSetProperty | cdk.IResolvable;
    /**
     * `AWS::CodeDeploy::DeploymentGroup.LoadBalancerInfo`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo
     * @external
     */
    readonly loadBalancerInfo?: CfnDeploymentGroup.LoadBalancerInfoProperty | cdk.IResolvable;
    /**
     * `AWS::CodeDeploy::DeploymentGroup.OnPremisesInstanceTagFilters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-onpremisesinstancetagfilters
     * @external
     */
    readonly onPremisesInstanceTagFilters?: Array<CfnDeploymentGroup.TagFilterProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CodeDeploy::DeploymentGroup.OnPremisesTagSet`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-onpremisestagset
     * @external
     */
    readonly onPremisesTagSet?: CfnDeploymentGroup.OnPremisesTagSetProperty | cdk.IResolvable;
    /**
     * `AWS::CodeDeploy::DeploymentGroup.TriggerConfigurations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-triggerconfigurations
     * @external
     */
    readonly triggerConfigurations?: Array<CfnDeploymentGroup.TriggerConfigProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::CodeDeploy::DeploymentGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html
 * @external
 * @cloudformationResource AWS::CodeDeploy::DeploymentGroup
 */
export declare class CfnDeploymentGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CodeDeploy::DeploymentGroup";
    /**
     * `AWS::CodeDeploy::DeploymentGroup.ApplicationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-applicationname
     * @external
     */
    applicationName: string;
    /**
     * `AWS::CodeDeploy::DeploymentGroup.ServiceRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-servicerolearn
     * @external
     */
    serviceRoleArn: string;
    /**
     * `AWS::CodeDeploy::DeploymentGroup.AlarmConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-alarmconfiguration
     * @external
     */
    alarmConfiguration: CfnDeploymentGroup.AlarmConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeDeploy::DeploymentGroup.AutoRollbackConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration
     * @external
     */
    autoRollbackConfiguration: CfnDeploymentGroup.AutoRollbackConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeDeploy::DeploymentGroup.AutoScalingGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-autoscalinggroups
     * @external
     */
    autoScalingGroups: string[] | undefined;
    /**
     * `AWS::CodeDeploy::DeploymentGroup.Deployment`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deployment
     * @external
     */
    deployment: CfnDeploymentGroup.DeploymentProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeDeploy::DeploymentGroup.DeploymentConfigName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentconfigname
     * @external
     */
    deploymentConfigName: string | undefined;
    /**
     * `AWS::CodeDeploy::DeploymentGroup.DeploymentGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentgroupname
     * @external
     */
    deploymentGroupName: string | undefined;
    /**
     * `AWS::CodeDeploy::DeploymentGroup.DeploymentStyle`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-deploymentstyle
     * @external
     */
    deploymentStyle: CfnDeploymentGroup.DeploymentStyleProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeDeploy::DeploymentGroup.Ec2TagFilters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-ec2tagfilters
     * @external
     */
    ec2TagFilters: Array<CfnDeploymentGroup.EC2TagFilterProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeDeploy::DeploymentGroup.Ec2TagSet`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-ec2tagset
     * @external
     */
    ec2TagSet: CfnDeploymentGroup.EC2TagSetProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeDeploy::DeploymentGroup.LoadBalancerInfo`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo
     * @external
     */
    loadBalancerInfo: CfnDeploymentGroup.LoadBalancerInfoProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeDeploy::DeploymentGroup.OnPremisesInstanceTagFilters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-onpremisesinstancetagfilters
     * @external
     */
    onPremisesInstanceTagFilters: Array<CfnDeploymentGroup.TagFilterProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeDeploy::DeploymentGroup.OnPremisesTagSet`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-onpremisestagset
     * @external
     */
    onPremisesTagSet: CfnDeploymentGroup.OnPremisesTagSetProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeDeploy::DeploymentGroup.TriggerConfigurations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html#cfn-codedeploy-deploymentgroup-triggerconfigurations
     * @external
     */
    triggerConfigurations: Array<CfnDeploymentGroup.TriggerConfigProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::CodeDeploy::DeploymentGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDeploymentGroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::CodeDeploy::DeploymentGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html
 * @external
 * @cloudformationResource AWS::CodeDeploy::DeploymentGroup
 */
export declare namespace CfnDeploymentGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarm.html
     * @external
     */
    interface AlarmProperty {
        /**
         * `CfnDeploymentGroup.AlarmProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarm.html#cfn-codedeploy-deploymentgroup-alarm-name
         * @external
         */
        readonly name?: string;
    }
}
/**
 * A CloudFormation `AWS::CodeDeploy::DeploymentGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html
 * @external
 * @cloudformationResource AWS::CodeDeploy::DeploymentGroup
 */
export declare namespace CfnDeploymentGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html
     * @external
     */
    interface AlarmConfigurationProperty {
        /**
         * `CfnDeploymentGroup.AlarmConfigurationProperty.Alarms`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-alarms
         * @external
         */
        readonly alarms?: Array<CfnDeploymentGroup.AlarmProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDeploymentGroup.AlarmConfigurationProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-enabled
         * @external
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnDeploymentGroup.AlarmConfigurationProperty.IgnorePollAlarmFailure`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-ignorepollalarmfailure
         * @external
         */
        readonly ignorePollAlarmFailure?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::CodeDeploy::DeploymentGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html
 * @external
 * @cloudformationResource AWS::CodeDeploy::DeploymentGroup
 */
export declare namespace CfnDeploymentGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html
     * @external
     */
    interface AutoRollbackConfigurationProperty {
        /**
         * `CfnDeploymentGroup.AutoRollbackConfigurationProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-enabled
         * @external
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnDeploymentGroup.AutoRollbackConfigurationProperty.Events`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-events
         * @external
         */
        readonly events?: string[];
    }
}
/**
 * A CloudFormation `AWS::CodeDeploy::DeploymentGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html
 * @external
 * @cloudformationResource AWS::CodeDeploy::DeploymentGroup
 */
export declare namespace CfnDeploymentGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html
     * @external
     */
    interface DeploymentProperty {
        /**
         * `CfnDeploymentGroup.DeploymentProperty.Description`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-description
         * @external
         */
        readonly description?: string;
        /**
         * `CfnDeploymentGroup.DeploymentProperty.IgnoreApplicationStopFailures`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-ignoreapplicationstopfailures
         * @external
         */
        readonly ignoreApplicationStopFailures?: boolean | cdk.IResolvable;
        /**
         * `CfnDeploymentGroup.DeploymentProperty.Revision`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision
         * @external
         */
        readonly revision: CfnDeploymentGroup.RevisionLocationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::CodeDeploy::DeploymentGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html
 * @external
 * @cloudformationResource AWS::CodeDeploy::DeploymentGroup
 */
export declare namespace CfnDeploymentGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html
     * @external
     */
    interface DeploymentStyleProperty {
        /**
         * `CfnDeploymentGroup.DeploymentStyleProperty.DeploymentOption`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymentoption
         * @external
         */
        readonly deploymentOption?: string;
        /**
         * `CfnDeploymentGroup.DeploymentStyleProperty.DeploymentType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymenttype
         * @external
         */
        readonly deploymentType?: string;
    }
}
/**
 * A CloudFormation `AWS::CodeDeploy::DeploymentGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html
 * @external
 * @cloudformationResource AWS::CodeDeploy::DeploymentGroup
 */
export declare namespace CfnDeploymentGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilter.html
     * @external
     */
    interface EC2TagFilterProperty {
        /**
         * `CfnDeploymentGroup.EC2TagFilterProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilter.html#cfn-codedeploy-deploymentgroup-ec2tagfilter-key
         * @external
         */
        readonly key?: string;
        /**
         * `CfnDeploymentGroup.EC2TagFilterProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilter.html#cfn-codedeploy-deploymentgroup-ec2tagfilter-type
         * @external
         */
        readonly type?: string;
        /**
         * `CfnDeploymentGroup.EC2TagFilterProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilter.html#cfn-codedeploy-deploymentgroup-ec2tagfilter-value
         * @external
         */
        readonly value?: string;
    }
}
/**
 * A CloudFormation `AWS::CodeDeploy::DeploymentGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html
 * @external
 * @cloudformationResource AWS::CodeDeploy::DeploymentGroup
 */
export declare namespace CfnDeploymentGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagset.html
     * @external
     */
    interface EC2TagSetProperty {
        /**
         * `CfnDeploymentGroup.EC2TagSetProperty.Ec2TagSetList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagset.html#cfn-codedeploy-deploymentgroup-ec2tagset-ec2tagsetlist
         * @external
         */
        readonly ec2TagSetList?: Array<CfnDeploymentGroup.EC2TagSetListObjectProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::CodeDeploy::DeploymentGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html
 * @external
 * @cloudformationResource AWS::CodeDeploy::DeploymentGroup
 */
export declare namespace CfnDeploymentGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagsetlistobject.html
     * @external
     */
    interface EC2TagSetListObjectProperty {
        /**
         * `CfnDeploymentGroup.EC2TagSetListObjectProperty.Ec2TagGroup`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagsetlistobject.html#cfn-codedeploy-deploymentgroup-ec2tagsetlistobject-ec2taggroup
         * @external
         */
        readonly ec2TagGroup?: Array<CfnDeploymentGroup.EC2TagFilterProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::CodeDeploy::DeploymentGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html
 * @external
 * @cloudformationResource AWS::CodeDeploy::DeploymentGroup
 */
export declare namespace CfnDeploymentGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-elbinfo.html
     * @external
     */
    interface ELBInfoProperty {
        /**
         * `CfnDeploymentGroup.ELBInfoProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-elbinfo.html#cfn-codedeploy-deploymentgroup-elbinfo-name
         * @external
         */
        readonly name?: string;
    }
}
/**
 * A CloudFormation `AWS::CodeDeploy::DeploymentGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html
 * @external
 * @cloudformationResource AWS::CodeDeploy::DeploymentGroup
 */
export declare namespace CfnDeploymentGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html
     * @external
     */
    interface GitHubLocationProperty {
        /**
         * `CfnDeploymentGroup.GitHubLocationProperty.CommitId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-commitid
         * @external
         */
        readonly commitId: string;
        /**
         * `CfnDeploymentGroup.GitHubLocationProperty.Repository`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-repository
         * @external
         */
        readonly repository: string;
    }
}
/**
 * A CloudFormation `AWS::CodeDeploy::DeploymentGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html
 * @external
 * @cloudformationResource AWS::CodeDeploy::DeploymentGroup
 */
export declare namespace CfnDeploymentGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html
     * @external
     */
    interface LoadBalancerInfoProperty {
        /**
         * `CfnDeploymentGroup.LoadBalancerInfoProperty.ElbInfoList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-elbinfolist
         * @external
         */
        readonly elbInfoList?: Array<CfnDeploymentGroup.ELBInfoProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDeploymentGroup.LoadBalancerInfoProperty.TargetGroupInfoList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-targetgroupinfolist
         * @external
         */
        readonly targetGroupInfoList?: Array<CfnDeploymentGroup.TargetGroupInfoProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::CodeDeploy::DeploymentGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html
 * @external
 * @cloudformationResource AWS::CodeDeploy::DeploymentGroup
 */
export declare namespace CfnDeploymentGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisestagset.html
     * @external
     */
    interface OnPremisesTagSetProperty {
        /**
         * `CfnDeploymentGroup.OnPremisesTagSetProperty.OnPremisesTagSetList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisestagset.html#cfn-codedeploy-deploymentgroup-onpremisestagset-onpremisestagsetlist
         * @external
         */
        readonly onPremisesTagSetList?: Array<CfnDeploymentGroup.OnPremisesTagSetListObjectProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::CodeDeploy::DeploymentGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html
 * @external
 * @cloudformationResource AWS::CodeDeploy::DeploymentGroup
 */
export declare namespace CfnDeploymentGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisestagsetlistobject.html
     * @external
     */
    interface OnPremisesTagSetListObjectProperty {
        /**
         * `CfnDeploymentGroup.OnPremisesTagSetListObjectProperty.OnPremisesTagGroup`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisestagsetlistobject.html#cfn-codedeploy-deploymentgroup-onpremisestagsetlistobject-onpremisestaggroup
         * @external
         */
        readonly onPremisesTagGroup?: Array<CfnDeploymentGroup.TagFilterProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::CodeDeploy::DeploymentGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html
 * @external
 * @cloudformationResource AWS::CodeDeploy::DeploymentGroup
 */
export declare namespace CfnDeploymentGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html
     * @external
     */
    interface RevisionLocationProperty {
        /**
         * `CfnDeploymentGroup.RevisionLocationProperty.GitHubLocation`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation
         * @external
         */
        readonly gitHubLocation?: CfnDeploymentGroup.GitHubLocationProperty | cdk.IResolvable;
        /**
         * `CfnDeploymentGroup.RevisionLocationProperty.RevisionType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-revisiontype
         * @external
         */
        readonly revisionType?: string;
        /**
         * `CfnDeploymentGroup.RevisionLocationProperty.S3Location`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location
         * @external
         */
        readonly s3Location?: CfnDeploymentGroup.S3LocationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::CodeDeploy::DeploymentGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html
 * @external
 * @cloudformationResource AWS::CodeDeploy::DeploymentGroup
 */
export declare namespace CfnDeploymentGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html
     * @external
     */
    interface S3LocationProperty {
        /**
         * `CfnDeploymentGroup.S3LocationProperty.Bucket`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bucket
         * @external
         */
        readonly bucket: string;
        /**
         * `CfnDeploymentGroup.S3LocationProperty.BundleType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bundletype
         * @external
         */
        readonly bundleType?: string;
        /**
         * `CfnDeploymentGroup.S3LocationProperty.ETag`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-etag
         * @external
         */
        readonly eTag?: string;
        /**
         * `CfnDeploymentGroup.S3LocationProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-key
         * @external
         */
        readonly key: string;
        /**
         * `CfnDeploymentGroup.S3LocationProperty.Version`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-value
         * @external
         */
        readonly version?: string;
    }
}
/**
 * A CloudFormation `AWS::CodeDeploy::DeploymentGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html
 * @external
 * @cloudformationResource AWS::CodeDeploy::DeploymentGroup
 */
export declare namespace CfnDeploymentGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-tagfilter.html
     * @external
     */
    interface TagFilterProperty {
        /**
         * `CfnDeploymentGroup.TagFilterProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-tagfilter.html#cfn-codedeploy-deploymentgroup-tagfilter-key
         * @external
         */
        readonly key?: string;
        /**
         * `CfnDeploymentGroup.TagFilterProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-tagfilter.html#cfn-codedeploy-deploymentgroup-tagfilter-type
         * @external
         */
        readonly type?: string;
        /**
         * `CfnDeploymentGroup.TagFilterProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-tagfilter.html#cfn-codedeploy-deploymentgroup-tagfilter-value
         * @external
         */
        readonly value?: string;
    }
}
/**
 * A CloudFormation `AWS::CodeDeploy::DeploymentGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html
 * @external
 * @cloudformationResource AWS::CodeDeploy::DeploymentGroup
 */
export declare namespace CfnDeploymentGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-targetgroupinfo.html
     * @external
     */
    interface TargetGroupInfoProperty {
        /**
         * `CfnDeploymentGroup.TargetGroupInfoProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-targetgroupinfo.html#cfn-codedeploy-deploymentgroup-targetgroupinfo-name
         * @external
         */
        readonly name?: string;
    }
}
/**
 * A CloudFormation `AWS::CodeDeploy::DeploymentGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html
 * @external
 * @cloudformationResource AWS::CodeDeploy::DeploymentGroup
 */
export declare namespace CfnDeploymentGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html
     * @external
     */
    interface TriggerConfigProperty {
        /**
         * `CfnDeploymentGroup.TriggerConfigProperty.TriggerEvents`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggerevents
         * @external
         */
        readonly triggerEvents?: string[];
        /**
         * `CfnDeploymentGroup.TriggerConfigProperty.TriggerName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggername
         * @external
         */
        readonly triggerName?: string;
        /**
         * `CfnDeploymentGroup.TriggerConfigProperty.TriggerTargetArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggertargetarn
         * @external
         */
        readonly triggerTargetArn?: string;
    }
}
