import * as events from "../../aws-events";
import * as iam from "../../aws-iam";
import { IResource, Resource } from "../../core";
import { Construct } from 'constructs';
/**
 * @experimental
 */
export interface IRepository extends IResource {
    /**
     * (experimental) The ARN of this Repository.
     *
     * @experimental
     * @attribute true
     */
    readonly repositoryArn: string;
    /**
     * (experimental) The human-visible name of this Repository.
     *
     * @experimental
     * @attribute true
     */
    readonly repositoryName: string;
    /**
     * (experimental) The HTTP clone URL.
     *
     * @experimental
     * @attribute true
     */
    readonly repositoryCloneUrlHttp: string;
    /**
     * (experimental) The SSH clone URL.
     *
     * @experimental
     * @attribute true
     */
    readonly repositoryCloneUrlSsh: string;
    /**
     * (experimental) Defines a CloudWatch event rule which triggers for repository events.
     *
     * Use
     * `rule.addEventPattern(pattern)` to specify a filter.
     *
     * @experimental
     */
    onEvent(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines a CloudWatch event rule which triggers when a "CodeCommit Repository State Change" event occurs.
     *
     * @experimental
     */
    onStateChange(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines a CloudWatch event rule which triggers when a reference is created (i.e. a new branch/tag is created) to the repository.
     *
     * @experimental
     */
    onReferenceCreated(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines a CloudWatch event rule which triggers when a reference is updated (i.e. a commit is pushed to an existing or new branch) from the repository.
     *
     * @experimental
     */
    onReferenceUpdated(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines a CloudWatch event rule which triggers when a reference is delete (i.e. a branch/tag is deleted) from the repository.
     *
     * @experimental
     */
    onReferenceDeleted(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines a CloudWatch event rule which triggers when a pull request state is changed.
     *
     * @experimental
     */
    onPullRequestStateChange(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines a CloudWatch event rule which triggers when a comment is made on a pull request.
     *
     * @experimental
     */
    onCommentOnPullRequest(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines a CloudWatch event rule which triggers when a comment is made on a commit.
     *
     * @experimental
     */
    onCommentOnCommit(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines a CloudWatch event rule which triggers when a commit is pushed to a branch.
     *
     * @experimental
     */
    onCommit(id: string, options?: OnCommitOptions): events.Rule;
    /**
     * (experimental) Grant the given principal identity permissions to perform the actions on this repository.
     *
     * @experimental
     */
    grant(grantee: iam.IGrantable, ...actions: string[]): iam.Grant;
    /**
     * (experimental) Grant the given identity permissions to pull this repository.
     *
     * @experimental
     */
    grantPull(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant the given identity permissions to pull and push this repository.
     *
     * @experimental
     */
    grantPullPush(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant the given identity permissions to read this repository.
     *
     * @experimental
     */
    grantRead(grantee: iam.IGrantable): iam.Grant;
}
/**
 * (experimental) Options for the onCommit() method.
 *
 * @experimental
 */
export interface OnCommitOptions extends events.OnEventOptions {
    /**
     * (experimental) The branch to monitor.
     *
     * @default - All branches
     * @experimental
     */
    readonly branches?: string[];
}
/**
 * Represents a reference to a CodeCommit Repository.
 *
 * If you want to create a new Repository managed alongside your CDK code,
 * use the {@link Repository} class.
 *
 * If you want to reference an already existing Repository,
 * use the {@link Repository.import} method.
 */
declare abstract class RepositoryBase extends Resource implements IRepository {
    /** The ARN of this Repository. */
    abstract readonly repositoryArn: string;
    /** The human-visible name of this Repository. */
    abstract readonly repositoryName: string;
    /** The HTTP clone URL */
    abstract readonly repositoryCloneUrlHttp: string;
    /** The SSH clone URL */
    abstract readonly repositoryCloneUrlSsh: string;
    /**
     * (experimental) Defines a CloudWatch event rule which triggers for repository events.
     *
     * Use
     * `rule.addEventPattern(pattern)` to specify a filter.
     *
     * @experimental
     */
    onEvent(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines a CloudWatch event rule which triggers when a "CodeCommit Repository State Change" event occurs.
     *
     * @experimental
     */
    onStateChange(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines a CloudWatch event rule which triggers when a reference is created (i.e. a new branch/tag is created) to the repository.
     *
     * @experimental
     */
    onReferenceCreated(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines a CloudWatch event rule which triggers when a reference is updated (i.e. a commit is pushed to an existing or new branch) from the repository.
     *
     * @experimental
     */
    onReferenceUpdated(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines a CloudWatch event rule which triggers when a reference is delete (i.e. a branch/tag is deleted) from the repository.
     *
     * @experimental
     */
    onReferenceDeleted(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines a CloudWatch event rule which triggers when a pull request state is changed.
     *
     * @experimental
     */
    onPullRequestStateChange(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines a CloudWatch event rule which triggers when a comment is made on a pull request.
     *
     * @experimental
     */
    onCommentOnPullRequest(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines a CloudWatch event rule which triggers when a comment is made on a commit.
     *
     * @experimental
     */
    onCommentOnCommit(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines a CloudWatch event rule which triggers when a commit is pushed to a branch.
     *
     * @experimental
     */
    onCommit(id: string, options?: OnCommitOptions): events.Rule;
    /**
     * (experimental) Grant the given principal identity permissions to perform the actions on this repository.
     *
     * @experimental
     */
    grant(grantee: iam.IGrantable, ...actions: string[]): iam.Grant;
    /**
     * (experimental) Grant the given identity permissions to pull this repository.
     *
     * @experimental
     */
    grantPull(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant the given identity permissions to pull and push this repository.
     *
     * @experimental
     */
    grantPullPush(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant the given identity permissions to read this repository.
     *
     * @experimental
     */
    grantRead(grantee: iam.IGrantable): iam.Grant;
}
/**
 * @experimental
 */
export interface RepositoryProps {
    /**
     * (experimental) Name of the repository.
     *
     * This property is required for all CodeCommit repositories.
     *
     * @experimental
     */
    readonly repositoryName: string;
    /**
     * (experimental) A description of the repository.
     *
     * Use the description to identify the
     * purpose of the repository.
     *
     * @default - No description.
     * @experimental
     */
    readonly description?: string;
}
/**
 * (experimental) Provides a CodeCommit Repository.
 *
 * @experimental
 */
export declare class Repository extends RepositoryBase {
    /**
     * (experimental) Imports a codecommit repository.
     *
     * @param repositoryArn (e.g. `arn:aws:codecommit:us-east-1:123456789012:MyDemoRepo`).
     * @experimental
     */
    static fromRepositoryArn(scope: Construct, id: string, repositoryArn: string): IRepository;
    /**
     * @experimental
     */
    static fromRepositoryName(scope: Construct, id: string, repositoryName: string): IRepository;
    private static makeCloneUrl;
    private static arnForLocalRepository;
    /**
     * (experimental) The ARN of this Repository.
     *
     * @experimental
     */
    readonly repositoryArn: string;
    /**
     * (experimental) The human-visible name of this Repository.
     *
     * @experimental
     */
    readonly repositoryName: string;
    private readonly repository;
    private readonly triggers;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: RepositoryProps);
    /**
     * (experimental) The HTTP clone URL.
     *
     * @experimental
     */
    get repositoryCloneUrlHttp(): string;
    /**
     * (experimental) The SSH clone URL.
     *
     * @experimental
     */
    get repositoryCloneUrlSsh(): string;
    /**
     * (experimental) Create a trigger to notify another service to run actions on repository events.
     *
     * @param arn Arn of the resource that repository events will notify.
     * @param options Trigger options to run actions.
     * @experimental
     */
    notify(arn: string, options?: RepositoryTriggerOptions): Repository;
}
/**
 * (experimental) Creates for a repository trigger to an SNS topic or Lambda function.
 *
 * @experimental
 */
export interface RepositoryTriggerOptions {
    /**
     * (experimental) A name for the trigger.Triggers on a repository must have unique names.
     *
     * @experimental
     */
    readonly name?: string;
    /**
     * (experimental) The repository events for which AWS CodeCommit sends information to the target, which you specified in the DestinationArn property.If you don't specify events, the trigger runs for all repository events.
     *
     * @experimental
     */
    readonly events?: RepositoryEventTrigger[];
    /**
     * (experimental) The names of the branches in the AWS CodeCommit repository that contain events that you want to include in the trigger.
     *
     * If you don't specify at
     * least one branch, the trigger applies to all branches.
     *
     * @experimental
     */
    readonly branches?: string[];
    /**
     * (experimental) When an event is triggered, additional information that AWS CodeCommit includes when it sends information to the target.
     *
     * @experimental
     */
    readonly customData?: string;
}
/**
 * (experimental) Repository events that will cause the trigger to run actions in another service.
 *
 * @experimental
 */
export declare enum RepositoryEventTrigger {
    /**
     * @experimental
     */
    ALL = "all",
    /**
     * @experimental
     */
    UPDATE_REF = "updateReference",
    /**
     * @experimental
     */
    CREATE_REF = "createReference",
    /**
     * @experimental
     */
    DELETE_REF = "deleteReference"
}
export {};
