"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.reportGroupArnComponents = exports.renderReportGroupArn = void 0;
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
// this file contains a bunch of functions shared
// between Project and ResourceGroup,
// which we don't want to make part of the public API of this module
function renderReportGroupArn(scope, reportGroupName) {
    return cdk.Stack.of(scope).formatArn(reportGroupArnComponents(reportGroupName));
}
exports.renderReportGroupArn = renderReportGroupArn;
function reportGroupArnComponents(reportGroupName) {
    return {
        service: 'codebuild',
        resource: 'report-group',
        resourceName: reportGroupName,
    };
}
exports.reportGroupArnComponents = reportGroupArnComponents;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVwb3J0LWdyb3VwLXV0aWxzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsicmVwb3J0LWdyb3VwLXV0aWxzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLGtDQUFrQyxDQUFDLGdEQUFnRDtBQUVuRixpREFBaUQ7QUFDakQscUNBQXFDO0FBQ3JDLG9FQUFvRTtBQUNwRSxTQUFnQixvQkFBb0IsQ0FBQyxLQUFnQixFQUFFLGVBQXVCO0lBQzFFLE9BQU8sR0FBRyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDLENBQUMsU0FBUyxDQUFDLHdCQUF3QixDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUM7QUFDcEYsQ0FBQztBQUZELG9EQUVDO0FBQ0QsU0FBZ0Isd0JBQXdCLENBQUMsZUFBdUI7SUFDNUQsT0FBTztRQUNILE9BQU8sRUFBRSxXQUFXO1FBQ3BCLFFBQVEsRUFBRSxjQUFjO1FBQ3hCLFlBQVksRUFBRSxlQUFlO0tBQ2hDLENBQUM7QUFDTixDQUFDO0FBTkQsNERBTUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjZGsgZnJvbSBcIi4uLy4uL2NvcmVcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2NvcmUnXG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbi8vIHRoaXMgZmlsZSBjb250YWlucyBhIGJ1bmNoIG9mIGZ1bmN0aW9ucyBzaGFyZWRcbi8vIGJldHdlZW4gUHJvamVjdCBhbmQgUmVzb3VyY2VHcm91cCxcbi8vIHdoaWNoIHdlIGRvbid0IHdhbnQgdG8gbWFrZSBwYXJ0IG9mIHRoZSBwdWJsaWMgQVBJIG9mIHRoaXMgbW9kdWxlXG5leHBvcnQgZnVuY3Rpb24gcmVuZGVyUmVwb3J0R3JvdXBBcm4oc2NvcGU6IENvbnN0cnVjdCwgcmVwb3J0R3JvdXBOYW1lOiBzdHJpbmcpOiBzdHJpbmcge1xuICAgIHJldHVybiBjZGsuU3RhY2sub2Yoc2NvcGUpLmZvcm1hdEFybihyZXBvcnRHcm91cEFybkNvbXBvbmVudHMocmVwb3J0R3JvdXBOYW1lKSk7XG59XG5leHBvcnQgZnVuY3Rpb24gcmVwb3J0R3JvdXBBcm5Db21wb25lbnRzKHJlcG9ydEdyb3VwTmFtZTogc3RyaW5nKTogY2RrLkFybkNvbXBvbmVudHMge1xuICAgIHJldHVybiB7XG4gICAgICAgIHNlcnZpY2U6ICdjb2RlYnVpbGQnLFxuICAgICAgICByZXNvdXJjZTogJ3JlcG9ydC1ncm91cCcsXG4gICAgICAgIHJlc291cmNlTmFtZTogcmVwb3J0R3JvdXBOYW1lLFxuICAgIH07XG59XG4iXX0=