import * as core from "../../core";
import { BuildSpec } from './build-spec';
import { BuildEnvironment, BuildImageBindOptions, BuildImageConfig, ComputeType, IBindableBuildImage, IBuildImage, ImagePullPrincipalType, IProject } from './project';
/**
 * (experimental) A CodeBuild GPU image running Linux.
 *
 * This class has public constants that represent the most popular GPU images from AWS Deep Learning Containers.
 *
 * @see https://aws.amazon.com/releasenotes/available-deep-learning-containers-images
 * @experimental
 */
export declare class LinuxGpuBuildImage implements IBindableBuildImage {
    private readonly repositoryName;
    private readonly account;
    /**
     * (experimental) Tensorflow 1.14.0 GPU image from AWS Deep Learning Containers.
     *
     * @experimental
     */
    static readonly DLC_TENSORFLOW_1_14_0: IBuildImage;
    /**
     * (experimental) Tensorflow 1.15.0 GPU image from AWS Deep Learning Containers.
     *
     * @experimental
     */
    static readonly DLC_TENSORFLOW_1_15_0: IBuildImage;
    /**
     * (experimental) Tensorflow 1.15.2 GPU training image from AWS Deep Learning Containers.
     *
     * @experimental
     */
    static readonly DLC_TENSORFLOW_1_15_2_TRAINING: IBuildImage;
    /**
     * (experimental) Tensorflow 1.15.2 GPU inference image from AWS Deep Learning Containers.
     *
     * @experimental
     */
    static readonly DLC_TENSORFLOW_1_15_2_INFERENCE: IBuildImage;
    /**
     * (experimental) Tensorflow 2.0.0 GPU image from AWS Deep Learning Containers.
     *
     * @experimental
     */
    static readonly DLC_TENSORFLOW_2_0_0: IBuildImage;
    /**
     * (experimental) Tensorflow 2.0.1 GPU image from AWS Deep Learning Containers.
     *
     * @experimental
     */
    static readonly DLC_TENSORFLOW_2_0_1: IBuildImage;
    /**
     * (experimental) Tensorflow 2.1.0 GPU training image from AWS Deep Learning Containers.
     *
     * @experimental
     */
    static readonly DLC_TENSORFLOW_2_1_0_TRAINING: IBuildImage;
    /**
     * (experimental) Tensorflow 2.1.0 GPU inference image from AWS Deep Learning Containers.
     *
     * @experimental
     */
    static readonly DLC_TENSORFLOW_2_1_0_INFERENCE: IBuildImage;
    /**
     * (experimental) Tensorflow 2.2.0 GPU training image from AWS Deep Learning Containers.
     *
     * @experimental
     */
    static readonly DLC_TENSORFLOW_2_2_0_TRAINING: IBuildImage;
    /**
     * (experimental) PyTorch 1.2.0 GPU image from AWS Deep Learning Containers.
     *
     * @experimental
     */
    static readonly DLC_PYTORCH_1_2_0: IBuildImage;
    /**
     * (experimental) PyTorch 1.3.1 GPU image from AWS Deep Learning Containers.
     *
     * @experimental
     */
    static readonly DLC_PYTORCH_1_3_1: IBuildImage;
    /**
     * (experimental) PyTorch 1.4.0 GPU training image from AWS Deep Learning Containers.
     *
     * @experimental
     */
    static readonly DLC_PYTORCH_1_4_0_TRAINING: IBuildImage;
    /**
     * (experimental) PyTorch 1.4.0 GPU inference image from AWS Deep Learning Containers.
     *
     * @experimental
     */
    static readonly DLC_PYTORCH_1_4_0_INFERENCE: IBuildImage;
    /**
     * (experimental) PyTorch 1.5.0 GPU training image from AWS Deep Learning Containers.
     *
     * @experimental
     */
    static readonly DLC_PYTORCH_1_5_0_TRAINING: IBuildImage;
    /**
     * (experimental) PyTorch 1.5.0 GPU inference image from AWS Deep Learning Containers.
     *
     * @experimental
     */
    static readonly DLC_PYTORCH_1_5_0_INFERENCE: IBuildImage;
    /**
     * (experimental) MXNet 1.4.1 GPU image from AWS Deep Learning Containers.
     *
     * @experimental
     */
    static readonly DLC_MXNET_1_4_1: IBuildImage;
    /**
     * (experimental) MXNet 1.6.0 GPU image from AWS Deep Learning Containers.
     *
     * @experimental
     */
    static readonly DLC_MXNET_1_6_0: IBuildImage;
    /**
     * (experimental) Returns a Linux GPU build image from AWS Deep Learning Containers.
     *
     * @param repositoryName the name of the repository, for example "pytorch-inference".
     * @param tag the tag of the image, for example "1.5.0-gpu-py36-cu101-ubuntu16.04".
     * @param account the AWS account ID where the DLC repository for this region is hosted in.
     * @see https://aws.amazon.com/releasenotes/available-deep-learning-containers-images
     * @experimental
     */
    static awsDeepLearningContainersImage(repositoryName: string, tag: string, account?: string): IBuildImage;
    /**
     * (experimental) The type of build environment.
     *
     * @experimental
     */
    readonly type = "LINUX_GPU_CONTAINER";
    /**
     * (experimental) The default {@link ComputeType} to use with this image, if one was not specified in {@link BuildEnvironment#computeType} explicitly.
     *
     * @experimental
     */
    readonly defaultComputeType = ComputeType.LARGE;
    /**
     * (experimental) The Docker image identifier that the build environment uses.
     *
     * @experimental
     */
    readonly imageId: string;
    /**
     * (experimental) The type of principal that CodeBuild will use to pull this build Docker image.
     *
     * @experimental
     */
    readonly imagePullPrincipalType?: ImagePullPrincipalType;
    private readonly accountExpression;
    private constructor();
    /**
     * (experimental) Function that allows the build image access to the construct tree.
     *
     * @experimental
     */
    bind(scope: core.Construct, project: IProject, _options: BuildImageBindOptions): BuildImageConfig;
    /**
     * (experimental) Allows the image a chance to validate whether the passed configuration is correct.
     *
     * @experimental
     */
    validate(buildEnvironment: BuildEnvironment): string[];
    /**
     * (experimental) Make a buildspec to run the indicated script.
     *
     * @experimental
     */
    runScriptBuildspec(entrypoint: string): BuildSpec;
}
