import * as s3 from "../../aws-s3";
import { CfnProject } from './codebuild.generated';
import { IProject } from './project';
import { Construct as CoreConstruct } from "../../core";
/**
 * (experimental) The type returned from {@link IArtifacts#bind}.
 *
 * @experimental
 */
export interface ArtifactsConfig {
    /**
     * (experimental) The low-level CloudFormation artifacts property.
     *
     * @experimental
     */
    readonly artifactsProperty: CfnProject.ArtifactsProperty;
}
/**
 * (experimental) The abstract interface of a CodeBuild build output.
 *
 * Implemented by {@link Artifacts}.
 *
 * @experimental
 */
export interface IArtifacts {
    /**
     * (experimental) The artifact identifier.
     *
     * This property is required on secondary artifacts.
     *
     * @experimental
     */
    readonly identifier?: string;
    /**
     * (experimental) The CodeBuild type of this artifact.
     *
     * @experimental
     */
    readonly type: string;
    /**
     * (experimental) Callback when an Artifacts class is used in a CodeBuild Project.
     *
     * @param scope a root Construct that allows creating new Constructs.
     * @param project the Project this Artifacts is used in.
     * @experimental
     */
    bind(scope: CoreConstruct, project: IProject): ArtifactsConfig;
}
/**
 * (experimental) Properties common to all Artifacts classes.
 *
 * @experimental
 */
export interface ArtifactsProps {
    /**
     * (experimental) The artifact identifier.
     *
     * This property is required on secondary artifacts.
     *
     * @experimental
     */
    readonly identifier?: string;
}
/**
 * (experimental) Artifacts definition for a CodeBuild Project.
 *
 * @experimental
 */
export declare abstract class Artifacts implements IArtifacts {
    /**
     * @experimental
     */
    static s3(props: S3ArtifactsProps): IArtifacts;
    /**
     * (experimental) The artifact identifier.
     *
     * This property is required on secondary artifacts.
     *
     * @experimental
     */
    readonly identifier?: string;
    /**
     * (experimental) The CodeBuild type of this artifact.
     *
     * @experimental
     */
    abstract readonly type: string;
    /**
     * @experimental
     */
    protected constructor(props: ArtifactsProps);
    /**
     * (experimental) Callback when an Artifacts class is used in a CodeBuild Project.
     *
     * @experimental
     */
    bind(_scope: CoreConstruct, _project: IProject): ArtifactsConfig;
}
/**
 * (experimental) Construction properties for {@link S3Artifacts}.
 *
 * @experimental
 */
export interface S3ArtifactsProps extends ArtifactsProps {
    /**
     * (experimental) The name of the output bucket.
     *
     * @experimental
     */
    readonly bucket: s3.IBucket;
    /**
     * (experimental) The path inside of the bucket for the build output .zip file or folder. If a value is not specified, then build output will be stored at the root of the bucket (or under the <build-id> directory if `includeBuildId` is set to true).
     *
     * @default the root of the bucket
     * @experimental
     */
    readonly path?: string;
    /**
     * (experimental) The name of the build output ZIP file or folder inside the bucket.
     *
     * The full S3 object key will be "<path>/<build-id>/<name>" or
     * "<path>/<name>" depending on whether `includeBuildId` is set to true.
     *
     * If not set, `overrideArtifactName` will be set and the name from the
     * buildspec will be used instead.
     *
     * @default undefined, and use the name from the buildspec
     * @experimental
     */
    readonly name?: string;
    /**
     * (experimental) Indicates if the build ID should be included in the path.
     *
     * If this is set to true,
     * then the build artifact will be stored in "<path>/<build-id>/<name>".
     *
     * @default true
     * @experimental
     */
    readonly includeBuildId?: boolean;
    /**
     * (experimental) If this is true, all build output will be packaged into a single .zip file. Otherwise, all files will be uploaded to <path>/<name>.
     *
     * @default true - files will be archived
     * @experimental
     */
    readonly packageZip?: boolean;
    /**
     * (experimental) If this is false, build output will not be encrypted.
     *
     * This is useful if the artifact to publish a static website or sharing content with others
     *
     * @default true - output will be encrypted
     * @experimental
     */
    readonly encryption?: boolean;
}
