/**
 * The width of the grid we're filling
 */
export declare const GRID_WIDTH = 24;
/**
 * (experimental) A single dashboard widget.
 *
 * @experimental
 */
export interface IWidget {
    /**
     * (experimental) The amount of horizontal grid units the widget will take up.
     *
     * @experimental
     */
    readonly width: number;
    /**
     * (experimental) The amount of vertical grid units the widget will take up.
     *
     * @experimental
     */
    readonly height: number;
    /**
     * (experimental) Place the widget at a given position.
     *
     * @experimental
     */
    position(x: number, y: number): void;
    /**
     * (experimental) Return the widget JSON for use in the dashboard.
     *
     * @experimental
     */
    toJson(): any[];
}
/**
 * (experimental) A real CloudWatch widget that has its own fixed size and remembers its position.
 *
 * This is in contrast to other widgets which exist for layout purposes.
 *
 * @experimental
 */
export declare abstract class ConcreteWidget implements IWidget {
    /**
     * (experimental) The amount of horizontal grid units the widget will take up.
     *
     * @experimental
     */
    readonly width: number;
    /**
     * (experimental) The amount of vertical grid units the widget will take up.
     *
     * @experimental
     */
    readonly height: number;
    /**
     * @experimental
     */
    protected x?: number;
    /**
     * @experimental
     */
    protected y?: number;
    /**
     * @experimental
     */
    constructor(width: number, height: number);
    /**
     * (experimental) Place the widget at a given position.
     *
     * @experimental
     */
    position(x: number, y: number): void;
    /**
     * (experimental) Return the widget JSON for use in the dashboard.
     *
     * @experimental
     */
    abstract toJson(): any[];
}
