import { Duration } from "../../core";
/**
 * (experimental) Interface for metrics.
 *
 * @experimental
 */
export interface IMetric {
    /**
     * (experimental) Inspect the details of the metric object.
     *
     * @experimental
     */
    toMetricConfig(): MetricConfig;
    /**
     * (deprecated) Turn this metric object into an alarm configuration.
     *
     * @deprecated Use `toMetricsConfig()` instead.
     */
    toAlarmConfig(): MetricAlarmConfig;
    /**
     * (deprecated) Turn this metric object into a graph configuration.
     *
     * @deprecated Use `toMetricsConfig()` instead.
     */
    toGraphConfig(): MetricGraphConfig;
}
/**
 * (experimental) Metric dimension.
 *
 * @experimental
 */
export interface Dimension {
    /**
     * (experimental) Name of the dimension.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) Value of the dimension.
     *
     * @experimental
     */
    readonly value: any;
}
/**
 * (experimental) Statistic to use over the aggregation period.
 *
 * @experimental
 */
export declare enum Statistic {
    /**
     * (experimental) The count (number) of data points used for the statistical calculation.
     *
     * @experimental
     */
    SAMPLE_COUNT = "SampleCount",
    /**
     * (experimental) The value of Sum / SampleCount during the specified period.
     *
     * @experimental
     */
    AVERAGE = "Average",
    /**
     * (experimental) All values submitted for the matching metric added together.
     *
     * This statistic can be useful for determining the total volume of a metric.
     *
     * @experimental
     */
    SUM = "Sum",
    /**
     * (experimental) The lowest value observed during the specified period.
     *
     * You can use this value to determine low volumes of activity for your application.
     *
     * @experimental
     */
    MINIMUM = "Minimum",
    /**
     * (experimental) The highest value observed during the specified period.
     *
     * You can use this value to determine high volumes of activity for your application.
     *
     * @experimental
     */
    MAXIMUM = "Maximum"
}
/**
 * (experimental) Unit for metric.
 *
 * @experimental
 */
export declare enum Unit {
    /**
     * (experimental) Seconds.
     *
     * @experimental
     */
    SECONDS = "Seconds",
    /**
     * (experimental) Microseconds.
     *
     * @experimental
     */
    MICROSECONDS = "Microseconds",
    /**
     * (experimental) Milliseconds.
     *
     * @experimental
     */
    MILLISECONDS = "Milliseconds",
    /**
     * (experimental) Bytes.
     *
     * @experimental
     */
    BYTES = "Bytes",
    /**
     * (experimental) Kilobytes.
     *
     * @experimental
     */
    KILOBYTES = "Kilobytes",
    /**
     * (experimental) Megabytes.
     *
     * @experimental
     */
    MEGABYTES = "Megabytes",
    /**
     * (experimental) Gigabytes.
     *
     * @experimental
     */
    GIGABYTES = "Gigabytes",
    /**
     * (experimental) Terabytes.
     *
     * @experimental
     */
    TERABYTES = "Terabytes",
    /**
     * (experimental) Bits.
     *
     * @experimental
     */
    BITS = "Bits",
    /**
     * (experimental) Kilobits.
     *
     * @experimental
     */
    KILOBITS = "Kilobits",
    /**
     * (experimental) Megabits.
     *
     * @experimental
     */
    MEGABITS = "Megabits",
    /**
     * (experimental) Gigabits.
     *
     * @experimental
     */
    GIGABITS = "Gigabits",
    /**
     * (experimental) Terabits.
     *
     * @experimental
     */
    TERABITS = "Terabits",
    /**
     * (experimental) Percent.
     *
     * @experimental
     */
    PERCENT = "Percent",
    /**
     * (experimental) Count.
     *
     * @experimental
     */
    COUNT = "Count",
    /**
     * (experimental) Bytes/second (B/s).
     *
     * @experimental
     */
    BYTES_PER_SECOND = "Bytes/Second",
    /**
     * (experimental) Kilobytes/second (kB/s).
     *
     * @experimental
     */
    KILOBYTES_PER_SECOND = "Kilobytes/Second",
    /**
     * (experimental) Megabytes/second (MB/s).
     *
     * @experimental
     */
    MEGABYTES_PER_SECOND = "Megabytes/Second",
    /**
     * (experimental) Gigabytes/second (GB/s).
     *
     * @experimental
     */
    GIGABYTES_PER_SECOND = "Gigabytes/Second",
    /**
     * (experimental) Terabytes/second (TB/s).
     *
     * @experimental
     */
    TERABYTES_PER_SECOND = "Terabytes/Second",
    /**
     * (experimental) Bits/second (b/s).
     *
     * @experimental
     */
    BITS_PER_SECOND = "Bits/Second",
    /**
     * (experimental) Kilobits/second (kb/s).
     *
     * @experimental
     */
    KILOBITS_PER_SECOND = "Kilobits/Second",
    /**
     * (experimental) Megabits/second (Mb/s).
     *
     * @experimental
     */
    MEGABITS_PER_SECOND = "Megabits/Second",
    /**
     * (experimental) Gigabits/second (Gb/s).
     *
     * @experimental
     */
    GIGABITS_PER_SECOND = "Gigabits/Second",
    /**
     * (experimental) Terabits/second (Tb/s).
     *
     * @experimental
     */
    TERABITS_PER_SECOND = "Terabits/Second",
    /**
     * (experimental) Count/second.
     *
     * @experimental
     */
    COUNT_PER_SECOND = "Count/Second",
    /**
     * (experimental) No unit.
     *
     * @experimental
     */
    NONE = "None"
}
/**
 * (experimental) Properties of a rendered metric.
 *
 * @experimental
 */
export interface MetricConfig {
    /**
     * (experimental) In case the metric represents a query, the details of the query.
     *
     * @default - None
     * @experimental
     */
    readonly metricStat?: MetricStatConfig;
    /**
     * (experimental) In case the metric is a math expression, the details of the math expression.
     *
     * @default - None
     * @experimental
     */
    readonly mathExpression?: MetricExpressionConfig;
    /**
     * (experimental) Additional properties which will be rendered if the metric is used in a dashboard.
     *
     * Examples are 'label' and 'color', but any key in here will be
     * added to dashboard graphs.
     *
     * @default - None
     * @experimental
     */
    readonly renderingProperties?: Record<string, unknown>;
}
/**
 * (experimental) Properties for a concrete metric.
 *
 * NOTE: `unit` is no longer on this object since it is only used for `Alarms`, and doesn't mean what one
 * would expect it to mean there anyway. It is most likely to be misused.
 *
 * @experimental
 */
export interface MetricStatConfig {
    /**
     * (experimental) The dimensions to apply to the alarm.
     *
     * @default []
     * @experimental
     */
    readonly dimensions?: Dimension[];
    /**
     * (experimental) Namespace of the metric.
     *
     * @experimental
     */
    readonly namespace: string;
    /**
     * (experimental) Name of the metric.
     *
     * @experimental
     */
    readonly metricName: string;
    /**
     * (experimental) How many seconds to aggregate over.
     *
     * @experimental
     */
    readonly period: Duration;
    /**
     * (experimental) Aggregation function to use (can be either simple or a percentile).
     *
     * @experimental
     */
    readonly statistic: string;
    /**
     * (experimental) Unit used to filter the metric stream.
     *
     * Only refer to datums emitted to the metric stream with the given unit and
     * ignore all others. Only useful when datums are being emitted to the same
     * metric stream under different units.
     *
     * This field has been renamed from plain `unit` to clearly communicate
     * its purpose.
     *
     * @default - Refer to all metric datums
     * @experimental
     */
    readonly unitFilter?: Unit;
    /**
     * (experimental) Region which this metric comes from.
     *
     * @default Deployment region.
     * @experimental
     */
    readonly region?: string;
    /**
     * (experimental) Account which this metric comes from.
     *
     * @default Deployment account.
     * @experimental
     */
    readonly account?: string;
}
/**
 * (experimental) Properties for a concrete metric.
 *
 * @experimental
 */
export interface MetricExpressionConfig {
    /**
     * (experimental) Math expression for the metric.
     *
     * @experimental
     */
    readonly expression: string;
    /**
     * (experimental) Metrics used in the math expression.
     *
     * @experimental
     */
    readonly usingMetrics: Record<string, IMetric>;
    /**
     * (experimental) How many seconds to aggregate over.
     *
     * @experimental
     */
    readonly period: number;
}
/**
 * (deprecated) Properties used to construct the Metric identifying part of an Alarm.
 *
 * @deprecated Replaced by MetricConfig
 */
export interface MetricAlarmConfig {
    /**
     * (deprecated) The dimensions to apply to the alarm.
     *
     * @deprecated
     */
    readonly dimensions?: Dimension[];
    /**
     * (deprecated) Namespace of the metric.
     *
     * @deprecated
     */
    readonly namespace: string;
    /**
     * (deprecated) Name of the metric.
     *
     * @deprecated
     */
    readonly metricName: string;
    /**
     * (deprecated) How many seconds to aggregate over.
     *
     * @deprecated
     */
    readonly period: number;
    /**
     * (deprecated) Simple aggregation function to use.
     *
     * @deprecated
     */
    readonly statistic?: Statistic;
    /**
     * (deprecated) Percentile aggregation function to use.
     *
     * @deprecated
     */
    readonly extendedStatistic?: string;
    /**
     * (deprecated) The unit of the alarm.
     *
     * @deprecated
     */
    readonly unit?: Unit;
}
/**
 * (deprecated) Properties used to construct the Metric identifying part of a Graph.
 *
 * @deprecated Replaced by MetricConfig
 */
export interface MetricGraphConfig {
    /**
     * (deprecated) The dimensions to apply to the alarm.
     *
     * @deprecated
     */
    readonly dimensions?: Dimension[];
    /**
     * (deprecated) Namespace of the metric.
     *
     * @deprecated
     */
    readonly namespace: string;
    /**
     * (deprecated) Name of the metric.
     *
     * @deprecated
     */
    readonly metricName: string;
    /**
     * (deprecated) Rendering properties override yAxis parameter of the widget object.
     *
     * @deprecated
     */
    readonly renderingProperties: MetricRenderingProperties;
    /**
     * (deprecated) How many seconds to aggregate over.
     *
     * @deprecated Use `period` in `renderingProperties`
     */
    readonly period: number;
    /**
     * (deprecated) Label for the metric.
     *
     * @deprecated Use `label` in `renderingProperties`
     */
    readonly label?: string;
    /**
     * (deprecated) Color for the graph line.
     *
     * @deprecated Use `color` in `renderingProperties`
     */
    readonly color?: string;
    /**
     * (deprecated) Aggregation function to use (can be either simple or a percentile).
     *
     * @deprecated Use `stat` in `renderingProperties`
     */
    readonly statistic?: string;
    /**
     * (deprecated) The unit of the alarm.
     *
     * @deprecated not used in dashboard widgets
     */
    readonly unit?: Unit;
}
/**
 * (deprecated) Custom rendering properties that override the default rendering properties specified in the yAxis parameter of the widget object.
 *
 * @deprecated Replaced by MetricConfig.
 */
export interface MetricRenderingProperties {
    /**
     * (deprecated) How many seconds to aggregate over.
     *
     * @deprecated
     */
    readonly period: number;
    /**
     * (deprecated) Label for the metric.
     *
     * @deprecated
     */
    readonly label?: string;
    /**
     * (deprecated) The hex color code, prefixed with '#' (e.g. '#00ff00'), to use when this metric is rendered on a graph. The `Color` class has a set of standard colors that can be used here.
     *
     * @deprecated
     */
    readonly color?: string;
    /**
     * (deprecated) Aggregation function to use (can be either simple or a percentile).
     *
     * @deprecated
     */
    readonly stat?: string;
}
