"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Spacer = exports.Column = exports.Row = void 0;
const widget_1 = require("./widget");
// This file contains widgets that exist for layout purposes
/**
 * (experimental) A widget that contains other widgets in a horizontal row.
 *
 * Widgets will be laid out next to each other
 *
 * @experimental
 */
class Row {
    /**
     * @experimental
     */
    constructor(...widgets) {
        /**
         * Relative position of each widget inside this row
         */
        this.offsets = [];
        this.widgets = widgets;
        this.width = 0;
        this.height = 0;
        let x = 0;
        let y = 0;
        for (const widget of widgets) {
            // See if we need to horizontally wrap to add this widget
            if (x + widget.width > widget_1.GRID_WIDTH) {
                y = this.height;
                x = 0;
            }
            this.offsets.push({ x, y });
            this.width = Math.max(this.width, x + widget.width);
            this.height = Math.max(this.height, y + widget.height);
            x += widget.width;
        }
    }
    /**
     * (experimental) Place the widget at a given position.
     *
     * @experimental
     */
    position(x, y) {
        for (let i = 0; i < this.widgets.length; i++) {
            this.widgets[i].position(x + this.offsets[i].x, y + this.offsets[i].y);
        }
    }
    /**
     * (experimental) Return the widget JSON for use in the dashboard.
     *
     * @experimental
     */
    toJson() {
        const ret = [];
        for (const widget of this.widgets) {
            ret.push(...widget.toJson());
        }
        return ret;
    }
}
exports.Row = Row;
/**
 * (experimental) A widget that contains other widgets in a vertical column.
 *
 * Widgets will be laid out next to each other
 *
 * @experimental
 */
class Column {
    /**
     * @experimental
     */
    constructor(...widgets) {
        this.widgets = widgets;
        // There's no vertical wrapping so this one's a lot easier
        this.width = Math.max(...this.widgets.map(w => w.width));
        this.height = sum(...this.widgets.map(w => w.height));
    }
    /**
     * (experimental) Place the widget at a given position.
     *
     * @experimental
     */
    position(x, y) {
        let widgetY = y;
        for (const widget of this.widgets) {
            widget.position(x, widgetY);
            widgetY += widget.height;
        }
    }
    /**
     * (experimental) Return the widget JSON for use in the dashboard.
     *
     * @experimental
     */
    toJson() {
        const ret = [];
        for (const widget of this.widgets) {
            ret.push(...widget.toJson());
        }
        return ret;
    }
}
exports.Column = Column;
/**
 * (experimental) A widget that doesn't display anything but takes up space.
 *
 * @experimental
 */
class Spacer {
    /**
     * @experimental
     */
    constructor(props = {}) {
        this.width = props.width || 1;
        this.height = props.height || 1;
    }
    /**
     * (experimental) Place the widget at a given position.
     *
     * @experimental
     */
    position(_x, _y) {
        // Don't need to do anything, not a physical widget
    }
    /**
     * (experimental) Return the widget JSON for use in the dashboard.
     *
     * @experimental
     */
    toJson() {
        return [];
    }
}
exports.Spacer = Spacer;
/**
 * Return the sum of a list of numbers
 */
function sum(...xs) {
    let ret = 0;
    for (const x of xs) {
        ret += x;
    }
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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