import { IAlarm } from './alarm-base';
import { IMetric } from './metric-types';
import { ConcreteWidget } from './widget';
/**
 * (experimental) Basic properties for widgets that display metrics.
 *
 * @experimental
 */
export interface MetricWidgetProps {
    /**
     * (experimental) Title for the graph.
     *
     * @default - None
     * @experimental
     */
    readonly title?: string;
    /**
     * (experimental) The region the metrics of this graph should be taken from.
     *
     * @default - Current region
     * @experimental
     */
    readonly region?: string;
    /**
     * (experimental) Width of the widget, in a grid of 24 units wide.
     *
     * @default 6
     * @experimental
     */
    readonly width?: number;
    /**
     * (experimental) Height of the widget.
     *
     * @default - 6 for Alarm and Graph widgets.
     * 3 for single value widgets where most recent value of a metric is displayed.
     * @experimental
     */
    readonly height?: number;
}
/**
 * (experimental) Properties for a Y-Axis.
 *
 * @experimental
 */
export interface YAxisProps {
    /**
     * (experimental) The min value.
     *
     * @default 0
     * @experimental
     */
    readonly min?: number;
    /**
     * (experimental) The max value.
     *
     * @default - No maximum value
     * @experimental
     */
    readonly max?: number;
    /**
     * (experimental) The label.
     *
     * @default - No label
     * @experimental
     */
    readonly label?: string;
    /**
     * (experimental) Whether to show units.
     *
     * @default true
     * @experimental
     */
    readonly showUnits?: boolean;
}
/**
 * (experimental) Properties for an AlarmWidget.
 *
 * @experimental
 */
export interface AlarmWidgetProps extends MetricWidgetProps {
    /**
     * (experimental) The alarm to show.
     *
     * @experimental
     */
    readonly alarm: IAlarm;
    /**
     * (experimental) Left Y axis.
     *
     * @default - No minimum or maximum values for the left Y-axis
     * @experimental
     */
    readonly leftYAxis?: YAxisProps;
}
/**
 * (experimental) Display the metric associated with an alarm, including the alarm line.
 *
 * @experimental
 */
export declare class AlarmWidget extends ConcreteWidget {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: AlarmWidgetProps);
    /**
     * (experimental) Return the widget JSON for use in the dashboard.
     *
     * @experimental
     */
    toJson(): any[];
}
/**
 * (experimental) Properties for a GraphWidget.
 *
 * @experimental
 */
export interface GraphWidgetProps extends MetricWidgetProps {
    /**
     * (experimental) Metrics to display on left Y axis.
     *
     * @default - No metrics
     * @experimental
     */
    readonly left?: IMetric[];
    /**
     * (experimental) Metrics to display on right Y axis.
     *
     * @default - No metrics
     * @experimental
     */
    readonly right?: IMetric[];
    /**
     * (experimental) Annotations for the left Y axis.
     *
     * @default - No annotations
     * @experimental
     */
    readonly leftAnnotations?: HorizontalAnnotation[];
    /**
     * (experimental) Annotations for the right Y axis.
     *
     * @default - No annotations
     * @experimental
     */
    readonly rightAnnotations?: HorizontalAnnotation[];
    /**
     * (experimental) Whether the graph should be shown as stacked lines.
     *
     * @default false
     * @experimental
     */
    readonly stacked?: boolean;
    /**
     * (experimental) Left Y axis.
     *
     * @default - None
     * @experimental
     */
    readonly leftYAxis?: YAxisProps;
    /**
     * (experimental) Right Y axis.
     *
     * @default - None
     * @experimental
     */
    readonly rightYAxis?: YAxisProps;
    /**
     * (experimental) Position of the legend.
     *
     * @default - bottom
     * @experimental
     */
    readonly legendPosition?: LegendPosition;
    /**
     * (experimental) Whether the graph should show live data.
     *
     * @default false
     * @experimental
     */
    readonly liveData?: boolean;
}
/**
 * (experimental) A dashboard widget that displays metrics.
 *
 * @experimental
 */
export declare class GraphWidget extends ConcreteWidget {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: GraphWidgetProps);
    /**
     * (experimental) Return the widget JSON for use in the dashboard.
     *
     * @experimental
     */
    toJson(): any[];
}
/**
 * (experimental) Properties for a SingleValueWidget.
 *
 * @experimental
 */
export interface SingleValueWidgetProps extends MetricWidgetProps {
    /**
     * (experimental) Metrics to display.
     *
     * @experimental
     */
    readonly metrics: IMetric[];
    /**
     * (experimental) Whether to show the value from the entire time range.
     *
     * @default false
     * @experimental
     */
    readonly setPeriodToTimeRange?: boolean;
}
/**
 * (experimental) A dashboard widget that displays the most recent value for every metric.
 *
 * @experimental
 */
export declare class SingleValueWidget extends ConcreteWidget {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: SingleValueWidgetProps);
    /**
     * (experimental) Return the widget JSON for use in the dashboard.
     *
     * @experimental
     */
    toJson(): any[];
}
/**
 * (experimental) Horizontal annotation to be added to a graph.
 *
 * @experimental
 */
export interface HorizontalAnnotation {
    /**
     * (experimental) The value of the annotation.
     *
     * @experimental
     */
    readonly value: number;
    /**
     * (experimental) Label for the annotation.
     *
     * @default - No label
     * @experimental
     */
    readonly label?: string;
    /**
     * (experimental) The hex color code, prefixed with '#' (e.g. '#00ff00'), to be used for the annotation. The `Color` class has a set of standard colors that can be used here.
     *
     * @default - Automatic color
     * @experimental
     */
    readonly color?: string;
    /**
     * (experimental) Add shading above or below the annotation.
     *
     * @default No shading
     * @experimental
     */
    readonly fill?: Shading;
    /**
     * (experimental) Whether the annotation is visible.
     *
     * @default true
     * @experimental
     */
    readonly visible?: boolean;
}
/**
 * (experimental) Fill shading options that will be used with an annotation.
 *
 * @experimental
 */
export declare enum Shading {
    /**
     * (experimental) Don't add shading.
     *
     * @experimental
     */
    NONE = "none",
    /**
     * (experimental) Add shading above the annotation.
     *
     * @experimental
     */
    ABOVE = "above",
    /**
     * (experimental) Add shading below the annotation.
     *
     * @experimental
     */
    BELOW = "below"
}
/**
 * (experimental) A set of standard colours that can be used in annotations in a GraphWidget.
 *
 * @experimental
 */
export declare class Color {
    /**
     * (experimental) blue - hex #1f77b4.
     *
     * @experimental
     */
    static readonly BLUE = "#1f77b4";
    /**
     * (experimental) brown - hex #8c564b.
     *
     * @experimental
     */
    static readonly BROWN = "#8c564b";
    /**
     * (experimental) green - hex #2ca02c.
     *
     * @experimental
     */
    static readonly GREEN = "#2ca02c";
    /**
     * (experimental) grey - hex #7f7f7f.
     *
     * @experimental
     */
    static readonly GREY = "#7f7f7f";
    /**
     * (experimental) orange - hex #ff7f0e.
     *
     * @experimental
     */
    static readonly ORANGE = "#ff7f0e";
    /**
     * (experimental) pink - hex #e377c2.
     *
     * @experimental
     */
    static readonly PINK = "#e377c2";
    /**
     * (experimental) purple - hex #9467bd.
     *
     * @experimental
     */
    static readonly PURPLE = "#9467bd";
    /**
     * (experimental) red - hex #d62728.
     *
     * @experimental
     */
    static readonly RED = "#d62728";
}
/**
 * (experimental) The position of the legend on a GraphWidget.
 *
 * @experimental
 */
export declare enum LegendPosition {
    /**
     * (experimental) Legend appears below the graph (default).
     *
     * @experimental
     */
    BOTTOM = "bottom",
    /**
     * (experimental) Add shading above the annotation.
     *
     * @experimental
     */
    RIGHT = "right",
    /**
     * (experimental) Add shading below the annotation.
     *
     * @experimental
     */
    HIDDEN = "hidden"
}
