import { Construct } from "../../core";
import { IAlarm } from './alarm-base';
/**
 * (experimental) Interface for objects that can be the targets of CloudWatch alarm actions.
 *
 * @experimental
 */
export interface IAlarmAction {
    /**
     * (experimental) Return the properties required to send alarm actions to this CloudWatch alarm.
     *
     * @param scope root Construct that allows creating new Constructs.
     * @param alarm CloudWatch alarm that the action will target.
     * @experimental
     */
    bind(scope: Construct, alarm: IAlarm): AlarmActionConfig;
}
/**
 * (experimental) Properties for an alarm action.
 *
 * @experimental
 */
export interface AlarmActionConfig {
    /**
     * (experimental) Return the ARN that should be used for a CloudWatch Alarm action.
     *
     * @experimental
     */
    readonly alarmActionArn: string;
}
