import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::CloudTrail::Trail`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html
 * @external
 */
export interface CfnTrailProps {
    /**
     * `AWS::CloudTrail::Trail.IsLogging`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-islogging
     * @external
     */
    readonly isLogging: boolean | cdk.IResolvable;
    /**
     * `AWS::CloudTrail::Trail.S3BucketName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-s3bucketname
     * @external
     */
    readonly s3BucketName: string;
    /**
     * `AWS::CloudTrail::Trail.CloudWatchLogsLogGroupArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-cloudwatchlogsloggrouparn
     * @external
     */
    readonly cloudWatchLogsLogGroupArn?: string;
    /**
     * `AWS::CloudTrail::Trail.CloudWatchLogsRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-cloudwatchlogsrolearn
     * @external
     */
    readonly cloudWatchLogsRoleArn?: string;
    /**
     * `AWS::CloudTrail::Trail.EnableLogFileValidation`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-enablelogfilevalidation
     * @external
     */
    readonly enableLogFileValidation?: boolean | cdk.IResolvable;
    /**
     * `AWS::CloudTrail::Trail.EventSelectors`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-eventselectors
     * @external
     */
    readonly eventSelectors?: Array<CfnTrail.EventSelectorProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CloudTrail::Trail.IncludeGlobalServiceEvents`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-includeglobalserviceevents
     * @external
     */
    readonly includeGlobalServiceEvents?: boolean | cdk.IResolvable;
    /**
     * `AWS::CloudTrail::Trail.IsMultiRegionTrail`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-ismultiregiontrail
     * @external
     */
    readonly isMultiRegionTrail?: boolean | cdk.IResolvable;
    /**
     * `AWS::CloudTrail::Trail.KMSKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-kmskeyid
     * @external
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::CloudTrail::Trail.S3KeyPrefix`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-s3keyprefix
     * @external
     */
    readonly s3KeyPrefix?: string;
    /**
     * `AWS::CloudTrail::Trail.SnsTopicName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-snstopicname
     * @external
     */
    readonly snsTopicName?: string;
    /**
     * `AWS::CloudTrail::Trail.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::CloudTrail::Trail.TrailName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-trailname
     * @external
     */
    readonly trailName?: string;
}
/**
 * A CloudFormation `AWS::CloudTrail::Trail`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html
 * @external
 * @cloudformationResource AWS::CloudTrail::Trail
 */
export declare class CfnTrail extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudTrail::Trail";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute SnsTopicArn
     */
    readonly attrSnsTopicArn: string;
    /**
     * `AWS::CloudTrail::Trail.IsLogging`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-islogging
     * @external
     */
    isLogging: boolean | cdk.IResolvable;
    /**
     * `AWS::CloudTrail::Trail.S3BucketName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-s3bucketname
     * @external
     */
    s3BucketName: string;
    /**
     * `AWS::CloudTrail::Trail.CloudWatchLogsLogGroupArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-cloudwatchlogsloggrouparn
     * @external
     */
    cloudWatchLogsLogGroupArn: string | undefined;
    /**
     * `AWS::CloudTrail::Trail.CloudWatchLogsRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-cloudwatchlogsrolearn
     * @external
     */
    cloudWatchLogsRoleArn: string | undefined;
    /**
     * `AWS::CloudTrail::Trail.EnableLogFileValidation`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-enablelogfilevalidation
     * @external
     */
    enableLogFileValidation: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::CloudTrail::Trail.EventSelectors`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-eventselectors
     * @external
     */
    eventSelectors: Array<CfnTrail.EventSelectorProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::CloudTrail::Trail.IncludeGlobalServiceEvents`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-includeglobalserviceevents
     * @external
     */
    includeGlobalServiceEvents: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::CloudTrail::Trail.IsMultiRegionTrail`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-ismultiregiontrail
     * @external
     */
    isMultiRegionTrail: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::CloudTrail::Trail.KMSKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-kmskeyid
     * @external
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::CloudTrail::Trail.S3KeyPrefix`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-s3keyprefix
     * @external
     */
    s3KeyPrefix: string | undefined;
    /**
     * `AWS::CloudTrail::Trail.SnsTopicName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-snstopicname
     * @external
     */
    snsTopicName: string | undefined;
    /**
     * `AWS::CloudTrail::Trail.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::CloudTrail::Trail.TrailName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-trailname
     * @external
     */
    trailName: string | undefined;
    /**
     * Create a new `AWS::CloudTrail::Trail`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTrailProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::CloudTrail::Trail`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html
 * @external
 * @cloudformationResource AWS::CloudTrail::Trail
 */
export declare namespace CfnTrail {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-dataresource.html
     * @external
     */
    interface DataResourceProperty {
        /**
         * `CfnTrail.DataResourceProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-dataresource.html#cfn-cloudtrail-trail-dataresource-type
         * @external
         */
        readonly type: string;
        /**
         * `CfnTrail.DataResourceProperty.Values`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-dataresource.html#cfn-cloudtrail-trail-dataresource-values
         * @external
         */
        readonly values?: string[];
    }
}
/**
 * A CloudFormation `AWS::CloudTrail::Trail`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html
 * @external
 * @cloudformationResource AWS::CloudTrail::Trail
 */
export declare namespace CfnTrail {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-eventselector.html
     * @external
     */
    interface EventSelectorProperty {
        /**
         * `CfnTrail.EventSelectorProperty.DataResources`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-eventselector.html#cfn-cloudtrail-trail-eventselector-dataresources
         * @external
         */
        readonly dataResources?: Array<CfnTrail.DataResourceProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTrail.EventSelectorProperty.IncludeManagementEvents`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-eventselector.html#cfn-cloudtrail-trail-eventselector-includemanagementevents
         * @external
         */
        readonly includeManagementEvents?: boolean | cdk.IResolvable;
        /**
         * `CfnTrail.EventSelectorProperty.ReadWriteType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-eventselector.html#cfn-cloudtrail-trail-eventselector-readwritetype
         * @external
         */
        readonly readWriteType?: string;
    }
}
