import * as events from "../../aws-events";
import * as kms from "../../aws-kms";
import * as lambda from "../../aws-lambda";
import * as logs from "../../aws-logs";
import * as s3 from "../../aws-s3";
import * as sns from "../../aws-sns";
import { Resource } from "../../core";
import { Construct } from 'constructs';
/**
 * (experimental) Properties for an AWS CloudTrail trail.
 *
 * @experimental
 */
export interface TrailProps {
    /**
     * (experimental) For most services, events are recorded in the region where the action occurred.
     *
     * For global services such as AWS Identity and Access Management (IAM), AWS STS, Amazon CloudFront, and Route 53,
     * events are delivered to any trail that includes global services, and are logged as occurring in US East (N. Virginia) Region.
     *
     * @default true
     * @experimental
     */
    readonly includeGlobalServiceEvents?: boolean;
    /**
     * (experimental) Whether or not this trail delivers log files from multiple regions to a single S3 bucket for a single account.
     *
     * @default true
     * @experimental
     */
    readonly isMultiRegionTrail?: boolean;
    /**
     * (experimental) When an event occurs in your account, CloudTrail evaluates whether the event matches the settings for your trails.
     *
     * Only events that match your trail settings are delivered to your Amazon S3 bucket and Amazon CloudWatch Logs log group.
     *
     * This method sets the management configuration for this trail.
     *
     * Management events provide insight into management operations that are performed on resources in your AWS account.
     * These are also known as control plane operations.
     * Management events can also include non-API events that occur in your account.
     * For example, when a user logs in to your account, CloudTrail logs the ConsoleLogin event.
     *
     * @default ReadWriteType.ALL
     * @experimental
     */
    readonly managementEvents?: ReadWriteType;
    /**
     * (experimental) To determine whether a log file was modified, deleted, or unchanged after CloudTrail delivered it, you can use CloudTrail log file integrity validation.
     *
     * This feature is built using industry standard algorithms: SHA-256 for hashing and SHA-256 with RSA for digital signing.
     * This makes it computationally infeasible to modify, delete or forge CloudTrail log files without detection.
     * You can use the AWS CLI to validate the files in the location where CloudTrail delivered them.
     *
     * @default true
     * @experimental
     */
    readonly enableFileValidation?: boolean;
    /**
     * (experimental) If CloudTrail pushes logs to CloudWatch Logs in addition to S3.
     *
     * Disabled for cost out of the box.
     *
     * @default false
     * @experimental
     */
    readonly sendToCloudWatchLogs?: boolean;
    /**
     * (experimental) How long to retain logs in CloudWatchLogs.
     *
     * Ignored if sendToCloudWatchLogs is false or if cloudWatchLogGroup is set.
     *
     * @default logs.RetentionDays.ONE_YEAR
     * @experimental
     */
    readonly cloudWatchLogsRetention?: logs.RetentionDays;
    /**
     * (experimental) Log Group to which CloudTrail to push logs to.
     *
     * Ignored if sendToCloudWatchLogs is set to false.
     *
     * @default - a new log group is created and used.
     * @experimental
     */
    readonly cloudWatchLogGroup?: logs.ILogGroup;
    /**
     * (deprecated) The AWS Key Management Service (AWS KMS) key ID that you want to use to encrypt CloudTrail logs.
     *
     * @default - No encryption.
     * @deprecated - use encryptionKey instead.
     */
    readonly kmsKey?: kms.IKey;
    /**
     * (experimental) The AWS Key Management Service (AWS KMS) key ID that you want to use to encrypt CloudTrail logs.
     *
     * @default - No encryption.
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
    /**
     * (experimental) SNS topic that is notified when new log files are published.
     *
     * @default - No notifications.
     * @experimental
     */
    readonly snsTopic?: sns.ITopic;
    /**
     * (experimental) The name of the trail.
     *
     * We recoomend customers do not set an explicit name.
     *
     * @default - AWS CloudFormation generated name.
     * @experimental
     */
    readonly trailName?: string;
    /**
     * (experimental) An Amazon S3 object key prefix that precedes the name of all log files.
     *
     * @default - No prefix.
     * @experimental
     */
    readonly s3KeyPrefix?: string;
    /**
     * (experimental) The Amazon S3 bucket.
     *
     * @default - if not supplied a bucket will be created with all the correct permisions
     * @experimental
     */
    readonly bucket?: s3.IBucket;
}
/**
 * (experimental) Types of events that CloudTrail can log.
 *
 * @experimental
 */
export declare enum ReadWriteType {
    /**
     * (experimental) Read-only events include API operations that read your resources, but don't make changes.
     *
     * For example, read-only events include the Amazon EC2 DescribeSecurityGroups
     * and DescribeSubnets API operations.
     *
     * @experimental
     */
    READ_ONLY = "ReadOnly",
    /**
     * (experimental) Write-only events include API operations that modify (or might modify) your resources.
     *
     * For example, the Amazon EC2 RunInstances and TerminateInstances API
     * operations modify your instances.
     *
     * @experimental
     */
    WRITE_ONLY = "WriteOnly",
    /**
     * (experimental) All events.
     *
     * @experimental
     */
    ALL = "All",
    /**
     * (experimental) No events.
     *
     * @experimental
     */
    NONE = "None"
}
/**
 * (experimental) Cloud trail allows you to log events that happen in your AWS account For example:.
 *
 * import { CloudTrail } from '@aws-cdk/aws-cloudtrail'
 *
 * const cloudTrail = new CloudTrail(this, 'MyTrail');
 *
 * NOTE the above example creates an UNENCRYPTED bucket by default,
 * If you are required to use an Encrypted bucket you can supply a preconfigured bucket
 * via TrailProps
 *
 * @experimental
 */
export declare class Trail extends Resource {
    /**
     * (experimental) Create an event rule for when an event is recorded by any Trail in the account.
     *
     * Note that the event doesn't necessarily have to come from this Trail, it can
     * be captured from any one.
     *
     * Be sure to filter the event further down using an event pattern.
     *
     * @experimental
     */
    static onEvent(scope: Construct, id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) ARN of the CloudTrail trail i.e. arn:aws:cloudtrail:us-east-2:123456789012:trail/myCloudTrail.
     *
     * @experimental
     * @attribute true
     */
    readonly trailArn: string;
    /**
     * (experimental) ARN of the Amazon SNS topic that's associated with the CloudTrail trail, i.e. arn:aws:sns:us-east-2:123456789012:mySNSTopic.
     *
     * @experimental
     * @attribute true
     */
    readonly trailSnsTopicArn: string;
    /**
     * (experimental) The CloudWatch log group to which CloudTrail events are sent.
     *
     * `undefined` if `sendToCloudWatchLogs` property is false.
     *
     * @experimental
     */
    readonly logGroup?: logs.ILogGroup;
    private s3bucket;
    private eventSelectors;
    private topic;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: TrailProps);
    /**
     * (experimental) When an event occurs in your account, CloudTrail evaluates whether the event matches the settings for your trails.
     *
     * Only events that match your trail settings are delivered to your Amazon S3 bucket and Amazon CloudWatch Logs log group.
     *
     * This method adds an Event Selector for filtering events that match either S3 or Lambda function operations.
     *
     * Data events: These events provide insight into the resource operations performed on or within a resource.
     * These are also known as data plane operations.
     *
     * @param dataResourceValues the list of data resource ARNs to include in logging (maximum 250 entries).
     * @param options the options to configure logging of management and data events.
     * @experimental
     */
    addEventSelector(dataResourceType: DataResourceType, dataResourceValues: string[], options?: AddEventSelectorOptions): void;
    /**
     * (experimental) When an event occurs in your account, CloudTrail evaluates whether the event matches the settings for your trails.
     *
     * Only events that match your trail settings are delivered to your Amazon S3 bucket and Amazon CloudWatch Logs log group.
     *
     * This method adds a Lambda Data Event Selector for filtering events that match Lambda function operations.
     *
     * Data events: These events provide insight into the resource operations performed on or within a resource.
     * These are also known as data plane operations.
     *
     * @param handlers the list of lambda function handlers whose data events should be logged (maximum 250 entries).
     * @param options the options to configure logging of management and data events.
     * @experimental
     */
    addLambdaEventSelector(handlers: lambda.IFunction[], options?: AddEventSelectorOptions): void;
    /**
     * (experimental) Log all Lamda data events for all lambda functions the account.
     *
     * @default false
     * @see https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html
     * @experimental
     */
    logAllLambdaDataEvents(options?: AddEventSelectorOptions): void;
    /**
     * (experimental) When an event occurs in your account, CloudTrail evaluates whether the event matches the settings for your trails.
     *
     * Only events that match your trail settings are delivered to your Amazon S3 bucket and Amazon CloudWatch Logs log group.
     *
     * This method adds an S3 Data Event Selector for filtering events that match S3 operations.
     *
     * Data events: These events provide insight into the resource operations performed on or within a resource.
     * These are also known as data plane operations.
     *
     * @param s3Selector the list of S3 bucket with optional prefix to include in logging (maximum 250 entries).
     * @param options the options to configure logging of management and data events.
     * @experimental
     */
    addS3EventSelector(s3Selector: S3EventSelector[], options?: AddEventSelectorOptions): void;
    /**
     * (experimental) Log all S3 data events for all objects for all buckets in the account.
     *
     * @default false
     * @see https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html
     * @experimental
     */
    logAllS3DataEvents(options?: AddEventSelectorOptions): void;
    /**
     * (deprecated) Create an event rule for when an event is recorded by any Trail in the account.
     *
     * Note that the event doesn't necessarily have to come from this Trail, it can
     * be captured from any one.
     *
     * Be sure to filter the event further down using an event pattern.
     *
     * @deprecated - use Trail.onEvent()
     */
    onCloudTrailEvent(id: string, options?: events.OnEventOptions): events.Rule;
}
/**
 * (experimental) Options for adding an event selector.
 *
 * @experimental
 */
export interface AddEventSelectorOptions {
    /**
     * (experimental) Specifies whether to log read-only events, write-only events, or all events.
     *
     * @default ReadWriteType.All
     * @experimental
     */
    readonly readWriteType?: ReadWriteType;
    /**
     * (experimental) Specifies whether the event selector includes management events for the trail.
     *
     * @default true
     * @experimental
     */
    readonly includeManagementEvents?: boolean;
}
/**
 * (experimental) Selecting an S3 bucket and an optional prefix to be logged for data events.
 *
 * @experimental
 */
export interface S3EventSelector {
    /**
     * (experimental) S3 bucket.
     *
     * @experimental
     */
    readonly bucket: s3.IBucket;
    /**
     * (experimental) Data events for objects whose key matches this prefix will be logged.
     *
     * @default - all objects
     * @experimental
     */
    readonly objectPrefix?: string;
}
/**
 * (experimental) Resource type for a data event.
 *
 * @experimental
 */
export declare enum DataResourceType {
    /**
     * (experimental) Data resource type for Lambda function.
     *
     * @experimental
     */
    LAMBDA_FUNCTION = "AWS::Lambda::Function",
    /**
     * (experimental) Data resource type for S3 objects.
     *
     * @experimental
     */
    S3_OBJECT = "AWS::S3::Object"
}
