import * as iam from "../../aws-iam";
import * as cdk from "../../core";
import { Construct } from 'constructs';
/**
 * (experimental) Properties of CloudFront OriginAccessIdentity.
 *
 * @experimental
 */
export interface OriginAccessIdentityProps {
    /**
     * (experimental) Any comments you want to include about the origin access identity.
     *
     * @default "Allows CloudFront to reach the bucket"
     * @experimental
     */
    readonly comment?: string;
}
/**
 * (experimental) Interface for CloudFront OriginAccessIdentity.
 *
 * @experimental
 */
export interface IOriginAccessIdentity extends cdk.IResource, iam.IGrantable {
    /**
     * (experimental) The Origin Access Identity Name.
     *
     * @experimental
     */
    readonly originAccessIdentityName: string;
}
declare abstract class OriginAccessIdentityBase extends cdk.Resource {
    /**
     * The Origin Access Identity Name (physical id)
     */
    abstract readonly originAccessIdentityName: string;
    /**
     * Derived principal value for bucket access
     */
    abstract readonly grantPrincipal: iam.IPrincipal;
    /**
     * (experimental) The ARN to include in S3 bucket policy to allow CloudFront access.
     *
     * @experimental
     */
    protected arn(): string;
}
/**
 * (experimental) An origin access identity is a special CloudFront user that you can associate with Amazon S3 origins, so that you can secure all or just some of your Amazon S3 content.
 *
 * @experimental
 * @resource AWS::CloudFront::CloudFrontOriginAccessIdentity
 */
export declare class OriginAccessIdentity extends OriginAccessIdentityBase implements IOriginAccessIdentity {
    /**
     * (experimental) Creates a OriginAccessIdentity by providing the OriginAccessIdentityName.
     *
     * @experimental
     */
    static fromOriginAccessIdentityName(scope: Construct, id: string, originAccessIdentityName: string): IOriginAccessIdentity;
    /**
     * (experimental) The Amazon S3 canonical user ID for the origin access identity, used when giving the origin access identity read permission to an object in Amazon S3.
     *
     * @experimental
     * @attribute true
     */
    readonly cloudFrontOriginAccessIdentityS3CanonicalUserId: string;
    /**
     * (experimental) Derived principal value for bucket access.
     *
     * @experimental
     */
    readonly grantPrincipal: iam.IPrincipal;
    /**
     * (experimental) The Origin Access Identity Name (physical id).
     *
     * @experimental
     * @attribute true
     */
    readonly originAccessIdentityName: string;
    /**
     * CDK L1 resource
     */
    private readonly resource;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: OriginAccessIdentityProps);
}
export {};
