import { Construct, Duration } from "../../core";
import { CfnDistribution } from './cloudfront.generated';
/**
 * (experimental) The failover configuration used for Origin Groups, returned in {@link OriginBindConfig.failoverConfig}.
 *
 * @experimental
 */
export interface OriginFailoverConfig {
    /**
     * (experimental) The origin to use as the fallback origin.
     *
     * @experimental
     */
    readonly failoverOrigin: IOrigin;
    /**
     * (experimental) The HTTP status codes of the response that trigger querying the failover Origin.
     *
     * @default - 500, 502, 503 and 504
     * @experimental
     */
    readonly statusCodes?: number[];
}
/**
 * (experimental) The struct returned from {@link IOrigin.bind}.
 *
 * @experimental
 */
export interface OriginBindConfig {
    /**
     * (experimental) The CloudFormation OriginProperty configuration for this Origin.
     *
     * @default - nothing is returned
     * @experimental
     */
    readonly originProperty?: CfnDistribution.OriginProperty;
    /**
     * (experimental) The failover configuration for this Origin.
     *
     * @default - nothing is returned
     * @experimental
     */
    readonly failoverConfig?: OriginFailoverConfig;
}
/**
 * (experimental) Represents the concept of a CloudFront Origin.
 *
 * You provide one or more origins when creating a Distribution.
 *
 * @experimental
 */
export interface IOrigin {
    /**
     * (experimental) The method called when a given Origin is added (for the first time) to a Distribution.
     *
     * @experimental
     */
    bind(scope: Construct, options: OriginBindOptions): OriginBindConfig;
}
/**
 * (experimental) Properties to define an Origin.
 *
 * @experimental
 */
export interface OriginProps {
    /**
     * (experimental) An optional path that CloudFront appends to the origin domain name when CloudFront requests content from the origin.
     *
     * Must begin, but not end, with '/' (e.g., '/production/images').
     *
     * @default '/'
     * @experimental
     */
    readonly originPath?: string;
    /**
     * (experimental) The number of seconds that CloudFront waits when trying to establish a connection to the origin.
     *
     * Valid values are 1-10 seconds, inclusive.
     *
     * @default Duration.seconds(10)
     * @experimental
     */
    readonly connectionTimeout?: Duration;
    /**
     * (experimental) The number of times that CloudFront attempts to connect to the origin;
     *
     * valid values are 1, 2, or 3 attempts.
     *
     * @default 3
     * @experimental
     */
    readonly connectionAttempts?: number;
    /**
     * (experimental) A list of HTTP header names and values that CloudFront adds to requests it sends to the origin.
     *
     * @default {}
     * @experimental
     */
    readonly customHeaders?: Record<string, string>;
}
/**
 * (experimental) Options passed to Origin.bind().
 *
 * @experimental
 */
export interface OriginBindOptions {
    /**
     * (experimental) The identifier of this Origin, as assigned by the Distribution this Origin has been used added to.
     *
     * @experimental
     */
    readonly originId: string;
}
/**
 * (experimental) Represents a distribution origin, that describes the Amazon S3 bucket, HTTP server (for example, a web server), Amazon MediaStore, or other server from which CloudFront gets your files.
 *
 * @experimental
 */
export declare abstract class OriginBase implements IOrigin {
    private readonly domainName;
    private readonly originPath?;
    private readonly connectionTimeout?;
    private readonly connectionAttempts?;
    private readonly customHeaders?;
    /**
     * @experimental
     */
    protected constructor(domainName: string, props?: OriginProps);
    /**
     * (experimental) Binds the origin to the associated Distribution.
     *
     * Can be used to grant permissions, create dependent resources, etc.
     *
     * @experimental
     */
    bind(_scope: Construct, options: OriginBindOptions): OriginBindConfig;
    /**
     * @experimental
     */
    protected renderS3OriginConfig(): CfnDistribution.S3OriginConfigProperty | undefined;
    /**
     * @experimental
     */
    protected renderCustomOriginConfig(): CfnDistribution.CustomOriginConfigProperty | undefined;
    private renderCustomHeaders;
    /**
     * If the path is defined, it must start with a '/' and not end with a '/'.
     * This method takes in the originPath, and returns it back (if undefined) or adds/removes the '/' as appropriate.
     */
    private validateOriginPath;
}
