"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3Origin = void 0;
const cloudfront = require("../../aws-cloudfront"); // Automatically re-written from '@aws-cdk/aws-cloudfront'
const http_origin_1 = require("./http-origin");
/**
 * (experimental) An Origin that is backed by an S3 bucket.
 *
 * If the bucket is configured for website hosting, this origin will be configured to use the bucket as an
 * HTTP server origin and will use the bucket's configured website redirects and error handling. Otherwise,
 * the origin is created as a bucket origin and will use CloudFront's redirect and error handling.
 *
 * @experimental
 */
class S3Origin {
    /**
     * @experimental
     */
    constructor(bucket, props = {}) {
        this.origin = bucket.isWebsite ?
            new http_origin_1.HttpOrigin(bucket.bucketWebsiteDomainName, {
                protocolPolicy: cloudfront.OriginProtocolPolicy.HTTP_ONLY,
                ...props,
            }) :
            new S3BucketOrigin(bucket, props);
    }
    /**
     * (experimental) The method called when a given Origin is added (for the first time) to a Distribution.
     *
     * @experimental
     */
    bind(scope, options) {
        return this.origin.bind(scope, options);
    }
}
exports.S3Origin = S3Origin;
/**
 * An Origin specific to a S3 bucket (not configured for website hosting).
 *
 * Contains additional logic around bucket permissions and origin access identities.
 */
class S3BucketOrigin extends cloudfront.OriginBase {
    constructor(bucket, props) {
        super(bucket.bucketRegionalDomainName, props);
        this.bucket = bucket;
    }
    bind(scope, options) {
        if (!this.originAccessIdentity) {
            this.originAccessIdentity = new cloudfront.OriginAccessIdentity(scope, 'S3Origin', {
                comment: `Identity for ${options.originId}`,
            });
            this.bucket.grantRead(this.originAccessIdentity);
        }
        return super.bind(scope, options);
    }
    renderS3OriginConfig() {
        return { originAccessIdentity: `origin-access-identity/cloudfront/${this.originAccessIdentity.originAccessIdentityName}` };
    }
}
//# sourceMappingURL=data:application/json;base64,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