import * as cloudfront from "../../aws-cloudfront";
import * as s3 from "../../aws-s3";
import * as cdk from "../../core";
/**
 * (experimental) Properties to use to customize an S3 Origin.
 *
 * @experimental
 */
export interface S3OriginProps {
    /**
     * (experimental) An optional path that CloudFront appends to the origin domain name when CloudFront requests content from the origin.
     *
     * Must begin, but not end, with '/' (e.g., '/production/images').
     *
     * @default '/'
     * @experimental
     */
    readonly originPath?: string;
}
/**
 * (experimental) An Origin that is backed by an S3 bucket.
 *
 * If the bucket is configured for website hosting, this origin will be configured to use the bucket as an
 * HTTP server origin and will use the bucket's configured website redirects and error handling. Otherwise,
 * the origin is created as a bucket origin and will use CloudFront's redirect and error handling.
 *
 * @experimental
 */
export declare class S3Origin implements cloudfront.IOrigin {
    private readonly origin;
    /**
     * @experimental
     */
    constructor(bucket: s3.IBucket, props?: S3OriginProps);
    /**
     * (experimental) The method called when a given Origin is added (for the first time) to a Distribution.
     *
     * @experimental
     */
    bind(scope: cdk.Construct, options: cloudfront.OriginBindOptions): cloudfront.OriginBindConfig;
}
