import * as sns from "../../aws-sns";
import * as core from "../../core";
/**
 * (experimental) Initialization props for the `NestedStack` construct.
 *
 * @experimental
 */
export interface NestedStackProps {
    /**
     * (experimental) The set value pairs that represent the parameters passed to CloudFormation when this nested stack is created.
     *
     * Each parameter has a name corresponding
     * to a parameter defined in the embedded template and a value representing
     * the value that you want to set for the parameter.
     *
     * The nested stack construct will automatically synthesize parameters in order
     * to bind references from the parent stack(s) into the nested stack.
     *
     * @default - no user-defined parameters are passed to the nested stack
     * @experimental
     */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
     * (experimental) The length of time that CloudFormation waits for the nested stack to reach the CREATE_COMPLETE state.
     *
     * When CloudFormation detects that the nested stack has reached the
     * CREATE_COMPLETE state, it marks the nested stack resource as
     * CREATE_COMPLETE in the parent stack and resumes creating the parent stack.
     * If the timeout period expires before the nested stack reaches
     * CREATE_COMPLETE, CloudFormation marks the nested stack as failed and rolls
     * back both the nested stack and parent stack.
     *
     * @default - no timeout
     * @experimental
     */
    readonly timeout?: core.Duration;
    /**
     * (experimental) The Simple Notification Service (SNS) topics to publish stack related events.
     *
     * @default - notifications are not sent for this stack.
     * @experimental
     */
    readonly notifications?: sns.ITopic[];
}
/**
 * (experimental) A CloudFormation nested stack.
 *
 * When you apply template changes to update a top-level stack, CloudFormation
 * updates the top-level stack and initiates an update to its nested stacks.
 * CloudFormation updates the resources of modified nested stacks, but does not
 * update the resources of unmodified nested stacks.
 *
 * Furthermore, this stack will not be treated as an independent deployment
 * artifact (won't be listed in "cdk list" or deployable through "cdk deploy"),
 * but rather only synthesized as a template and uploaded as an asset to S3.
 *
 * Cross references of resource attributes between the parent stack and the
 * nested stack will automatically be translated to stack parameters and
 * outputs.
 *
 * @experimental
 */
export declare class NestedStack extends core.NestedStack {
    /**
     * @experimental
     */
    constructor(scope: core.Construct, id: string, props?: NestedStackProps);
}
