import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::Chatbot::SlackChannelConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-slackchannelconfiguration.html
 * @external
 */
export interface CfnSlackChannelConfigurationProps {
    /**
     * `AWS::Chatbot::SlackChannelConfiguration.ConfigurationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-slackchannelconfiguration.html#cfn-chatbot-slackchannelconfiguration-configurationname
     * @external
     */
    readonly configurationName: string;
    /**
     * `AWS::Chatbot::SlackChannelConfiguration.IamRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-slackchannelconfiguration.html#cfn-chatbot-slackchannelconfiguration-iamrolearn
     * @external
     */
    readonly iamRoleArn: string;
    /**
     * `AWS::Chatbot::SlackChannelConfiguration.SlackChannelId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-slackchannelconfiguration.html#cfn-chatbot-slackchannelconfiguration-slackchannelid
     * @external
     */
    readonly slackChannelId: string;
    /**
     * `AWS::Chatbot::SlackChannelConfiguration.SlackWorkspaceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-slackchannelconfiguration.html#cfn-chatbot-slackchannelconfiguration-slackworkspaceid
     * @external
     */
    readonly slackWorkspaceId: string;
    /**
     * `AWS::Chatbot::SlackChannelConfiguration.LoggingLevel`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-slackchannelconfiguration.html#cfn-chatbot-slackchannelconfiguration-logginglevel
     * @external
     */
    readonly loggingLevel?: string;
    /**
     * `AWS::Chatbot::SlackChannelConfiguration.SnsTopicArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-slackchannelconfiguration.html#cfn-chatbot-slackchannelconfiguration-snstopicarns
     * @external
     */
    readonly snsTopicArns?: string[];
}
/**
 * A CloudFormation `AWS::Chatbot::SlackChannelConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-slackchannelconfiguration.html
 * @external
 * @cloudformationResource AWS::Chatbot::SlackChannelConfiguration
 */
export declare class CfnSlackChannelConfiguration extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Chatbot::SlackChannelConfiguration";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::Chatbot::SlackChannelConfiguration.ConfigurationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-slackchannelconfiguration.html#cfn-chatbot-slackchannelconfiguration-configurationname
     * @external
     */
    configurationName: string;
    /**
     * `AWS::Chatbot::SlackChannelConfiguration.IamRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-slackchannelconfiguration.html#cfn-chatbot-slackchannelconfiguration-iamrolearn
     * @external
     */
    iamRoleArn: string;
    /**
     * `AWS::Chatbot::SlackChannelConfiguration.SlackChannelId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-slackchannelconfiguration.html#cfn-chatbot-slackchannelconfiguration-slackchannelid
     * @external
     */
    slackChannelId: string;
    /**
     * `AWS::Chatbot::SlackChannelConfiguration.SlackWorkspaceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-slackchannelconfiguration.html#cfn-chatbot-slackchannelconfiguration-slackworkspaceid
     * @external
     */
    slackWorkspaceId: string;
    /**
     * `AWS::Chatbot::SlackChannelConfiguration.LoggingLevel`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-slackchannelconfiguration.html#cfn-chatbot-slackchannelconfiguration-logginglevel
     * @external
     */
    loggingLevel: string | undefined;
    /**
     * `AWS::Chatbot::SlackChannelConfiguration.SnsTopicArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-slackchannelconfiguration.html#cfn-chatbot-slackchannelconfiguration-snstopicarns
     * @external
     */
    snsTopicArns: string[] | undefined;
    /**
     * Create a new `AWS::Chatbot::SlackChannelConfiguration`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSlackChannelConfigurationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
