"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JobDefinitionImageConfig = void 0;
const ecs = require("../../aws-ecs"); // Automatically re-written from '@aws-cdk/aws-ecs'
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
/**
 * Batch Job Task Definition
 *
 * Defines a Batch Job Task Definition. The properties of this task definition mirrors
 * those of an {@link ecs.ContainerDefinition}. This class is a wrapper on that structure.
 */
class TaskDefinition {
    constructor(props) {
        this.executionRole = props.executionRole;
    }
    /**
     * Internal function to allow the Batch Job task defintion
     * to match the CDK requirements of an EC2 task definition.
     *
     * @internal
     */
    _linkContainer() { }
    /**
     * Retrieves the execution role for this task definition
     */
    obtainExecutionRole() {
        return this.executionRole;
    }
}
/**
 * The configuration for creating a batch container image.
 */
class JobDefinitionImageConfig {
    constructor(scope, container) {
        const config = this.bindImageConfig(scope, container);
        this.imageName = config.imageName;
    }
    bindImageConfig(scope, container) {
        return container.image.bind(scope, new ecs.ContainerDefinition(scope, 'Resource-Batch-Job-Container-Definition', {
            command: container.command,
            cpu: container.vcpus,
            image: container.image,
            environment: container.environment,
            linuxParameters: container.linuxParams,
            memoryLimitMiB: container.memoryLimitMiB,
            privileged: container.privileged,
            readonlyRootFilesystem: container.readOnly,
            gpuCount: container.gpuCount,
            user: container.user,
            taskDefinition: new TaskDefinition({
                executionRole: container.jobRole || new iam.LazyRole(scope, 'Resource-Batch-Task-Definition-Role', {
                    assumedBy: new iam.ServicePrincipal('batch.amazonaws.com'),
                }),
            }),
        }));
    }
}
exports.JobDefinitionImageConfig = JobDefinitionImageConfig;
//# sourceMappingURL=data:application/json;base64,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